/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SelectTracesOperationTest {
    private TmfExperimentElement fExperiment;
    private @NonNull TmfTraceElement[] fTraces = new TmfTraceElement[6];
    private TmfTraceElement[] fExpectedTimeRangeTraces = new TmfTraceElement[4];
    private final String EXPERIMENT_NAME = "test_select_trace";
    private static TmfProjectElement fProjectElement;
    private ITmfTimestamp fStartTimeRange;
    private ITmfTimestamp fEndTimeRange;

    @BeforeClass
    public static void beforeClass() {
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.locale", Locale.US.toLanguageTag());
        TmfTimestampFormat.updateDefaultFormats();
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() throws ParseException, CoreException {
        void var5_12;
        void var5_10;
        IProject project = TmfProjectRegistry.createProject((String)"Experiment Select Trace Test Project", null, null);
        fProjectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tmfTracesFolder = fProjectElement.getTracesFolder();
        Assert.assertNotNull((Object)tmfTracesFolder);
        IFolder traceFolder = tmfTracesFolder.getResource();
        ArrayList<Path> tracePaths = new ArrayList<Path>();
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_1.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_2.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_3.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_4.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_5.getFullPath()));
        tracePaths.add(new Path(TmfTestTrace.SYSLOG_6.getFullPath()));
        for (IPath iPath : tracePaths) {
            IResource traceResource = TmfImportHelper.createLink((IFolder)traceFolder, (IPath)iPath, (String)iPath.lastSegment());
            traceResource.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog");
        }
        for (TmfTraceElement tmfTraceElement : tmfTracesFolder.getTraces()) {
            tmfTraceElement.refreshTraceType();
        }
        fProjectElement.refresh();
        boolean bl = false;
        while (var5_10 < this.fTraces.length) {
            this.fTraces[var5_10] = Objects.requireNonNull((TmfTraceElement)tmfTracesFolder.getTraces().get((int)var5_10));
            ++var5_10;
        }
        boolean bl2 = false;
        while (var5_12 < this.fExpectedTimeRangeTraces.length) {
            this.fExpectedTimeRangeTraces[var5_12] = this.fTraces[var5_12];
            ++var5_12;
        }
        this.fStartTimeRange = SelectTracesOperationTest.parse("Jan 1 02:00:00");
        this.fEndTimeRange = SelectTracesOperationTest.parse("Jan 1 05:05:00");
        this.fExperiment = ProjectModelTestData.addExperiment(fProjectElement, "test_select_trace");
    }

    private static ITmfTimestamp parse(String time) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss", TmfTimePreferences.getLocale());
        dateFormat.setTimeZone(TmfTimestampFormat.getDefaulTimeFormat().getTimeZone());
        Date date = dateFormat.parse(time);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(1, Calendar.getInstance().get(1));
        if (calendar.after(Calendar.getInstance())) {
            calendar.set(1, Calendar.getInstance().get(1) - 1);
        }
        return TmfTimestamp.fromMillis((long)calendar.getTimeInMillis());
    }

    @After
    public void cleanUp() {
        TmfExperimentFolder experimentsFolder = fProjectElement.getExperimentsFolder();
        if (experimentsFolder != null) {
            IFolder experimentResource = this.fExperiment.getResource();
            IPath path = experimentResource.getLocation();
            if (path != null) {
                this.fExperiment.deleteSupplementaryFolder();
            }
            try {
                experimentResource.delete(true, null);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Unable to delete experiment: " + this.fExperiment.getName(), (Throwable)e);
            }
        }
    }

    @Test
    public void testBasicOperation() throws Exception {
        Assert.assertNotNull((Object)this.fExperiment);
        Assert.assertNotNull((Object)this.fTraces);
        SelectTracesOperation selectTracesOperation = new SelectTracesOperation(Objects.requireNonNull(this.fExperiment), this.fTraces, new HashMap());
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)selectTracesOperation);
        SelectTracesOperationTest.assertExperimentTraces(this.fTraces, this.fExperiment.getTraces());
    }

    @Test
    public void testOperationTimeRange() throws Exception {
        Assert.assertNotNull((Object)this.fExperiment);
        Assert.assertNotNull((Object)this.fTraces);
        SelectTracesOperation selectTracesOperation = new SelectTracesOperation(Objects.requireNonNull(this.fExperiment), this.fTraces, new HashMap(), this.fStartTimeRange, this.fEndTimeRange);
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)selectTracesOperation);
        SelectTracesOperationTest.assertExperimentTraces(this.fExpectedTimeRangeTraces, this.fExperiment.getTraces());
    }

    private static void assertExperimentTraces(TmfTraceElement[] expectedTraces, List<TmfTraceElement> actualTraces) {
        Assert.assertEquals((long)expectedTraces.length, (long)actualTraces.size());
        int i = 0;
        while (i < expectedTraces.length) {
            Assert.assertEquals((Object)expectedTraces[i], (Object)actualTraces.get(i).getElementUnderTraceFolder());
            ++i;
        }
    }
}

