/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.ArrayList;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.envvar.BuildSystemEnvironmentSupplier;
import org.eclipse.cdt.internal.core.envvar.DefaultEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.EclipseEnvironmentSupplier;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.Messages;
import org.eclipse.cdt.internal.core.envvar.UserDefinedEnvironmentSupplier;

public class ContributedEnvironment
implements IContributedEnvironment {
    private EnvironmentVariableManager fMngr;

    public ContributedEnvironment(EnvironmentVariableManager mngr) {
        this.fMngr = mngr;
    }

    public IEnvironmentContextInfo getContextInfo(Object context) {
        return new ContributedEnvContextInfo(this.fMngr.getDefaultContextInfo(context));
    }

    @Override
    public IEnvironmentVariable[] getVariables(ICConfigurationDescription des) {
        EnvVarCollector cr = EnvironmentVariableManager.getVariables(this.getContextInfo(des), true);
        if (cr != null) {
            EnvVarDescriptor[] collected = cr.toArray(true);
            ArrayList<EnvVarDescriptor> vars = new ArrayList<EnvVarDescriptor>(collected.length);
            DefaultEnvironmentContextInfo info = new DefaultEnvironmentContextInfo(des);
            int i = 0;
            while (i < collected.length) {
                EnvVarDescriptor var = collected[i];
                if ((var = EnvironmentVariableManager.getVariable(var.getName(), info, true)) != null) {
                    vars.add(var);
                }
                ++i;
            }
            return vars.toArray(new EnvVarDescriptor[vars.size()]);
        }
        return new EnvVarDescriptor[0];
    }

    @Override
    public IEnvironmentVariable getVariable(String name, ICConfigurationDescription des) {
        EnvVarDescriptor varDes = EnvironmentVariableManager.getVariable(name, this.getContextInfo(des), true);
        if (varDes != null) {
            return EnvironmentVariableManager.getVariable(name, new DefaultEnvironmentContextInfo(des), true);
        }
        return null;
    }

    @Override
    public boolean appendEnvironment(ICConfigurationDescription des) {
        return EnvironmentVariableManager.fUserSupplier.appendContributedEnvironment(des);
    }

    @Override
    public void setAppendEnvironment(boolean append, ICConfigurationDescription des) {
        EnvironmentVariableManager.fUserSupplier.setAppendContributedEnvironment(append, des);
    }

    @Override
    public IEnvironmentVariable addVariable(String name, String value, int op, String delimiter, ICConfigurationDescription des) {
        return new EnvVarDescriptor(EnvironmentVariableManager.fUserSupplier.createVariable(name, value, op, delimiter, des), null, -1, EnvironmentVariableManager.fUserSupplier);
    }

    @Override
    public void addVariables(IEnvironmentVariable[] vars, ICConfigurationDescription des) {
        IEnvironmentVariable[] iEnvironmentVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable v = iEnvironmentVariableArray[n2];
            this.addVariable(v, des);
            ++n2;
        }
    }

    @Override
    public IEnvironmentVariable addVariable(IEnvironmentVariable var, ICConfigurationDescription des) {
        return this.addVariable(var.getName(), var.getValue(), var.getOperation(), var.getDelimiter(), des);
    }

    @Override
    public IEnvironmentVariable removeVariable(String name, ICConfigurationDescription des) {
        return EnvironmentVariableManager.fUserSupplier.deleteVariable(name, des);
    }

    @Override
    public void restoreDefaults(ICConfigurationDescription des) {
        EnvironmentVariableManager.fUserSupplier.restoreDefaults(des);
    }

    @Override
    public boolean isUserVariable(ICConfigurationDescription des, IEnvironmentVariable var) {
        if (var instanceof EnvVarDescriptor) {
            return ((EnvVarDescriptor)var).getSupplier() == EnvironmentVariableManager.fUserSupplier;
        }
        return false;
    }

    public String getOrigin(IEnvironmentVariable var) {
        if (var instanceof EnvVarDescriptor) {
            ICoreEnvironmentVariableSupplier sup = ((EnvVarDescriptor)var).getSupplier();
            if (sup instanceof BuildSystemEnvironmentSupplier) {
                return Messages.getString("ContributedEnvironment.0");
            }
            if (sup instanceof EclipseEnvironmentSupplier) {
                return Messages.getString("ContributedEnvironment.1");
            }
            if (sup instanceof UserDefinedEnvironmentSupplier) {
                if (((EnvVarDescriptor)var).getContextInfo().getContext() != null) {
                    return Messages.getString("ContributedEnvironment.4");
                }
                return Messages.getString("ContributedEnvironment.2");
            }
        }
        return Messages.getString("ContributedEnvironment.3");
    }

    public void serialize(ICProjectDescription des) {
        EnvironmentVariableManager.fUserSupplier.storeProjectEnvironment(des, false);
    }

    private class ContributedEnvContextInfo
    extends DefaultEnvironmentContextInfo {
        private IEnvironmentContextInfo fBaseInfo;
        private ICoreEnvironmentVariableSupplier[] fSuppliers;

        public ContributedEnvContextInfo(IEnvironmentContextInfo info) {
            super(info.getContext());
            this.fBaseInfo = info;
        }

        @Override
        public ICoreEnvironmentVariableSupplier[] getSuppliers() {
            if (this.fSuppliers == null) {
                ICoreEnvironmentVariableSupplier[] suppliers = this.fBaseInfo.getSuppliers();
                int i = 0;
                while (i < suppliers.length) {
                    if (suppliers[i] == EnvironmentVariableManager.fEclipseSupplier) break;
                    ++i;
                }
                if (i != suppliers.length) {
                    ICoreEnvironmentVariableSupplier[] tmp = new ICoreEnvironmentVariableSupplier[suppliers.length - 1];
                    if (i != 0) {
                        System.arraycopy(suppliers, 0, tmp, 0, i);
                    }
                    if (i != tmp.length) {
                        System.arraycopy(suppliers, i + 1, tmp, i, tmp.length - i);
                    }
                    suppliers = tmp;
                }
                this.fSuppliers = suppliers;
            }
            return this.fSuppliers;
        }

        @Override
        public IEnvironmentContextInfo getNext() {
            IEnvironmentContextInfo baseNext = this.fBaseInfo.getNext();
            if (baseNext != null) {
                return new ContributedEnvContextInfo(baseNext);
            }
            return null;
        }
    }
}

