/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class ThreadEntryModel
extends TimeGraphEntryModel {
    private final int fThreadId;
    private final int fParentThreadId;
    private final @NonNull Multimap<@NonNull String, @NonNull Object> fAspects;
    private final int fProcessId;

    public ThreadEntryModel(long id, long parentId, @NonNull List<@NonNull String> labels, long start, long end, int tid, int ppid, int pid) {
        super(id, parentId, labels, start, end);
        this.fThreadId = tid;
        this.fParentThreadId = ppid;
        this.fAspects = HashMultimap.create();
        this.fAspects.put((Object)OsStrings.tid(), (Object)tid);
        this.fAspects.put((Object)OsStrings.ptid(), (Object)ppid);
        this.fProcessId = pid <= 0 ? tid : pid;
        this.fAspects.put((Object)OsStrings.pid(), (Object)this.fProcessId);
        if (!labels.isEmpty()) {
            this.fAspects.put((Object)OsStrings.execName(), (Object)String.valueOf(labels.get(0)));
        }
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public int getParentThreadId() {
        return this.fParentThreadId;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public @NonNull String toString() {
        return "<name=" + String.valueOf(this.getLabels()) + " id=" + this.getId() + " parentId=" + this.getParentId() + " start=" + this.getStartTime() + " end=" + this.getEndTime() + " TID=" + this.fThreadId + " PTID=" + this.fParentThreadId + ">";
    }

    public Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return this.fAspects;
    }

    public boolean hasRowModel() {
        return this.getParentId() != -1L;
    }

    public static final class Builder {
        private final long fId;
        private @NonNull List<@NonNull String> fLabels;
        private final long fStartTime;
        private long fEndTime;
        private final int fTid;
        private int fPpid;
        private int fPid;

        public Builder(long id, @NonNull List<@NonNull String> labels, long start, long end, int tid, int ppid, int pid) {
            this.fId = id;
            this.fLabels = labels;
            this.fStartTime = start;
            this.fEndTime = end;
            this.fTid = tid;
            this.fPpid = ppid;
            this.fPid = pid;
        }

        public long getId() {
            return this.fId;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public int getPpid() {
            return this.fPpid;
        }

        public void setName(@NonNull List<@NonNull String> name) {
            this.fLabels = name;
        }

        public void setEndTime(long endTime) {
            this.fEndTime = Long.max(this.fEndTime, endTime);
        }

        public void setPpid(int ppid) {
            this.fPpid = ppid;
        }

        public void setPid(int pid) {
            if (pid >= 0) {
                this.fPid = pid;
            }
        }

        public ThreadEntryModel build(long parentId) {
            return new ThreadEntryModel(this.fId, parentId, this.fLabels, this.fStartTime, this.fEndTime, this.fTid, this.fPpid, this.fPid);
        }
    }
}

