/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.latency;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.swtbot.tests.table.SegmentTableTest;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.SegmentStoreTableView;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCall;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SystemCallLatencyTableAnalysisTest
extends SegmentTableTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String PROJECT_NAME = "test";
    private static final String PRIMARY_VIEW_ID = "org.eclipse.tracecompass.analysis.timing.ui.segstore.table";
    private static final String SECONDARY_VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.latency.syscall";
    private static final SystemCallLatencyAnalysis fSystemCallLatencyAnalysis = new SystemCallLatencyAnalysis();
    private static final int TID = 10;
    private static final int RETURN_VALUE = 1;

    protected ISegmentStoreProvider getSegStoreProvider() {
        return fSystemCallLatencyAnalysis;
    }

    @AfterClass
    public static void afterClass() {
        fSystemCallLatencyAnalysis.dispose();
    }

    protected AbstractSegmentStoreTableView openTable() {
        SWTBotUtils.openView((String)PRIMARY_VIEW_ID, (String)SECONDARY_VIEW_ID);
        SWTBotView viewBot = fBot.viewById(PRIMARY_VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertTrue((String)"Could not instanciate view", (boolean)(viewPart instanceof SegmentStoreTableView));
        return (SegmentStoreTableView)viewPart;
    }

    protected @NonNull ISegment createSegment(long start, long end) {
        return new SystemCall(new SystemCall.InitialInfo(start, start % 3L == 0L ? "rightpad" : "leftpad", 10), end, 1);
    }

    @Test
    public void climbTest() {
        super.climbTest();
        SWTBotTable tableBot = new SWTBotTable(this.getTable().getTableViewer().getTable());
        tableBot.header("System Call").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"rightpad", (int)0, (int)3));
        tableBot.header("System Call").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"leftpad", (int)0, (int)3));
        tableBot.header("Duration").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"0", (int)0, (int)2));
        tableBot.header("Duration").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"99", (int)0, (int)2));
        tableBot.header("Start Time").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"99", (int)0, (int)2));
    }

    @Test
    public void testWithTrace() throws IOException {
        String tracePath = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL())).getAbsolutePath();
        SWTBotUtils.closeViewById((String)PRIMARY_VIEW_ID, (SWTWorkbenchBot)fBot);
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
        AbstractSegmentStoreTableView tableView = this.openTable();
        this.setTableView(tableView);
        AbstractSegmentStoreTableViewer table = tableView.getSegmentStoreViewer();
        Assert.assertNotNull((Object)table);
        this.setTable(table);
        WaitUtils.waitForJobs();
        SWTBotTable tableBot = new SWTBotTable(table.getTableViewer().getTable());
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"24,100", (int)0, (int)2));
        tableBot.header("Duration").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1,000", (int)0, (int)2));
        tableBot.header("Duration").click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"5,904,091,700", (int)0, (int)2));
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    protected void testTsv(String[] lines) {
        Assert.assertNotNull((Object)lines);
        Assert.assertEquals((String)"number of lines", (long)21L, (long)lines.length);
        Assert.assertEquals((String)"header", (Object)"Start Time\tEnd Time\tDuration\tSystem Call\tTID\tReturn value\tComponent\tFile", (Object)lines[0]);
        Assert.assertTrue((String)("line 1 : " + lines[1]), (boolean)lines[1].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s001\\t\\d\\d:\\d\\d:00.000 000 002\\t1\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 2 : " + lines[2]), (boolean)lines[2].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s002\\t\\d\\d:\\d\\d:00.000 000 006\\t4\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 3 : " + lines[3]), (boolean)lines[3].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s003\\t\\d\\d:\\d\\d:00.000 000 012\\t9\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 4 : " + lines[4]), (boolean)lines[4].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s004\\t\\d\\d:\\d\\d:00.000 000 020\\t16\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 5 : " + lines[5]), (boolean)lines[5].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s005\\t\\d\\d:\\d\\d:00.000 000 030\\t25\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 6 : " + lines[6]), (boolean)lines[6].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s006\\t\\d\\d:\\d\\d:00.000 000 042\\t36\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 7 : " + lines[7]), (boolean)lines[7].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s007\\t\\d\\d:\\d\\d:00.000 000 056\\t49\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 8 : " + lines[8]), (boolean)lines[8].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s008\\t\\d\\d:\\d\\d:00.000 000 072\\t64\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 9 : " + lines[9]), (boolean)lines[9].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s009\\t\\d\\d:\\d\\d:00.000 000 090\\t81\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 10 : " + lines[10]), (boolean)lines[10].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s010\\t\\d\\d:\\d\\d:00.000 000 110\\t100\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 11 : " + lines[11]), (boolean)lines[11].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s011\\t\\d\\d:\\d\\d:00.000 000 132\\t121\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 12 : " + lines[12]), (boolean)lines[12].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s012\\t\\d\\d:\\d\\d:00.000 000 156\\t144\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 13 : " + lines[13]), (boolean)lines[13].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s013\\t\\d\\d:\\d\\d:00.000 000 182\\t169\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 14 : " + lines[14]), (boolean)lines[14].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s014\\t\\d\\d:\\d\\d:00.000 000 210\\t196\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 15 : " + lines[15]), (boolean)lines[15].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s015\\t\\d\\d:\\d\\d:00.000 000 240\\t225\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 16 : " + lines[16]), (boolean)lines[16].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s016\\t\\d\\d:\\d\\d:00.000 000 272\\t256\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 17 : " + lines[17]), (boolean)lines[17].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s017\\t\\d\\d:\\d\\d:00.000 000 306\\t289\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 18 : " + lines[18]), (boolean)lines[18].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s018\\t\\d\\d:\\d\\d:00.000 000 342\\t324\\trightpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 19 : " + lines[19]), (boolean)lines[19].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s019\\t\\d\\d:\\d\\d:00.000 000 380\\t361\\tleftpad\\t10\\t1\\t\\t"));
        Assert.assertTrue((String)("line 20 : " + lines[20]), (boolean)lines[20].matches("\\d\\d:\\d\\d:00\\.000\\s000\\s020\\t\\d\\d:\\d\\d:00.000 000 420\\t400\\tleftpad\\t10\\t1\\t\\t"));
    }
}

