/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.internal.vectorization.DefaultVectorizationProvider;
import org.apache.lucene.internal.vectorization.VectorUtilSupport;
import org.apache.lucene.util.Constants;

public abstract class VectorizationProvider {
    static final OptionalInt TESTS_VECTOR_SIZE;
    static final boolean TESTS_FORCE_INTEGER_VECTORS;
    private static final Logger LOG;
    private static final Runtime.Version VERSION_JDK8301190_FIXED;
    private static final Set<String> VALID_CALLERS;

    public static VectorizationProvider getInstance() {
        VectorizationProvider.ensureCaller();
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    VectorizationProvider() {
    }

    public abstract VectorUtilSupport getVectorUtilSupport();

    public abstract FlatVectorsScorer getLucene99FlatVectorsScorer();

    static VectorizationProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 20 && runtimeVersion <= 22) {
            if (VectorizationProvider.isAffectedByJDK8301190()) {
                LOG.warning("Java runtime is using a buggy default locale; Java vector incubator API can't be enabled: " + Locale.getDefault());
                return new DefaultVectorizationProvider();
            }
            if (!Constants.IS_HOTSPOT_VM) {
                LOG.warning("Java runtime is not using Hotspot VM; Java vector incubator API can't be enabled.");
                return new DefaultVectorizationProvider();
            }
            if (Constants.IS_JVMCI_VM) {
                LOG.warning("Java runtime is using JVMCI Compiler; Java vector incubator API can't be enabled.");
                return new DefaultVectorizationProvider();
            }
            Optional<Module> vectorMod = VectorizationProvider.lookupVectorModule();
            if (vectorMod.isEmpty()) {
                LOG.warning("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new DefaultVectorizationProvider();
            }
            vectorMod.ifPresent(VectorizationProvider.class.getModule()::addReads);
            if (!testMode) {
                if (TESTS_VECTOR_SIZE.isPresent() || TESTS_FORCE_INTEGER_VECTORS) {
                    LOG.warning("Vector bitsize and/or integer vectors enforcement; using default vectorization provider outside of testMode");
                    return new DefaultVectorizationProvider();
                }
                if (Constants.IS_CLIENT_VM) {
                    LOG.warning("C2 compiler is disabled; Java vector incubator API can't be enabled");
                    return new DefaultVectorizationProvider();
                }
            }
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> cls = lookup.findClass("org.apache.lucene.internal.vectorization.PanamaVectorizationProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE));
                try {
                    return constr.invoke();
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.warning("Java vector incubator API was not enabled. " + uoe.getMessage());
                    return new DefaultVectorizationProvider();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LinkageError("PanamaVectorizationProvider is missing correctly typed constructor", e);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("PanamaVectorizationProvider is missing in Lucene JAR file", cnfe);
            }
        }
        if (runtimeVersion >= 23) {
            LOG.warning("You are running with Java 23 or later. To make full use of the Vector API, please update Apache Lucene.");
        } else if (VectorizationProvider.lookupVectorModule().isPresent()) {
            LOG.warning("Java vector incubator module was enabled by command line flags, but your Java version is too old: " + runtimeVersion);
        }
        return new DefaultVectorizationProvider();
    }

    private static Optional<Module> lookupVectorModule() {
        return Optional.ofNullable(VectorizationProvider.class.getModule().getLayer()).orElse(ModuleLayer.boot()).findModule("jdk.incubator.vector");
    }

    private static boolean isAffectedByJDK8301190() {
        return VERSION_JDK8301190_FIXED.compareToIgnoreOptional(Runtime.version()) > 0 && !Objects.equals("I", "i".toUpperCase(Locale.getDefault()));
    }

    private static void ensureCaller() {
        boolean validCaller = StackWalker.getInstance().walk(s -> s.skip(2L).limit(1L).map(StackWalker.StackFrame::getClassName).allMatch(VALID_CALLERS::contains));
        if (!validCaller) {
            throw new UnsupportedOperationException("VectorizationProvider is internal and can only be used by known Lucene classes.");
        }
    }

    static {
        OptionalInt vs = OptionalInt.empty();
        try {
            vs = Stream.ofNullable(System.getProperty("tests.vectorsize")).filter(Predicate.not(Set.of("", "default")::contains)).mapToInt(Integer::parseInt).findAny();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        TESTS_VECTOR_SIZE = vs;
        boolean enforce = false;
        try {
            enforce = Boolean.getBoolean("tests.forceintegervectors");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        TESTS_FORCE_INTEGER_VECTORS = enforce;
        LOG = Logger.getLogger(VectorizationProvider.class.getName());
        VERSION_JDK8301190_FIXED = Runtime.Version.parse("20.0.2");
        VALID_CALLERS = Set.of("org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil", "org.apache.lucene.util.VectorUtil");
    }

    private static final class Holder {
        static final VectorizationProvider INSTANCE = VectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

