/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.ConfigurationWizardElement;
import org.eclipse.team.internal.ui.wizards.ConfigureProjectWizardMainPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.model.AdaptableList;

public class ConfigureProjectWizard
extends Wizard {
    protected IProject[] projects;
    protected ConfigureProjectWizardMainPage mainPage;
    protected static final String PT_CONFIGURATION = "configurationWizards";
    protected static final String TAG_WIZARD = "wizard";
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";

    private ConfigureProjectWizard(IProject[] projects) {
        this.projects = projects;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TeamUIMessages.ConfigureProjectWizard_title);
    }

    public void addPages() {
        AdaptableList disabledWizards = new AdaptableList();
        AdaptableList wizards = ConfigureProjectWizard.getAvailableWizards(disabledWizards);
        this.mainPage = new ConfigureProjectWizardMainPage("configurePage1", TeamUIMessages.ConfigureProjectWizard_configureProject, TeamUIPlugin.getImageDescriptor("wizban/share_wizban.png"), wizards, disabledWizards);
        this.mainPage.setDescription(TeamUIMessages.ConfigureProjectWizard_description);
        this.mainPage.setProjects(this.projects);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage) {
            return this.mainPage.getSelectedWizard() != null && this.mainPage.getNextPage() == null;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizard noPageWizard;
        this.mainPage.performFinish();
        if (this.getContainer().getCurrentPage() == this.mainPage && (noPageWizard = this.mainPage.getSelectedWizard()) != null && noPageWizard.canFinish()) {
            return noPageWizard.performFinish();
        }
        return true;
    }

    public static void shareProjects(Shell shell, IProject[] projects) {
        ConfigurationWizardElement element;
        ConfigureProjectWizard wizard = null;
        AdaptableList disabledWizards = new AdaptableList();
        AdaptableList wizards = ConfigureProjectWizard.getAvailableWizards(disabledWizards);
        if (wizards.size() == 1 && disabledWizards.size() == 0 && (element = (ConfigurationWizardElement)((Object)wizards.getChildren()[0])).wizardHasPages(projects)) {
            try {
                wizard = element.createExecutableExtension(projects);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        if (wizard == null) {
            wizard = new ConfigureProjectWizard(projects);
            wizard.setForcePreviousAndNextButtons(true);
        }
        ConfigureProjectWizard.openWizard(shell, wizard);
    }

    private static AdaptableList getAvailableWizards(AdaptableList disabledWizards) {
        AdaptableList result = new AdaptableList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.team.ui", PT_CONFIGURATION);
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(TAG_WIZARD)) {
                        ConfigurationWizardElement wizard = ConfigureProjectWizard.createWizardElement(element);
                        if (wizard != null && ConfigureProjectWizard.filterItem(element)) {
                            disabledWizards.add((IAdaptable)wizard);
                        } else if (wizard != null) {
                            result.add((IAdaptable)wizard);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    private static boolean filterItem(IConfigurationElement element) {
        String extensionId = element.getAttribute(ATT_ID);
        String extensionPluginId = element.getNamespaceIdentifier();
        IActivityManager activityMgr = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IIdentifier id = activityMgr.getIdentifier(extensionPluginId + "/" + extensionId);
        return !id.isEnabled();
    }

    private static ConfigurationWizardElement createWizardElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            return null;
        }
        ConfigurationWizardElement result = new ConfigurationWizardElement(nameString);
        if (ConfigureProjectWizard.initializeWizard(result, element)) {
            return result;
        }
        return null;
    }

    private static boolean initializeWizard(ConfigurationWizardElement element, IConfigurationElement config) {
        element.setID(config.getAttribute(ATT_ID));
        String description = "";
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            description = children[0].getValue();
        }
        element.setDescription(description);
        element.setConfigurationElement(config);
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            IExtension extension = config.getDeclaringExtension();
            element.setImageDescriptor(TeamUIPlugin.getImageDescriptorFromExtension(extension, iconName));
        }
        return element.getConfigurationElement() != null;
    }

    public static void openWizard(Shell shell, IWizard wizard) {
        ResizeWizardDialog dialog = new ResizeWizardDialog(shell, wizard);
        dialog.open();
    }

    private static class ResizeWizardDialog
    extends WizardDialog {
        public ResizeWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }
}

