/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorHelper {
    private static final int TWO_MINUTES = (int)Duration.ofMinutes(2L).toMillis();
    public boolean isGrammarEncountered = false;
    public boolean isDTDEncountered = false;
    public boolean isNamespaceEncountered = false;
    public String schemaLocationString = "";
    public int numDTDElements = 0;
    public boolean isDocumentElementEncountered = false;
    private static final Map<String, GrammarEncounteredResult> grammarCheckerCache = new HashMap<String, GrammarEncounteredResult>(3);
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/debug/validation"));

    protected XMLReader createXMLReader(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser reader = null;
        ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            reader = new SAXParser();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClzLoader);
        }
        reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setFeature("http://xml.org/sax/features/namespaces", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        String xmlCoreId = XMLCorePlugin.getDefault().getBundle().getSymbolicName();
        boolean resolveExternalEntities = InstanceScope.INSTANCE.getNode(xmlCoreId).getBoolean("resolveExternalEntities", false);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
        reader.setContentHandler(new MyContentHandler(uri));
        reader.setErrorHandler(new InternalErrorHandler());
        LexicalHandler lexicalHandler = new LexicalHandler(){

            @Override
            public void startDTD(String name, String publicId, String systemId) {
                ValidatorHelper.this.isGrammarEncountered = true;
                ValidatorHelper.this.isDTDEncountered = true;
            }

            @Override
            public void endDTD() throws SAXException {
            }

            @Override
            public void startEntity(String name) throws SAXException {
            }

            @Override
            public void endEntity(String name) throws SAXException {
            }

            @Override
            public void startCDATA() throws SAXException {
            }

            @Override
            public void endCDATA() throws SAXException {
            }

            @Override
            public void comment(char[] ch, int start, int length) throws SAXException {
            }
        };
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        return reader;
    }

    public void computeValidationInformation(String uri, Reader characterStream, URIResolver uriResolver) {
        block7: {
            try {
                XMLReader reader = this.createXMLReader(uri);
                InputSource inputSource = new InputSource(uri);
                inputSource.setCharacterStream(characterStream);
                ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    reader.parse(inputSource);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClzLoader);
                }
            }
            catch (SAXException e) {
                if (_trace) {
                    Logger.logException(e);
                }
            }
            catch (IOException e) {
                if (!_trace) break block7;
                Logger.logException(e);
            }
        }
    }

    protected static String replace(String string, String oldPattern, String newPattern) {
        int index = 0;
        while (index != -1) {
            if ((index = ((String)string).indexOf(oldPattern, index)) == -1) continue;
            string = ((String)string).substring(0, index) + newPattern + ((String)string).substring(index + oldPattern.length());
            index += oldPattern.length();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doCheckGrammar(String location) {
        try {
            URL url = new URL(location);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(TWO_MINUTES);
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                InputStream is = connection.getInputStream();
                if (is == null) return true;
                is.close();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkGrammar(String location) {
        GrammarEncounteredResult result = grammarCheckerCache.get(location);
        if (result == null || System.currentTimeMillis() - result.timestamp > (long)TWO_MINUTES) {
            result = new GrammarEncounteredResult(ValidatorHelper.doCheckGrammar(location));
            Map<String, GrammarEncounteredResult> map = grammarCheckerCache;
            synchronized (map) {
                grammarCheckerCache.put(location, result);
            }
        }
        return result.result;
    }

    private static class GrammarEncounteredResult {
        boolean result;
        private long timestamp;

        GrammarEncounteredResult(boolean value) {
            this.result = value;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private class InternalErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    class MyContentHandler
    extends DefaultHandler {
        boolean isRootElement = true;
        String baseURI;

        MyContentHandler(String uri) {
            this.baseURI = uri;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        public String getPrefix(String name) {
            String prefix = null;
            int index = name.indexOf(":");
            if (index != -1) {
                prefix = name.substring(0, index);
            }
            return prefix;
        }

        public String getUnprefixedName(String name) {
            int index = name.indexOf(":");
            if (index != -1) {
                name = name.substring(index + 1);
            }
            return name;
        }

        public String getPrefixedName(String prefix, String localName) {
            return prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
            if (this.isRootElement) {
                ValidatorHelper.this.isDocumentElementEncountered = true;
                this.isRootElement = false;
                int nAtts = atts.getLength();
                String schemaInstancePrefix = null;
                int i = 0;
                while (i < nAtts) {
                    String attributeName = atts.getQName(i);
                    if (attributeName.equals("xmlns") || attributeName.startsWith("xmlns:")) {
                        ValidatorHelper.this.isNamespaceEncountered = true;
                        String value = atts.getValue(i);
                        if (value.startsWith("http://www.w3.org/") && value.endsWith("/XMLSchema-instance")) {
                            schemaInstancePrefix = attributeName.equals("xmlns") ? "" : this.getUnprefixedName(attributeName);
                        }
                    }
                    ++i;
                }
                String prefix = this.getPrefix(rawName);
                String rootElementNamespaceDeclarationName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                String rootElementNamespace = rootElementNamespaceDeclarationName != null ? atts.getValue(rootElementNamespaceDeclarationName) : null;
                String location = null;
                if (schemaInstancePrefix != null && (location = atts.getValue(this.getPrefixedName(schemaInstancePrefix, "noNamespaceSchemaLocation"))) == null) {
                    String schemaLoc = atts.getValue(this.getPrefixedName(schemaInstancePrefix, "schemaLocation"));
                    location = this.getSchemaLocationForNamespace(schemaLoc, rootElementNamespace);
                }
                if (rootElementNamespace == null) {
                    rootElementNamespace = "";
                }
                location = URIResolverPlugin.createResolver().resolve(this.baseURI, rootElementNamespace, location);
                location = URIResolverPlugin.createResolver().resolvePhysicalLocation(this.baseURI, rootElementNamespace, location);
                if (location != null) {
                    location = URIHelper.addImpliedFileProtocol((String)location);
                }
                ValidatorHelper.this.schemaLocationString = location;
                if (location != null) {
                    ValidatorHelper.this.isGrammarEncountered = ValidatorHelper.checkGrammar(location);
                }
            }
        }

        public void elementDecl(String name, String model) {
            ++ValidatorHelper.this.numDTDElements;
        }

        protected String getSchemaLocationForNamespace(String xsiSchemaLocationValue, String namespace) {
            String result = null;
            if (xsiSchemaLocationValue != null && namespace != null) {
                StringTokenizer st = new StringTokenizer(xsiSchemaLocationValue);
                while (st.hasMoreTokens()) {
                    if (st.nextToken().equals(namespace)) {
                        if (!st.hasMoreTokens()) continue;
                        result = st.nextToken();
                        continue;
                    }
                    if (!st.hasMoreTokens()) continue;
                    st.nextToken();
                }
            }
            return result;
        }
    }
}

