/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumScope
implements ICPPEnumScope,
IIndexScope {
    private final IPDOMCPPEnumType fBinding;

    public PDOMCPPEnumScope(IPDOMCPPEnumType binding) {
        this.fBinding = binding;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eEnumeration;
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, null);
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        try {
            CharArrayObjectMap<IPDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(this.fBinding);
            return map.get(name.toCharArray());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    @Deprecated
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        try {
            CharArrayObjectMap<IPDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(this.fBinding);
            if (lookup.isPrefixLookup()) {
                ArrayList<IBinding> result = new ArrayList<IBinding>();
                char[] nc = lookup.getLookupKey();
                IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(nc);
                char[][] cArray = map.keys();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] key = cArray[n2];
                    if (matcher.match(key)) {
                        result.add(map.get(key));
                    }
                    ++n2;
                }
                return result.toArray(new IBinding[result.size()]);
            }
            IBinding b = map.get(lookup.getLookupKey());
            if (b != null) {
                return new IBinding[]{b};
            }
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return CPPSemantics.findBindingsInScope(this, name, tu);
    }

    @Override
    @Deprecated
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this.fBinding;
    }

    @Override
    public IIndexScope getParent() {
        return this.fBinding.getScope();
    }

    @Override
    public IIndexName getScopeName() {
        return this.fBinding.getScopeName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDOMCPPEnumScope) {
            return this.fBinding.equals(((PDOMCPPEnumScope)obj).fBinding);
        }
        return false;
    }

    public int hashCode() {
        return this.fBinding.hashCode();
    }

    private static CharArrayObjectMap<IPDOMCPPEnumerator> getBindingMap(IPDOMCPPEnumType enumeration) throws CoreException {
        CharArrayObjectMap<IPDOMCPPEnumerator> map;
        Long key = enumeration.getRecord() + 0L;
        PDOM pdom = enumeration.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayObjectMap<IPDOMCPPEnumerator> charArrayObjectMap = map = cached == null ? null : (CharArrayObjectMap<IPDOMCPPEnumerator>)cached.get();
        if (map == null) {
            ArrayList<IPDOMCPPEnumerator> enumerators = new ArrayList<IPDOMCPPEnumerator>();
            enumeration.loadEnumerators(enumerators);
            map = new CharArrayObjectMap<IPDOMCPPEnumerator>(enumerators.size());
            for (IPDOMCPPEnumerator enumerator : enumerators) {
                map.put(enumerator.getNameCharArray(), enumerator);
            }
            pdom.putCachedResult(key, new SoftReference(map));
        }
        return map;
    }

    public static void updateCache(IPDOMCPPEnumType enumType, IPDOMCPPEnumerator enumItem) {
        CharArrayObjectMap map;
        Long key = enumType.getRecord() + 0L;
        PDOM pdom = enumType.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayObjectMap charArrayObjectMap = map = cached == null ? null : (CharArrayObjectMap)cached.get();
        if (map != null) {
            map.put(enumItem.getNameCharArray(), enumItem);
        }
    }

    public static IEnumerator[] getEnumerators(IPDOMCPPEnumType enumType) {
        try {
            ArrayList<IPDOMCPPEnumerator> enumerators = new ArrayList<IPDOMCPPEnumerator>();
            enumType.loadEnumerators(enumerators);
            ArrayList<IEnumerator> result = new ArrayList<IEnumerator>();
            for (IEnumerator iEnumerator : enumerators) {
                if (!IndexFilter.ALL_DECLARED.acceptBinding(iEnumerator)) continue;
                result.add(iEnumerator);
            }
            return result.toArray(new IEnumerator[result.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    public static void acceptViaCache(IPDOMCPPEnumType enumType, IPDOMVisitor visitor) {
        try {
            CharArrayObjectMap<IPDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(enumType);
            for (IPDOMCPPEnumerator enumItem : map.values()) {
                visitor.visit(enumItem);
                visitor.leave(enumItem);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public ICPPEnumeration getEnumerationType() {
        return (ICPPEnumeration)((Object)this.getScopeBinding());
    }
}

