/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests.AbstractImportAndReadSmokeTest;
import org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests.Activator;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class StandardImportAndReadSmokeTest
extends AbstractImportAndReadSmokeTest {
    private static final String TRACE_FOLDER_PARENT_PATH = "../../ctf/org.eclipse.tracecompass.ctf.core.tests/traces/";
    private static final String ARCHIVE_FILE_NAME = "synctraces.tar.gz";
    private static final String EMPTY_ARCHIVE_FOLDER = "emptyArchiveFolder";
    private static final String EMPTY_FILE_NAME = "emptyFile";
    private static final String TRACE_ARCHIVE_PATH = "../../ctf/org.eclipse.tracecompass.ctf.core.tests/traces/synctraces.tar.gz";
    private static final String TRACE_FOLDER_PARENT_NAME = "traces";
    private static final String TRACE_PROJECT_NAME = "Tracing";
    private static final String ARCHIVE_ROOT_ELEMENT_NAME = "/";
    private static final String GENERATED_ARCHIVE_NAME = "testtraces.zip";
    private static final String URI_SEPARATOR = "/";
    private static final String URI_FILE_SCHEME = "file:";
    private static final String URI_JAR_FILE_SCHEME = "jar:file:";
    private static final boolean IS_WIN32 = System.getProperty("os.name").startsWith("Windows");
    private static final String URI_DEVICE_SEPARATOR = IS_WIN32 ? "/" : "";
    private static final int TEST_OPTION_CHECK_EXPERIMENT = 32768;
    private static final int ABOVE_THRESHOLD_ENTRIES = 5001;
    private static final int ABOVE_THRESHOLD_SIZE = 1000000001;

    @BeforeClass
    public static void beforeClass() {
        StandardImportAndReadSmokeTest.createProject(TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testImportFromDirectory() throws Exception {
        this.testImport(0, false, false);
    }

    @Test
    public void testImportFromDirectoryLinks() throws Exception {
        this.testImport(4, false, false);
    }

    @Test
    public void testImportWithExperiment() throws Exception {
        this.testImport(32, false, false);
    }

    @Test
    public void testImportWithExperimentValidation() throws Exception {
        this.testImport(32, false, false, false, true, ImportConfirmation.CONTINUE);
    }

    @Test
    public void testImportWithExperimentOverwriteTraces() throws Exception {
        this.testImport(32, false, false, true, false, ImportConfirmation.CONTINUE);
        this.testImport(32784, false, false);
    }

    @Test
    public void testImportFromDirectoryPreserveFolder() throws Exception {
        this.testImport(2, false, false);
    }

    @Test
    public void testImportFromDirectoryLinksPreserveFolder() throws Exception {
        int options = 6;
        this.testImport(options, false, false);
    }

    @Test
    public void testImportFromDirectoryOverwrite() throws Exception {
        this.testImport(0, false, false, true, false, ImportConfirmation.CONTINUE);
        this.testImport(16, false, false);
    }

    @Test
    public void testImportFromDirectoryOverwriteRenameAll() throws Exception {
        this.testImport(0, false, false, true, false, ImportConfirmation.CONTINUE);
        this.testImport(0, false, false, true, true, ImportConfirmation.RENAME_ALL);
    }

    @Test
    public void testImportFromDirectoryOverwriteOverwriteAll() throws Exception {
        this.testImport(0, false, false, true, false, ImportConfirmation.CONTINUE);
        this.testImport(0, false, false, true, true, ImportConfirmation.OVERWRITE_ALL);
    }

    @Test
    public void testImportFromArchive() throws Exception {
        this.testImport(2, true, true);
    }

    @Test
    public void testImportFromArchiveWithExperiment() throws Exception {
        this.testImport(34, false, true);
    }

    @Test
    public void testImportFromArchivePreserveFolder() throws Exception {
        this.testImport(2, false, true);
    }

    @Test
    public void testImportFromArchiveOverwrite() throws Exception {
        this.testImport(0, false, true, true, false, ImportConfirmation.CONTINUE);
        this.testImport(16, false, true);
    }

    @Test
    public void testExtractArchivesFromDirectory() throws Exception {
        this.testImportAndExtractArchives(16, false, false);
    }

    @Test
    public void testExtractArchivesFromDirectoryLinks() throws Exception {
        this.testImportAndExtractArchives(20, false, false);
    }

    @Test
    public void testExtractArchivesFromDirectoryLinksPreserveStruture() throws Exception {
        this.testImportAndExtractArchives(22, true, false);
    }

    @Test
    public void testExtractArchivesFromArchive() throws Exception {
        this.testImportAndExtractArchives(16, false, true);
    }

    @Test
    public void testExtractArchivesFromArchivePreserveFolder() throws Exception {
        this.testImportAndExtractArchives(18, false, true);
    }

    @Test
    public void testEmptyArchive() throws Exception {
        String testArchivePath = StandardImportAndReadSmokeTest.createEmptyArchive();
        StandardImportAndReadSmokeTest.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)fBot, (String)testArchivePath);
        StandardImportAndReadSmokeTest.selectFolder("/");
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)0, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        StandardImportAndReadSmokeTest.assertNoTraces();
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Files.delete(Paths.get(testArchivePath, new String[0]));
    }

    @Test
    public void testEmptyDirectory() throws Exception {
        IFolder emptyDirectory = StandardImportAndReadSmokeTest.createEmptyDirectory();
        String testDirectoryPath = emptyDirectory.getLocation().toOSString();
        StandardImportAndReadSmokeTest.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)testDirectoryPath);
        StandardImportAndReadSmokeTest.selectFolder(EMPTY_ARCHIVE_FOLDER);
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)0, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        StandardImportAndReadSmokeTest.assertNoTraces();
        Files.delete(Paths.get(testDirectoryPath, new String[0]));
        emptyDirectory.delete(true, null);
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
    }

    @Test
    public void testEmptyFile() throws Exception {
        IFolder folder = StandardImportAndReadSmokeTest.createEmptyDirectory();
        StandardImportAndReadSmokeTest.createEmptyFile(folder);
        String testDirectoryPath = folder.getLocation().toOSString();
        StandardImportAndReadSmokeTest.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)testDirectoryPath);
        SWTBotImportWizardUtils.selectFile((SWTBot)fBot, (String)EMPTY_FILE_NAME, (String[])new String[]{EMPTY_ARCHIVE_FOLDER});
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)8, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        StandardImportAndReadSmokeTest.assertNoTraces();
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        folder.delete(true, null);
    }

    @Test
    public void testDirectoryWithEmptyArchive() throws Exception {
        String testArchivePath = StandardImportAndReadSmokeTest.createEmptyArchive();
        StandardImportAndReadSmokeTest.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)StandardImportAndReadSmokeTest.getProjectResource().getLocation().toOSString());
        SWTBotImportWizardUtils.selectFile((SWTBot)fBot, (String)GENERATED_ARCHIVE_NAME, (String[])new String[]{TRACE_PROJECT_NAME});
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)0, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        StandardImportAndReadSmokeTest.assertNoTraces();
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Files.delete(Paths.get(testArchivePath, new String[0]));
    }

    @Test
    public void testNestedEmptyArchive() throws Exception {
        IProject project = StandardImportAndReadSmokeTest.getProjectResource();
        String testArchivePath = StandardImportAndReadSmokeTest.createEmptyArchive();
        project.refreshLocal(1, null);
        IFile[] files = project.getWorkspace().getRoot().findFilesForLocationURI(new File(testArchivePath).toURI());
        IFile archiveFile = files[0];
        String newEmptyArchiveName = "nested" + archiveFile.getName();
        IPath dest = archiveFile.getFullPath().removeLastSegments(1).append(newEmptyArchiveName);
        archiveFile.move(dest, true, null);
        IFile renamedArchiveFile = archiveFile.getWorkspace().getRoot().getFile(dest);
        StandardImportAndReadSmokeTest.createArchive((IResource)renamedArchiveFile);
        renamedArchiveFile.delete(true, null);
        StandardImportAndReadSmokeTest.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)fBot, (String)testArchivePath);
        StandardImportAndReadSmokeTest.selectFolder("/");
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)0, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        StandardImportAndReadSmokeTest.assertNoTraces();
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Files.delete(Paths.get(testArchivePath, new String[0]));
    }

    @Test
    public void testArchiveWithColons() {
        StandardImportAndReadSmokeTest.openImportWizard();
        IPath absolutePath = Activator.getAbsolutePath(new Path("testfiles/testcolon.zip"));
        SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)fBot, (String)absolutePath.toOSString());
        String subFolderName = IS_WIN32 ? "folder_colon" : "folder:colon";
        StandardImportAndReadSmokeTest.selectFolder("/", subFolderName);
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)0, (String)"Test trace : XML Trace Stub (ns)");
        this.importFinish();
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)StandardImportAndReadSmokeTest.getProjectResource(), (boolean)true);
        Assert.assertNotNull((Object)tmfProject);
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertTrue((traces.size() == 1 ? 1 : 0) != 0);
        String traceName = IS_WIN32 ? "trace_colon.xml" : "trace:colon.xml";
        Assert.assertEquals((Object)traceName, (Object)((TmfTraceElement)traces.get(0)).getName());
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
    }

    @Test
    public void testArchiveSizeTooBig() {
        boolean actual = ArchiveUtil.verifyZipFileIsSafe((long)1000000001L, (long)5000L);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testArchiveTooManyEntries() {
        boolean actual = ArchiveUtil.verifyZipFileIsSafe((long)1000000000L, (long)5001L);
        Assert.assertFalse((boolean)actual);
    }

    private static void assertNoTraces() {
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)StandardImportAndReadSmokeTest.getProjectResource(), (boolean)true);
        Assert.assertNotNull((Object)tmfProject);
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertTrue((boolean)traces.isEmpty());
    }

    private void testImport(int options, boolean testViews, boolean fromArchive) throws Exception {
        this.testImport(options, testViews, fromArchive, true, true, ImportConfirmation.CONTINUE);
    }

    private void testImport(int options, boolean testViews, boolean fromArchive, boolean defaultExperiment, boolean clearTraces, ImportConfirmation confirmationMode) throws Exception {
        String expectedSourceLocation = null;
        @NonNull String experimentName = fromArchive ? (String)NonNullUtils.checkNotNull((Object)new Path(ARCHIVE_FILE_NAME).lastSegment()) : (String)NonNullUtils.checkNotNull((Object)new Path(TRACE_FOLDER_PARENT_PATH).lastSegment());
        if (!defaultExperiment) {
            SWTBotUtils.createExperiment((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (String)experimentName);
        }
        StandardImportAndReadSmokeTest.openImportWizard();
        if (fromArchive) {
            expectedSourceLocation = URI_JAR_FILE_SCHEME + URI_DEVICE_SEPARATOR + String.valueOf(new Path(new File(TRACE_ARCHIVE_PATH).getCanonicalPath())) + "!/synctraces/scp_dest/";
            SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)fBot, (String)TRACE_ARCHIVE_PATH);
            StandardImportAndReadSmokeTest.selectFolder("/");
            SWTBotCheckBox checkBox = fBot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
            Assert.assertFalse((boolean)checkBox.isEnabled());
        } else {
            String sourcePath = TRACE_FOLDER_PARENT_PATH + File.separator + "synctraces" + File.separator + "scp_dest";
            expectedSourceLocation = URI_FILE_SCHEME + URI_DEVICE_SEPARATOR + String.valueOf(new Path(new File(sourcePath).getCanonicalPath())) + "/";
            SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)TRACE_FOLDER_PARENT_PATH);
            StandardImportAndReadSmokeTest.selectFolder(TRACE_FOLDER_PARENT_NAME, "synctraces");
        }
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)options, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        if (!defaultExperiment) {
            experimentName = StandardImportAndReadSmokeTest.verifyExperimentNameHandling(experimentName);
        }
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)fBot, (boolean)true);
        this.importFinish(confirmationMode);
        Path expectedElementPath = new Path("scp_dest");
        if ((options & 2) != 0) {
            expectedElementPath = new Path("synctraces").append((IPath)expectedElementPath);
        }
        if (confirmationMode == ImportConfirmation.RENAME_ALL) {
            Path expectedElementPathRenamed = new Path("scp_dest(2)");
            StandardImportAndReadSmokeTest.checkOptions(options, expectedSourceLocation, (IPath)expectedElementPath, experimentName, (IPath)expectedElementPathRenamed);
        } else {
            StandardImportAndReadSmokeTest.checkOptions(options, expectedSourceLocation, (IPath)expectedElementPath, experimentName, null);
        }
        TmfEventsEditor tmfEd = SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (IPath)expectedElementPath);
        if (testViews) {
            this.testViews(tmfEd);
        }
        fBot.closeAllEditors();
        if (clearTraces) {
            SWTBotUtils.clearExperimentFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
            SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        }
    }

    private void testImportAndExtractArchives(int options, boolean testViews, boolean fromArchive) throws Exception {
        IPath expectedElementPath;
        String expectedSourceLocation;
        String testArchivePath = null;
        if (fromArchive) {
            testArchivePath = StandardImportAndReadSmokeTest.createNestedArchive();
            StandardImportAndReadSmokeTest.openImportWizard();
            SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)fBot, (String)testArchivePath);
            SWTBotImportWizardUtils.selectFile((SWTBot)fBot, (String)ARCHIVE_FILE_NAME, (String[])new String[]{"/", TRACE_PROJECT_NAME, TRACE_FOLDER_PARENT_NAME});
            expectedSourceLocation = URI_JAR_FILE_SCHEME + URI_DEVICE_SEPARATOR + String.valueOf(new Path(new File(testArchivePath).getCanonicalPath())) + "!/Tracing/traces/synctraces.tar.gz/synctraces/scp_dest/";
            expectedElementPath = new Path(TRACE_PROJECT_NAME).append(TRACE_FOLDER_PARENT_NAME).append(ARCHIVE_FILE_NAME).append("synctraces").append("scp_dest");
        } else {
            StandardImportAndReadSmokeTest.openImportWizard();
            SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)TRACE_FOLDER_PARENT_PATH);
            SWTBotImportWizardUtils.selectFile((SWTBot)fBot, (String)ARCHIVE_FILE_NAME, (String[])new String[]{TRACE_FOLDER_PARENT_NAME});
            expectedElementPath = new Path(ARCHIVE_FILE_NAME).append("synctraces").append("scp_dest");
            expectedSourceLocation = URI_FILE_SCHEME + URI_DEVICE_SEPARATOR + String.valueOf(new Path(new File(TRACE_FOLDER_PARENT_PATH).getCanonicalPath())) + "/synctraces.tar.gz/synctraces/scp_dest/";
        }
        if ((options & 2) == 0) {
            expectedElementPath = new Path("scp_dest");
        }
        SWTBotImportWizardUtils.setOptions((SWTBot)fBot, (int)options, (String)ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        int expectedOptions = options & 0xFFFFFFFB;
        StandardImportAndReadSmokeTest.checkOptions(expectedOptions, expectedSourceLocation, expectedElementPath);
        TmfEventsEditor editor = SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (IPath)expectedElementPath);
        if (testViews) {
            this.testViews(editor);
        }
        SWTBotUtils.clearExperimentFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        if (testArchivePath != null) {
            Files.delete(Paths.get(testArchivePath, new String[0]));
        }
    }

    private static String createNestedArchive() throws IOException, CoreException, URISyntaxException {
        IProject project = StandardImportAndReadSmokeTest.getProjectResource();
        String canonicalPath = new File(TRACE_FOLDER_PARENT_PATH).getCanonicalPath();
        IFolder folder = project.getFolder(TRACE_FOLDER_PARENT_NAME);
        folder.createLink((IPath)new Path(canonicalPath), 256, null);
        IFile file = folder.getFile(ARCHIVE_FILE_NAME);
        String archivePath = StandardImportAndReadSmokeTest.createArchive((IResource)file);
        folder.delete(true, null);
        return archivePath;
    }

    private static String createEmptyArchive() throws CoreException, URISyntaxException {
        IFolder tempEmptyDirectory = StandardImportAndReadSmokeTest.createEmptyDirectory();
        String archivePath = StandardImportAndReadSmokeTest.createArchive((IResource)tempEmptyDirectory);
        tempEmptyDirectory.delete(true, null);
        return archivePath;
    }

    private static IFolder createEmptyDirectory() throws CoreException {
        IProject project = StandardImportAndReadSmokeTest.getProjectResource();
        IFolder folder = project.getFolder(EMPTY_ARCHIVE_FOLDER);
        folder.create(true, true, null);
        return folder;
    }

    private static void createEmptyFile(IFolder folder) throws CoreException {
        IFile file = folder.getFile(EMPTY_FILE_NAME);
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
    }

    private static String createArchive(IResource sourceResource) throws URISyntaxException {
        IPath exportedPath = sourceResource.getFullPath();
        SWTBotTreeItem traceFilesProject = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        traceFilesProject.contextMenu("Export...").click();
        SWTBotShell activeShell = fBot.shell("Export").activate();
        SWTBotTree exportWizardsTree = fBot.tree();
        SWTBotTreeItem treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)exportWizardsTree, (String[])new String[]{"General", "Archive File"});
        treeItem.select();
        fBot.button("Next >").click();
        fBot.button("&Deselect All").click();
        try {
            String resolveLinkedResLabel = "Resolve and export linked resources";
            fBot.waitUntil((ICondition)Conditions.waitForWidget((Matcher)WidgetMatcherFactory.withMnemonic((String)resolveLinkedResLabel)), 100L);
            fBot.checkBox(resolveLinkedResLabel).select();
        }
        catch (TimeoutException resolveLinkedResLabel) {
            // empty catch block
        }
        if (sourceResource instanceof IFile) {
            String[] folderPath = exportedPath.removeLastSegments(1).segments();
            String fileName = exportedPath.lastSegment();
            SWTBotImportWizardUtils.selectFile((SWTBot)fBot, (String)fileName, (String[])folderPath);
        } else {
            StandardImportAndReadSmokeTest.selectFolder(exportedPath.segments());
        }
        String workspacePath = URIUtil.toFile((URI)URIUtil.fromString((String)System.getProperty("osgi.instance.area"))).getAbsolutePath();
        String archiveDestinationPath = workspacePath + File.separator + TRACE_PROJECT_NAME + File.separator + GENERATED_ARCHIVE_NAME;
        fBot.comboBox().setText(archiveDestinationPath);
        fBot.button("&Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)activeShell), 180000L);
        return archiveDestinationPath;
    }

    private void testViews(TmfEventsEditor editor) {
        this.testHistogramView(this.getViewPart("Histogram"), editor);
        this.testPropertyView(this.getViewPart("Properties"));
        this.testStatisticsView(this.getViewPart("Statistics"));
    }

    private static void openImportWizard() {
        fWizard = new ImportTraceWizard();
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    Shell shell = activeWorkbenchWindow.getShell();
                    Assert.assertNotNull((Object)shell);
                    ((ImportTraceWizard)fWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)fWizard);
                    dialog.open();
                }
            }
        });
        fBot.waitUntil(ConditionHelpers.isWizardReady((Wizard)fWizard));
    }

    private static void selectFolder(String ... treePath) {
        SWTBotImportWizardUtils.selectFolder((SWTBot)fBot, (boolean)true, (String[])treePath);
    }

    private static void checkOptions(int optionFlags, String expectedSourceLocation, IPath expectedElementPath) throws CoreException {
        StandardImportAndReadSmokeTest.checkOptions(optionFlags, expectedSourceLocation, expectedElementPath, null, null);
    }

    private static void checkOptions(int optionFlags, String expectedSourceLocation, IPath expectedElementPath, String experimentName, IPath expectedElementPathRenamed) throws CoreException {
        IProject project = StandardImportAndReadSmokeTest.getProjectResource();
        Assert.assertTrue((boolean)project.exists());
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        Assert.assertNotNull((Object)tmfProject);
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertFalse((boolean)traces.isEmpty());
        Collections.sort(traces, new Comparator<TmfTraceElement>(){

            @Override
            public int compare(TmfTraceElement arg0, TmfTraceElement arg1) {
                return arg0.getElementPath().compareTo(arg1.getElementPath());
            }
        });
        TmfTraceElement tmfTraceElement = (TmfTraceElement)traces.get(0);
        IResource traceResource = tmfTraceElement.getResource();
        Assert.assertEquals((Object)((optionFlags & 4) != 0 ? 1 : 0), (Object)traceResource.isLinked());
        String tracesFolderName = tracesFolder.getResource().getName();
        IPath expectedPath = Path.ROOT.append((IPath)new Path(TRACE_PROJECT_NAME)).append(tracesFolderName).append(expectedElementPath);
        Assert.assertEquals((Object)expectedPath, (Object)traceResource.getFullPath());
        if (expectedElementPathRenamed != null) {
            IPath expectedPathRenamed = Path.ROOT.append((IPath)new Path(TRACE_PROJECT_NAME)).append(tracesFolderName).append(expectedElementPathRenamed);
            IResource traceResourceRenamed = ((TmfTraceElement)traces.get(1)).getResource();
            Assert.assertEquals((Object)expectedPathRenamed, (Object)traceResourceRenamed.getFullPath());
        }
        String sourceLocation = traceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
        Assert.assertNotNull((Object)sourceLocation);
        Assert.assertEquals((Object)expectedSourceLocation, (Object)sourceLocation);
        TmfExperimentFolder expFolder = tmfProject.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        if ((optionFlags & 0x8020) != 0) {
            if (experimentName != null) {
                TmfExperimentElement expElement = expFolder.getExperiment(experimentName);
                Assert.assertNotNull((Object)expElement);
                Assert.assertEquals((long)2L, (long)expElement.getTraces().size());
            }
        } else {
            Assert.assertTrue((expFolder.getExperiments().size() == 0 ? 1 : 0) != 0);
        }
    }

    private static IProject getProjectResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(TRACE_PROJECT_NAME);
    }

    private static @NonNull String verifyExperimentNameHandling(String aExperimentName) {
        Object experimentName = aExperimentName;
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)fBot, (boolean)false);
        SWTBotText expText = fBot.textInGroup("Options");
        expText.setText(String.valueOf(' '));
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)fBot, (boolean)false);
        expText.setText(String.valueOf('/'));
        SWTBotImportWizardUtils.checkFinishButton((SWTBot)fBot, (boolean)false);
        experimentName = (String)experimentName + "_";
        expText.setText((String)experimentName);
        return experimentName;
    }
}

