/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.application.FileLocationDetails;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;
import org.eclipse.urischeme.IUriSchemeProcessor;

public class DelayedEventsProcessor
implements Listener {
    private ArrayList<String> filesToOpen = new ArrayList(1);
    private ArrayList<Event> urlsToOpen = new ArrayList(1);

    public DelayedEventsProcessor(Display display) {
        display.addListener(46, (Listener)this);
        display.addListener(54, (Listener)this);
    }

    public void handleEvent(Event event) {
        String path = event.text;
        if (path == null) {
            return;
        }
        if (event.type == 54) {
            this.urlsToOpen.add(event);
        } else {
            this.filesToOpen.add(path);
        }
    }

    public void catchUp(Display display) {
        if (this.filesToOpen.isEmpty() && this.urlsToOpen.isEmpty()) {
            return;
        }
        String[] filePaths = new String[this.filesToOpen.size()];
        this.filesToOpen.toArray(filePaths);
        this.filesToOpen.clear();
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            DelayedEventsProcessor.openFile(display, filePath);
            ++n2;
        }
        Event[] events = new Event[this.urlsToOpen.size()];
        this.urlsToOpen.toArray(events);
        this.urlsToOpen.clear();
        Event[] eventArray = events;
        int n3 = events.length;
        n = 0;
        while (n < n3) {
            Event event = eventArray[n];
            DelayedEventsProcessor.openUrl(display, event);
            ++n;
        }
    }

    private static void openUrl(Display display, Event event) {
        display.asyncExec(() -> {
            String uriScheme = DelayedEventsProcessor.getUriSchemeFromEvent(event.text);
            try {
                IUriSchemeProcessor.INSTANCE.handleUri(uriScheme, event.text);
            }
            catch (CoreException e) {
                String message = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedUrlAction_cannotHandle, (Object)uriScheme);
                IDEWorkbenchPlugin.log((String)message, (IStatus)new Status(4, "org.eclipse.ui.ide.application", message, (Throwable)e));
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedUrlAction_title, (String)message, (int)0x10000000);
            }
        });
    }

    private static String getUriSchemeFromEvent(String uriString) {
        try {
            URI uri = new URI(uriString);
            return uri.getScheme();
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedUrlAction_invalidURL, (Object)uriString);
            IDEWorkbenchPlugin.log((String)message, (IStatus)new Status(4, "org.eclipse.ui.ide.application", message, (Throwable)e));
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedUrlAction_title, (String)message, (int)0x10000000);
            return null;
        }
    }

    public static void openFile(Display display, final String initialPath) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                FileLocationDetails details = FileLocationDetails.resolve(initialPath);
                if (details == null || !details.fileInfo.exists()) {
                    String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_fileNotFound, (Object)initialPath);
                    MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                } else if (details.fileInfo.isDirectory()) {
                    SmartImportWizard wizard = new SmartImportWizard();
                    wizard.setInitialImportSource(new File(details.fileStore.toURI()));
                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                } else {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_noWindow, (Object)details.path);
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                    try {
                        IEditorPart openEditor = IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)details.fileStore);
                        Shell shell = window.getShell();
                        if (shell != null) {
                            if (shell.getMinimized()) {
                                shell.setMinimized(false);
                            }
                            shell.forceActive();
                        }
                        if (details.line >= 1) {
                            try {
                                int lineLength;
                                Object documentProvider = this.invoke(openEditor, "getDocumentProvider");
                                Object editorInput = this.invoke(openEditor, "getEditorInput");
                                Object document = this.invoke(documentProvider, "getDocument", new Class[]{Object.class}, new Object[]{editorInput});
                                int numberOfLines = (Integer)this.invoke(document, "getNumberOfLines");
                                if (details.line > numberOfLines) {
                                    details.line = numberOfLines;
                                }
                                if (details.column > (lineLength = ((Integer)this.invoke(document, "getLineLength", new Class[]{Integer.TYPE}, new Object[]{details.line - 1})).intValue())) {
                                    details.column = lineLength;
                                }
                                if (details.column < 1) {
                                    details.column = 1;
                                }
                                int offset = (Integer)this.invoke(document, "getLineOffset", new Class[]{Integer.TYPE}, new Object[]{details.line - 1});
                                this.invoke(openEditor, "selectAndReveal", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{offset += details.column - 1, 0});
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (PartInitException e) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_errorOnOpen, (Object)details.fileStore.getName());
                        PartInitException eLog = new PartInitException(e.getMessage());
                        IDEWorkbenchPlugin.log((String)msg, (IStatus)new Status(4, "org.eclipse.ui.ide.application", msg, (Throwable)eLog));
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                }
            }

            private Object invoke(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                return method.invoke(object, new Object[0]);
            }

            private Object invoke(Object object, String methodName, Class<?>[] classes, Object[] params) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Method method = object.getClass().getMethod(methodName, classes);
                return method.invoke(object, params);
            }
        });
    }
}

