/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCFunction
extends PDOMBinding
implements IFunction {
    public static final int NUM_PARAMS = 32;
    public static final int FIRST_PARAM = 36;
    private static final int FUNCTION_TYPE = 40;
    private static final int ANNOTATIONS = 46;
    public static final int RECORD_SIZE = 47;

    public PDOMCFunction(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCFunction(PDOMLinkage linkage, PDOMNode parent, IFunction function) throws CoreException {
        super(linkage, parent, function.getNameCharArray());
        IFunctionType type = function.getType();
        this.setType((PDOMLinkage)this.getLinkage(), type);
        IParameter[] parameters = function.getParameters();
        this.setParameters(parameters);
        byte annotations = PDOMCAnnotations.encodeFunctionAnnotations(function);
        this.getDB().putByte(this.record + 46L, annotations);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (!(newBinding instanceof IFunction)) {
            return;
        }
        IFunction func = (IFunction)newBinding;
        IFunctionType newType = func.getType();
        this.setType(linkage, newType);
        PDOMCParameter oldParams = this.getFirstParameter(null);
        IParameter[] newParams = func.getParameters();
        this.setParameters(newParams);
        if (oldParams != null) {
            oldParams.delete(linkage);
        }
        byte newAnnotation = PDOMCAnnotations.encodeFunctionAnnotations(func);
        this.getDB().putByte(this.record + 46L, newAnnotation);
    }

    private void setType(PDOMLinkage linkage, IFunctionType ft) throws CoreException {
        linkage.storeType(this.record + 40L, ft);
    }

    private void setParameters(IParameter[] params) throws CoreException {
        ILinkage linkage = this.getLinkage();
        Database db = this.getDB();
        db.putInt(this.record + 32L, params.length);
        db.putRecPtr(this.record + 36L, 0L);
        PDOMNode next = null;
        int i = params.length;
        while (--i >= 0) {
            next = new PDOMCParameter((PDOMLinkage)linkage, this, params[i], (PDOMCParameter)next);
        }
        db.putRecPtr(this.record + 36L, next == null ? 0L : next.getRecord());
    }

    public PDOMCParameter getFirstParameter(IType t) throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 36L);
        return rec != 0L ? new PDOMCParameter((PDOMLinkage)this.getLinkage(), rec, t) : null;
    }

    @Override
    protected int getRecordSize() {
        return 47;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    @Override
    public IFunctionType getType() {
        try {
            return (IFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 40L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ProblemFunctionType(10005);
        }
    }

    @Override
    public boolean isStatic() {
        return PDOMCAnnotations.isStatic(this.getAnnotations());
    }

    @Override
    public boolean isExtern() {
        return PDOMCAnnotations.isExtern(this.getAnnotations());
    }

    @Override
    public IParameter[] getParameters() {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            IFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 32L);
            IParameter[] result = new IParameter[n];
            long next = db.getRecPtr(this.record + 36L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCParameter par = new PDOMCParameter((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IParameter.EMPTY_PARAMETER_ARRAY;
        }
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isInline() {
        return PDOMCAnnotations.isInline(this.getAnnotations());
    }

    private byte getAnnotations() {
        return this.getByte(this.record + 46L);
    }

    @Override
    public boolean takesVarArgs() {
        return PDOMCAnnotations.isVarargsFunction(this.getAnnotations());
    }

    @Override
    public boolean isNoReturn() {
        return PDOMCAnnotations.isNoReturnFunction(this.getAnnotations());
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }
}

