/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.statistics;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.statistics.OfflineStatisticsCalculator;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractStatisticsTest<@NonNull E> {
    private static final int MEDIUM_AMOUNT_OF_SEGMENTS = 100;
    private static final int LARGE_AMOUNT_OF_SEGMENTS = 1000000;
    private static final double ERROR = 1.0E-6;
    private static final double APPROX_ERROR = 1.0E-4;
    private final @Nullable Function<@NonNull E, @NonNull Long> fMapper;

    public AbstractStatisticsTest(Function<E, @NonNull Long> mapper) {
        this.fMapper = mapper;
    }

    private @NonNull Function<@NonNull E, @NonNull Long> getMapper() {
        Function<@NonNull E, @NonNull Long> mapper = this.fMapper;
        if (mapper == null) {
            return e -> (Long)e;
        }
        return mapper;
    }

    private void testOnlineVsOffline(Collection<E> fixture) {
        AbstractStatisticsTest.validate(new OfflineStatisticsCalculator<E>(fixture, this.getMapper()), this.buildStats(fixture));
    }

    private Statistics<E> buildStats(Collection<E> fixture) {
        Statistics<E> sss = this.createStatistics();
        for (E seg : fixture) {
            sss.update(seg);
        }
        return sss;
    }

    private static <E> void validate(IStatistics<E> expected, IStatistics<E> toBeTested) {
        Assert.assertEquals((String)"# of elements", (long)expected.getNbElements(), (long)toBeTested.getNbElements());
        Assert.assertEquals((String)"Sum of values", (double)expected.getTotal(), (double)toBeTested.getTotal(), (double)(1.0E-6 * expected.getTotal()));
        Assert.assertEquals((String)"Mean", (double)expected.getMean(), (double)toBeTested.getMean(), (double)(1.0E-6 * expected.getMean()));
        Assert.assertEquals((String)"Min", (long)expected.getMin(), (long)toBeTested.getMin());
        Assert.assertEquals((String)"Max", (long)expected.getMax(), (long)toBeTested.getMax());
        Assert.assertEquals((String)"Min Element", (Object)expected.getMinObject(), (Object)toBeTested.getMinObject());
        Assert.assertEquals((String)"Max Element", (Object)expected.getMaxObject(), (Object)toBeTested.getMaxObject());
        Assert.assertEquals((String)"Standard Deviation", (double)expected.getStdDev(), (double)toBeTested.getStdDev(), (double)(1.0E-4 * expected.getStdDev()));
    }

    private @NonNull Statistics<E> createStatistics() {
        Function<@NonNull E, @NonNull Long> mapper = this.fMapper;
        if (mapper == null) {
            return new Statistics();
        }
        return new Statistics(mapper);
    }

    protected abstract Collection<E> createElementsWithValues(Collection<@NonNull Long> var1);

    @Test
    public void testEmpty() {
        Statistics<E> stats = this.createStatistics();
        Assert.assertEquals((String)"Mean", (double)0.0, (double)stats.getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Min", (long)Long.MAX_VALUE, (long)stats.getMin());
        Assert.assertEquals((String)"Max", (long)Long.MIN_VALUE, (long)stats.getMax());
        Assert.assertEquals((String)"Standard Deviation", (double)Double.NaN, (double)stats.getStdDev(), (double)1.0E-6);
        Assert.assertNull((Object)stats.getMinObject());
        Assert.assertNull((Object)stats.getMaxObject());
        Assert.assertEquals((String)"Nb objects", (long)0L, (long)stats.getNbElements());
        Assert.assertEquals((String)"Total", (double)0.0, (double)stats.getTotal(), (double)1.0E-6);
    }

    @Test
    public void testAscending() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(100);
        long i = 0L;
        while (i <= 100L) {
            longFixture.add(i);
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        Statistics<E> sss = this.buildStats(fixture);
        Assert.assertEquals((String)"Mean", (double)50.0, (double)sss.getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Min", (long)0L, (long)sss.getMin());
        Assert.assertEquals((String)"Max", (long)100L, (long)sss.getMax());
        Assert.assertEquals((String)"Standard Deviation", (double)29.3, (double)sss.getStdDev(), (double)0.02);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testDescending() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(100);
        long i = 100L;
        while (i >= 0L) {
            longFixture.add(i);
            --i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        Statistics<E> sss = this.buildStats(fixture);
        Assert.assertEquals((String)"Mean", (double)50.0, (double)sss.getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Min", (long)0L, (long)sss.getMin());
        Assert.assertEquals((String)"Max", (long)100L, (long)sss.getMax());
        Assert.assertEquals((String)"Standard Deviation", (double)29.3, (double)sss.getStdDev(), (double)0.02);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testSmallDataset() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1);
        longFixture.add(1L);
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testLimitDataset() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1);
        longFixture.add(Long.MAX_VALUE);
        longFixture.add(Long.MAX_VALUE);
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        Statistics<E> sss = this.buildStats(fixture);
        Assert.assertEquals((String)"Mean", (double)9.223372036854776E18, (double)sss.getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Total", (double)1.8446744073709552E19, (double)sss.getTotal(), (double)1.0E-6);
        Assert.assertEquals((String)"Standard deviation", (double)Double.NaN, (double)sss.getStdDev(), (double)1.0E-6);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testLimitDataset2() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1);
        longFixture.add(Long.MIN_VALUE);
        longFixture.add(Long.MIN_VALUE);
        longFixture.add(Long.MIN_VALUE);
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        Statistics<E> sss = this.buildStats(fixture);
        Assert.assertEquals((String)"Mean", (double)-9.223372036854776E18, (double)sss.getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Total", (double)-2.7670116110564327E19, (double)sss.getTotal(), (double)1.0E-6);
        Assert.assertEquals((String)"Standard deviation", (double)0.0, (double)sss.getStdDev(), (double)1.0E-6);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testLargeDataset() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        Random rng = new Random(10L);
        int i = 1;
        while (i <= 1000000) {
            longFixture.add(Math.abs(rng.nextLong()));
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testLargeDatasetNegative() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        Random rng = new Random(10L);
        int i = 1;
        while (i <= 1000000) {
            longFixture.add(rng.nextLong());
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void testNoiseDataset() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        Random rng = new Random(1234L);
        int i = 1;
        while (i <= 1000000) {
            longFixture.add(Long.valueOf(Math.abs(rng.nextInt(1000000))));
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void gaussianNoiseTest() {
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        Random rng = new Random(1234L);
        int i = 1;
        while (i <= 1000000) {
            longFixture.add(Long.valueOf(Math.abs(rng.nextInt(1000))));
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        this.testOnlineVsOffline(fixture);
    }

    @Test
    public void streamBuildingTest() {
        Statistics expected = this.createStatistics();
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        long i = 0L;
        while (i < 1000000L) {
            longFixture.add(i);
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        fixture.forEach(e -> expected.update(e));
        Statistics actual = fixture.stream().collect(() -> this.createStatistics(), Statistics::update, Statistics::merge);
        AbstractStatisticsTest.validate(expected, actual);
    }

    @Test
    public void parallelStreamBuildingTest() {
        Statistics expected = this.createStatistics();
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(1000000);
        long i = 0L;
        while (i < 1000000L) {
            longFixture.add(i);
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        fixture.forEach(e -> expected.update(e));
        Statistics actual = fixture.parallelStream().collect(() -> this.createStatistics(), Statistics::update, Statistics::merge);
        AbstractStatisticsTest.validate(expected, actual);
    }

    @Test
    public void testMergeStatisticsNodes() {
        int nbElements = 10;
        ArrayList<@NonNull Long> longFixture = new ArrayList<Long>(nbElements);
        long i = 0L;
        while (i < (long)nbElements) {
            longFixture.add(i);
            ++i;
        }
        Collection<@NonNull E> fixture = this.createElementsWithValues(longFixture);
        Statistics<@NonNull E> expected = this.createStatistics();
        Statistics<@NonNull E> statsA = this.createStatistics();
        Statistics<@NonNull E> statsB = this.createStatistics();
        ArrayList<@NonNull E> allElements = new ArrayList(2 * nbElements);
        fixture.stream().forEach(obj -> {
            expected.update(obj);
            expected.update(obj);
            statsA.update(obj);
            statsB.update(obj);
            allElements.add(obj);
            allElements.add(obj);
        });
        statsA.merge(statsB);
        Assert.assertEquals((String)"Merged size", (long)(2 * nbElements), (long)statsA.getNbElements());
        AbstractStatisticsTest.validate(expected, statsA);
        OfflineStatisticsCalculator<@NonNull E> offline = new OfflineStatisticsCalculator(allElements, this.getMapper());
        AbstractStatisticsTest.validate(offline, statsA);
    }

    @Test
    public void testMergeStatisticsRandomNodes() {
        Random rnd = new Random();
        rnd.setSeed(1234L);
        int size = 2 + rnd.nextInt(1000);
        int size2 = 2 + rnd.nextInt(1000);
        ArrayList<@NonNull Long> longFixture1 = new ArrayList<Long>(size);
        long i = 0L;
        while (i < (long)size) {
            longFixture1.add(Long.valueOf(Math.abs(rnd.nextInt(1000))));
            ++i;
        }
        Collection<@NonNull E> fixture1 = this.createElementsWithValues(longFixture1);
        ArrayList<@NonNull Long> longFixture2 = new ArrayList<Long>(size2);
        long i2 = 0L;
        while (i2 < (long)size2) {
            longFixture2.add(Long.valueOf(Math.abs(rnd.nextInt(1000))));
            ++i2;
        }
        Collection<@NonNull E> fixture2 = this.createElementsWithValues(longFixture2);
        Statistics<@NonNull E> expected = this.createStatistics();
        Statistics<@NonNull E> statsA = this.createStatistics();
        Statistics<@NonNull E> statsB = this.createStatistics();
        ArrayList<@NonNull E> allElements = new ArrayList(size + size2);
        fixture1.stream().forEach(obj -> {
            expected.update(obj);
            statsA.update(obj);
            allElements.add(obj);
        });
        fixture2.stream().forEach(obj -> {
            expected.update(obj);
            statsB.update(obj);
            allElements.add(obj);
        });
        Assert.assertEquals((String)"size of statsA", (long)size, (long)statsA.getNbElements());
        Assert.assertEquals((String)"size of statsB", (long)size2, (long)statsB.getNbElements());
        statsA.merge(statsB);
        Assert.assertEquals((String)"Merged size", (long)(size + size2), (long)statsA.getNbElements());
        AbstractStatisticsTest.validate(expected, statsA);
        OfflineStatisticsCalculator<@NonNull E> offline = new OfflineStatisticsCalculator(allElements, this.getMapper());
        AbstractStatisticsTest.validate(offline, statsA);
    }

    @Test
    public void mergeStatisticsCornerCaseNodesTest() {
        Collection<@NonNull E> oneFixture = this.createElementsWithValues((Collection<Long>)ImmutableList.of((Object)10L));
        Collection<@NonNull E> smallFixture = this.createElementsWithValues((Collection<Long>)ImmutableList.of((Object)0L, (Object)10L, (Object)5L, (Object)12L, (Object)7L, (Object)1234L));
        Statistics<E> noElements = this.createStatistics();
        Statistics<E> oneElement = this.createStatistics();
        oneElement.update(oneFixture.iterator().next());
        Statistics allElements = this.createStatistics();
        oneFixture.stream().forEach(obj -> allElements.update(obj));
        smallFixture.stream().forEach(obj -> allElements.update(obj));
        Statistics<E> testStats = this.createStatistics();
        Statistics<E> testStats2 = this.createStatistics();
        testStats.update(oneFixture.iterator().next());
        testStats.merge(testStats2);
        AbstractStatisticsTest.validate(oneElement, testStats);
        AbstractStatisticsTest.validate(noElements, testStats2);
        testStats2.merge(testStats);
        AbstractStatisticsTest.validate(oneElement, testStats);
        AbstractStatisticsTest.validate(oneElement, testStats2);
        Statistics testStats3 = this.createStatistics();
        smallFixture.stream().forEach(obj -> testStats3.update(obj));
        testStats3.merge(testStats2);
        AbstractStatisticsTest.validate(oneElement, testStats2);
        AbstractStatisticsTest.validate(allElements, testStats3);
        Statistics testStats4 = this.createStatistics();
        smallFixture.stream().forEach(obj -> testStats4.update(obj));
        testStats2.merge(testStats4);
        AbstractStatisticsTest.validate(allElements, testStats2);
    }
}

