/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.StubPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public abstract class PalettedPresentationProvider
extends StubPresentationProvider {
    @Override
    public String getPreferenceKey() {
        return "Paletted";
    }

    public PalettedPresentationProvider() {
        StateItem[] states = this.getStateTable();
        int i = 0;
        while (i < states.length) {
            states[i].getStyleMap().put("background-color", this.getColor(new TimeEvent(null, 0L, 0L, i)));
            ++i;
        }
    }

    public abstract IPaletteProvider getPalette();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private String getColor(TimeEvent event) {
        @NonNull List list = this.getPalette().get();
        int floor = Long.valueOf(Math.floorMod((long)event.getValue() & 0xFFFFFFFFL, (long)list.size())).intValue();
        int colorInt = ((RGBAColor)list.get(floor)).toInt();
        return ColorUtils.toHexColor((int)(colorInt >> 24), (int)(colorInt >> 16), (int)(colorInt >> 8));
    }

    public Map<String, Object> getEventStyle(@Nullable ITimeEvent event) {
        HashMap<String, Object> style = new HashMap<String, Object>(super.getEventStyle(event));
        if (event instanceof TimeEvent) {
            style.put("background-color", this.getColor((TimeEvent)event));
        }
        return style;
    }
}

