/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetDetector;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkListener;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.internal.FacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.ProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetDetectorsExtensionPoint;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.util.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.util.internal.MiscUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.StatusWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetedProjectWorkingCopy
implements IFacetedProjectWorkingCopy {
    private static final SortedSet<IProjectFacetVersion> EMPTY_SORTED_FV_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private Object lock = new Object();
    private String projectName = null;
    private IStatus projectNameValidation = Status.OK_STATUS;
    private IPath projectLocation = null;
    private IFacetedProject project;
    private Set<IProjectFacet> fixedFacets;
    private IndexedSet<IProjectFacet, IProjectFacetVersion> facets;
    private Map<IProjectFacet, SortedSet<IProjectFacetVersion>> availableFacets;
    private IndexedSet<String, IPreset> availablePresets;
    private String selectedPresetId;
    private final Set<IRuntime> targetableRuntimes;
    private final Set<IRuntime> targetedRuntimes;
    private IRuntime primaryRuntime;
    private Set<IFacetedProject.Action> actions;
    private List<IStatus> problems;
    private final List<Runnable> disposeTasks;
    private final Map<IFacetedProjectEvent.Type, List<IFacetedProjectListener>> listeners;
    private int suspendEventNoticationCounter;
    private final List<IFacetedProjectEvent> queuedEvents;

    public FacetedProjectWorkingCopy(IFacetedProject project) {
        this.project = project;
        this.actions = Collections.emptySet();
        this.problems = Collections.emptyList();
        this.fixedFacets = Collections.emptySet();
        this.facets = new IndexedSet();
        this.availableFacets = Collections.emptyMap();
        this.availablePresets = new IndexedSet();
        this.selectedPresetId = null;
        this.targetableRuntimes = new CopyOnWriteArraySet<IRuntime>();
        this.targetedRuntimes = new CopyOnWriteArraySet<IRuntime>();
        this.primaryRuntime = null;
        this.disposeTasks = new ArrayList<Runnable>();
        this.listeners = new HashMap<IFacetedProjectEvent.Type, List<IFacetedProjectListener>>();
        IFacetedProjectEvent.Type[] typeArray = IFacetedProjectEvent.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacetedProjectEvent.Type eventType = typeArray[n2];
            this.listeners.put(eventType, new CopyOnWriteArrayList());
            ++n2;
        }
        this.suspendEventNoticationCounter = 0;
        this.queuedEvents = new ArrayList<IFacetedProjectEvent>();
        this.refreshAvailableFacets();
        if (this.project != null) {
            this.setFixedProjectFacets(this.project.getFixedProjectFacets());
        }
        this.refreshAvailablePresets();
        if (this.project != null) {
            this.setProjectFacets(this.project.getProjectFacets());
        }
        this.refreshTargetableRuntimes();
        if (this.project != null) {
            this.setTargetedRuntimes(this.project.getTargetedRuntimes());
            this.setPrimaryRuntime(this.project.getPrimaryRuntime());
        }
        final Job runtimesRefreshJob = new Job(Resources.refreshingAvailableRuntimesJobName){

            protected IStatus run(IProgressMonitor monitor) {
                FacetedProjectWorkingCopy.this.suspendEventNotification();
                try {
                    FacetedProjectEvent event = new FacetedProjectEvent(FacetedProjectWorkingCopy.this, IFacetedProjectEvent.Type.AVAILABLE_RUNTIMES_CHANGED);
                    FacetedProjectWorkingCopy.this.notifyListeners(event);
                    FacetedProjectWorkingCopy.this.refreshTargetableRuntimes();
                }
                finally {
                    FacetedProjectWorkingCopy.this.resumeEventNotification();
                }
                return Status.OK_STATUS;
            }
        };
        final IListener runtimeManagerListener = new IListener(){

            public void handle() {
                runtimesRefreshJob.schedule();
            }
        };
        RuntimeManager.addRuntimeListener(runtimeManagerListener);
        this.addDisposeTask(new Runnable(){

            public void run() {
                RuntimeManager.removeRuntimeListener(runtimeManagerListener);
            }
        });
        final IFacetedProjectFrameworkListener presetsListener = new IFacetedProjectFrameworkListener(){

            public void handleEvent(IFacetedProjectFrameworkEvent event) {
                FacetedProjectWorkingCopy.this.refreshAvailablePresets();
            }
        };
        FacetedProjectFramework.addListener(presetsListener, IFacetedProjectFrameworkEvent.Type.PRESET_ADDED, IFacetedProjectFrameworkEvent.Type.PRESET_REMOVED);
        this.addDisposeTask(new Runnable(){

            public void run() {
                FacetedProjectFramework.removeListener(presetsListener);
            }
        });
        IFacetedProjectListener targetedRuntimesChangedListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetedProjectWorkingCopy.this.performValidation();
            }
        };
        this.addListener(targetedRuntimesChangedListener, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProjectName() {
        Object object = this.lock;
        synchronized (object) {
            if (this.project != null) {
                return this.project.getProject().getName();
            }
            return this.projectName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectName(String name) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.project == null) {
                    if (!FacetedProjectWorkingCopy.equals(this.projectName, name)) {
                        this.projectName = name;
                        for (IFacetedProject.Action action : this.getProjectFacetActions()) {
                            Object config = action.getConfig();
                            if (config == null) continue;
                            IActionConfig c = null;
                            if (config instanceof IActionConfig) {
                                c = (IActionConfig)config;
                            } else {
                                IAdapterManager m = Platform.getAdapterManager();
                                String t = IActionConfig.class.getName();
                                c = (IActionConfig)m.loadAdapter(config, t);
                            }
                            if (c == null) continue;
                            c.setProjectName(this.projectName);
                        }
                        this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED));
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        IStatus validateNameResult = ws.validateName(this.projectName, 4);
                        if (!this.projectNameValidation.equals(validateNameResult)) {
                            this.projectNameValidation = validateNameResult;
                            this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED));
                        }
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPath getProjectLocation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.project != null) {
                return this.project.getProject().getLocation();
            }
            return this.projectLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectLocation(IPath location) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.project != null) {
                    throw new IllegalArgumentException();
                }
                this.projectLocation = location;
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    @Override
    public IProject getProject() {
        IFacetedProject fproj = this.getFacetedProject();
        if (fproj == null) {
            return null;
        }
        return fproj.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFacetedProject getFacetedProject() {
        Object object = this.lock;
        synchronized (object) {
            IProject pj;
            IWorkspace ws;
            if (this.project == null && this.projectName != null && (ws = ResourcesPlugin.getWorkspace()).validateName(this.projectName, 4).getSeverity() != 4 && (pj = ws.getRoot().getProject(this.projectName)) != null && pj.exists()) {
                try {
                    this.project = ProjectFacetsManager.create(pj);
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)((Object)e));
                }
            }
            return this.project;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProjectFacet> getFixedProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.fixedFacets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFixedProjectFacet(IProjectFacet facet) {
        Object object = this.lock;
        synchronized (object) {
            return this.fixedFacets.contains(facet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedProjectFacets(Set<IProjectFacet> fixed) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                block10: {
                    if (!this.fixedFacets.equals(fixed)) break block10;
                    return;
                }
                HashSet<IProjectFacetVersion> newFacets = new HashSet<IProjectFacetVersion>(this.getProjectFacets());
                for (IProjectFacet f : fixed) {
                    IProjectFacetVersion currentVersion = this.getProjectFacetVersion(f);
                    if (currentVersion != null || f.getVersions().size() <= 0) continue;
                    IProjectFacetVersion fv = f.getDefaultVersion();
                    if (!this.isFacetAvailable(fv)) {
                        fv = this.getHighestAvailableVersion(f);
                    }
                    if (fv == null) continue;
                    newFacets.add(fv);
                }
                this.setProjectFacets(newFacets);
                this.fixedFacets = Collections.unmodifiableSet(new HashSet<IProjectFacet>(fixed));
                this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED));
                this.refreshAvailableFacets();
                this.refreshAvailablePresets();
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<IProjectFacet, SortedSet<IProjectFacetVersion>> getAvailableFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.availableFacets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFacetAvailable(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            return this.availableFacets.containsKey(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFacetAvailable(IProjectFacetVersion fv) {
        Object object = this.lock;
        synchronized (object) {
            Set versions = this.availableFacets.get(fv.getProjectFacet());
            return versions != null && versions.contains(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<IProjectFacetVersion> getAvailableVersions(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<IProjectFacetVersion> availableVersions = this.availableFacets.get(f);
            if (availableVersions == null) {
                availableVersions = EMPTY_SORTED_FV_SET;
            }
            return availableVersions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectFacetVersion getHighestAvailableVersion(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            IProjectFacetVersion version = null;
            SortedSet<IProjectFacetVersion> availableVersions = this.availableFacets.get(f);
            if (availableVersions != null) {
                for (IProjectFacetVersion fv : availableVersions) {
                    if (version == null) {
                        version = fv;
                        continue;
                    }
                    if (fv.compareTo(version) <= 0) continue;
                    version = fv;
                }
            }
            return version;
        }
    }

    private void refreshAvailableFacets() {
        HashMap newAvailableFacets = new HashMap();
        Set<IRuntime> targetedRuntimes = this.getTargetedRuntimes();
        for (IProjectFacet iProjectFacet : ProjectFacetsManager.getProjectFacets()) {
            TreeSet<IProjectFacetVersion> versions = null;
            for (IProjectFacetVersion fv : iProjectFacet.getVersions()) {
                boolean available = true;
                if (this.project == null || !this.project.hasProjectFacet(fv)) {
                    for (IRuntime r : targetedRuntimes) {
                        if (r.supports(fv)) continue;
                        available = false;
                        break;
                    }
                    if (available && !fv.isValidFor(this.fixedFacets)) {
                        available = false;
                    }
                }
                if (!available) continue;
                if (versions == null) {
                    versions = new TreeSet<IProjectFacetVersion>();
                    newAvailableFacets.put(iProjectFacet, versions);
                }
                versions.add(fv);
            }
        }
        if (this.project != null) {
            for (IProjectFacetVersion iProjectFacetVersion : this.project.getProjectFacets()) {
                if (iProjectFacetVersion.getPluginId() != null) continue;
                IProjectFacet f = iProjectFacetVersion.getProjectFacet();
                TreeSet<IProjectFacetVersion> versions = (TreeSet<IProjectFacetVersion>)newAvailableFacets.get(f);
                if (versions == null) {
                    versions = new TreeSet<IProjectFacetVersion>();
                    newAvailableFacets.put(f, versions);
                }
                versions.add(iProjectFacetVersion);
            }
        }
        if (!this.availableFacets.equals(newAvailableFacets)) {
            for (Map.Entry entry : newAvailableFacets.entrySet()) {
                entry.setValue(Collections.unmodifiableSortedSet((SortedSet)entry.getValue()));
            }
            this.availableFacets = Collections.unmodifiableMap(newAvailableFacets);
            this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.AVAILABLE_FACETS_CHANGED));
            this.refreshAvailablePresets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProjectFacetVersion> getProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.getItemSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectFacetVersion getProjectFacetVersion(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.getItemByKey(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProjectFacet(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.containsKey(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProjectFacet(IProjectFacetVersion fv) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.containsItem(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectFacets(Set<IProjectFacetVersion> facets) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                HashSet<IProjectFacetVersion> changedVersions;
                HashSet<IProjectFacetVersion> removedFacets;
                HashSet<IProjectFacetVersion> addedFacets;
                IndexedSet<IProjectFacet, IProjectFacetVersion> newProjectFacets;
                block12: {
                    newProjectFacets = new IndexedSet<IProjectFacet, IProjectFacetVersion>();
                    for (IProjectFacetVersion fv : facets) {
                        newProjectFacets.addItemWithKey(fv.getProjectFacet(), fv);
                    }
                    addedFacets = new HashSet<IProjectFacetVersion>();
                    removedFacets = new HashSet<IProjectFacetVersion>();
                    changedVersions = new HashSet<IProjectFacetVersion>();
                    for (IProjectFacetVersion fv : newProjectFacets.getItemSet()) {
                        IProjectFacetVersion currentFacetVersion = this.facets.getItemByKey(fv.getProjectFacet());
                        if (currentFacetVersion == null) {
                            addedFacets.add(fv);
                            continue;
                        }
                        if (fv.equals(currentFacetVersion)) continue;
                        changedVersions.add(fv);
                    }
                    for (IProjectFacetVersion fv : this.facets.getItemSet()) {
                        if (newProjectFacets.containsKey(fv.getProjectFacet())) continue;
                        removedFacets.add(fv);
                    }
                    if (!addedFacets.isEmpty() || !removedFacets.isEmpty() || !changedVersions.isEmpty()) break block12;
                    return;
                }
                this.setSelectedPreset(null);
                this.facets = newProjectFacets;
                ProjectFacetsChangedEvent event = new ProjectFacetsChangedEvent(this, addedFacets, removedFacets, changedVersions);
                this.notifyListeners(event);
                this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PROJECT_MODIFIED));
                this.refreshTargetableRuntimes();
                this.refreshProjectFacetActions();
                this.refreshAvailablePresets();
                this.performValidation();
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProjectFacet(IProjectFacetVersion fv) {
        block9: {
            this.suspendEventNotification();
            try {
                Object object = this.lock;
                synchronized (object) {
                    block8: {
                        IProjectFacetVersion existingVersion;
                        block10: {
                            existingVersion = this.facets.getItemByKey(fv.getProjectFacet());
                            if (existingVersion != null) break block10;
                            HashSet<IProjectFacetVersion> newProjectFacets = new HashSet<IProjectFacetVersion>();
                            newProjectFacets.addAll(this.facets.getItemSet());
                            newProjectFacets.add(fv);
                            this.setProjectFacets(newProjectFacets);
                            break block9;
                        }
                        if (existingVersion != fv) break block8;
                        return;
                    }
                    throw new IllegalArgumentException();
                }
            }
            finally {
                this.resumeEventNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProjectFacet(IProjectFacet f) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                IProjectFacetVersion fv = this.getProjectFacetVersion(f);
                if (fv != null) {
                    this.removeProjectFacet(this.getProjectFacetVersion(f));
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProjectFacet(IProjectFacetVersion fv) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                IProjectFacetVersion existingVersion;
                block9: {
                    existingVersion = this.facets.getItemByKey(fv.getProjectFacet());
                    if (existingVersion != null) break block9;
                    return;
                }
                if (existingVersion != fv) {
                    throw new IllegalArgumentException();
                }
                HashSet<IProjectFacetVersion> newProjectFacets = new HashSet<IProjectFacetVersion>();
                newProjectFacets.addAll(this.facets.getItemSet());
                newProjectFacets.remove(fv);
                this.setProjectFacets(newProjectFacets);
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeProjectFacetVersion(IProjectFacetVersion fv) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                IProjectFacetVersion existingVersion;
                block9: {
                    existingVersion = this.facets.getItemByKey(fv.getProjectFacet());
                    if (existingVersion == null) {
                        throw new IllegalArgumentException();
                    }
                    if (existingVersion != fv) break block9;
                    return;
                }
                HashSet<IProjectFacetVersion> newProjectFacets = new HashSet<IProjectFacetVersion>();
                newProjectFacets.addAll(this.facets.getItemSet());
                newProjectFacets.remove(existingVersion);
                newProjectFacets.add(fv);
                this.setProjectFacets(newProjectFacets);
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    private Set<IProjectFacetVersion> getBaseProjectFacets() {
        if (this.project == null) {
            return Collections.emptySet();
        }
        return this.project.getProjectFacets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IPreset> getAvailablePresets() {
        Object object = this.lock;
        synchronized (object) {
            return this.availablePresets.getItemSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAvailablePresets() {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                IndexedSet<String, IPreset> newAvailablePresets = new IndexedSet<String, IPreset>();
                HashMap<String, Object> context = null;
                for (IPreset preset : ProjectFacetsManager.getPresets()) {
                    if (preset.getType() == IPreset.Type.DYNAMIC) {
                        if (context == null) {
                            context = new HashMap<String, Object>();
                            context.put("CONTEXT_KEY_FACETED_PROJECT", this);
                            context.put("CONTEXT_KEY_PRIMARY_RUNTIME", this.primaryRuntime);
                            context.put("CONTEXT_KEY_FIXED_FACETS", this.fixedFacets);
                        }
                        if ((preset = ((IDynamicPreset)preset).resolve(context)) == null) continue;
                    }
                    Set<IProjectFacetVersion> facets = preset.getProjectFacets();
                    boolean applicable = true;
                    for (IProjectFacetVersion fv : facets) {
                        if (this.isFacetAvailable(fv)) continue;
                        applicable = false;
                        break;
                    }
                    for (IProjectFacet f : this.fixedFacets) {
                        boolean found = false;
                        for (IProjectFacetVersion fv : f.getVersions()) {
                            if (!facets.contains(fv)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        applicable = false;
                        break;
                    }
                    if (!applicable) continue;
                    newAvailablePresets.addItemWithKey(preset.getId(), preset);
                }
                if (!this.availablePresets.equals(newAvailablePresets)) {
                    this.availablePresets = newAvailablePresets;
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.AVAILABLE_PRESETS_CHANGED));
                    if (this.selectedPresetId != null && !this.availablePresets.containsKey(this.selectedPresetId)) {
                        this.setSelectedPreset(null);
                    }
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreset getSelectedPreset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.selectedPresetId != null) {
                return this.availablePresets.getItemByKey(this.selectedPresetId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedPreset(String presetId) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (presetId != null && !this.availablePresets.containsKey(presetId)) {
                    String msg = Resources.bind((String)Resources.couldNotSelectPreset, (Object)presetId);
                    throw new IllegalArgumentException(msg);
                }
                IPreset preset = this.availablePresets.getItemByKey(presetId);
                if (!FacetedProjectWorkingCopy.equals(this.selectedPresetId, presetId) || preset != null && !FacetedProjectWorkingCopy.equals(preset.getProjectFacets(), this.getProjectFacets())) {
                    if (preset != null) {
                        this.selectedPresetId = null;
                        this.setProjectFacets(preset.getProjectFacets());
                    }
                    this.selectedPresetId = presetId;
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED));
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreset getDefaultConfiguration() {
        Object object = this.lock;
        synchronized (object) {
            return this.availablePresets.getItemByKey("default.configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreset getMinimalConfiguration() {
        Object object = this.lock;
        synchronized (object) {
            return this.availablePresets.getItemByKey("minimal.configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IRuntime> getTargetableRuntimes() {
        Object object = this.lock;
        synchronized (object) {
            return this.targetableRuntimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTargetable(IRuntime runtime) {
        Object object = this.lock;
        synchronized (object) {
            return this.targetableRuntimes.contains(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshTargetableRuntimes() {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                HashSet<IRuntime> result = new HashSet<IRuntime>();
                for (IRuntime r : RuntimeManager.getRuntimes()) {
                    boolean ok = true;
                    for (IProjectFacetVersion fv : this.facets.getItemSet()) {
                        if (r.supports(fv)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    result.add(r);
                }
                if (!this.targetableRuntimes.equals(result)) {
                    this.targetableRuntimes.clear();
                    this.targetableRuntimes.addAll(result);
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.TARGETABLE_RUNTIMES_CHANGED));
                    ArrayList<IRuntime> toRemove = new ArrayList<IRuntime>();
                    for (IRuntime r : this.targetedRuntimes) {
                        if (this.targetableRuntimes.contains(r)) continue;
                        toRemove.add(r);
                    }
                    this.targetedRuntimes.removeAll(toRemove);
                    if (!toRemove.isEmpty()) {
                        this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED));
                        this.refreshAvailableFacets();
                        if (this.primaryRuntime != null && !this.targetableRuntimes.contains(this.primaryRuntime)) {
                            this.autoAssignPrimaryRuntime();
                        }
                    }
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IRuntime> getTargetedRuntimes() {
        Object object = this.lock;
        synchronized (object) {
            return this.targetedRuntimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTargeted(IRuntime runtime) {
        Object object = this.lock;
        synchronized (object) {
            return this.targetedRuntimes.contains(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTargetedRuntimes(Set<IRuntime> runtimes) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.targetedRuntimes.equals(runtimes)) {
                    this.targetedRuntimes.clear();
                    this.targetedRuntimes.addAll(runtimes);
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED));
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PROJECT_MODIFIED));
                    this.refreshAvailableFacets();
                    if (this.primaryRuntime == null || !this.targetedRuntimes.contains(this.primaryRuntime)) {
                        this.autoAssignPrimaryRuntime();
                    }
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargetedRuntime(IRuntime runtime) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (runtime == null) {
                    throw new NullPointerException();
                }
                this.targetedRuntimes.add(runtime);
                this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED));
                this.refreshAvailableFacets();
                if (this.primaryRuntime == null) {
                    this.primaryRuntime = runtime;
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED));
                    this.refreshAvailablePresets();
                }
                this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PROJECT_MODIFIED));
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetedRuntime(IRuntime runtime) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (runtime == null) {
                    throw new NullPointerException();
                }
                if (this.targetedRuntimes.remove(runtime)) {
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED));
                    this.refreshAvailableFacets();
                    if (runtime.equals(this.primaryRuntime)) {
                        this.autoAssignPrimaryRuntime();
                    }
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PROJECT_MODIFIED));
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRuntime getPrimaryRuntime() {
        Object object = this.lock;
        synchronized (object) {
            return this.primaryRuntime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryRuntime(IRuntime runtime) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!FacetedProjectWorkingCopy.equals(this.primaryRuntime, runtime)) {
                    if (runtime == null && this.targetedRuntimes.size() > 0) {
                        throw new IllegalArgumentException();
                    }
                    if (this.targetedRuntimes.contains(runtime)) {
                        this.primaryRuntime = runtime;
                    }
                    this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED));
                    this.refreshAvailablePresets();
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    private void autoAssignPrimaryRuntime() {
        this.primaryRuntime = this.targetedRuntimes.isEmpty() ? null : this.targetedRuntimes.iterator().next();
        this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED));
        this.refreshAvailablePresets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IFacetedProject.Action> getProjectFacetActions() {
        Object object = this.lock;
        synchronized (object) {
            return this.actions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFacetedProject.Action getProjectFacetAction(IProjectFacet facet) {
        Object object = this.lock;
        synchronized (object) {
            return FacetedProjectWorkingCopy.getProjectFacetAction(this.actions, null, facet);
        }
    }

    private static IFacetedProject.Action getProjectFacetAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        for (IFacetedProject.Action action : actions) {
            if (type != null && action.getType() != type || action.getProjectFacetVersion() != fv) continue;
            return action;
        }
        return null;
    }

    private static IFacetedProject.Action getProjectFacetAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacet f) {
        for (IFacetedProject.Action action : actions) {
            if (type != null && action.getType() != type || action.getProjectFacetVersion().getProjectFacet() != f) continue;
            return action;
        }
        return null;
    }

    private IFacetedProject.Action createProjectFacetAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        IFacetedProject.Action action = FacetedProjectWorkingCopy.getProjectFacetAction(actions, type, fv);
        if (action == null) {
            Set<IProjectFacetVersion> base = this.getBaseProjectFacets();
            Object config = null;
            if (fv.supports(base, type)) {
                try {
                    IProjectFacet f = fv.getProjectFacet();
                    action = FacetedProjectWorkingCopy.getProjectFacetAction(actions, type, f);
                    if (action != null) {
                        IProjectFacetVersion current = action.getProjectFacetVersion();
                        if (fv.supports(base, type) && current.supports(base, type) && fv.getActionDefinition(base, type) == current.getActionDefinition(base, type)) {
                            config = action.getConfig();
                        }
                    }
                    if (config == null) {
                        IActionDefinition def = fv.getActionDefinition(base, type);
                        config = def.createConfigObject();
                    }
                    this.bindProjectFacetActionConfig(config, fv);
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)((Object)e));
                }
            }
            action = new IFacetedProject.Action(type, fv, config);
        }
        return action;
    }

    private void bindProjectFacetActionConfig(Object actionConfig, IProjectFacetVersion fv) {
        if (actionConfig != null) {
            IActionConfig c1 = null;
            if (actionConfig instanceof IActionConfig) {
                c1 = (IActionConfig)actionConfig;
            } else if (actionConfig != null) {
                IAdapterManager m = Platform.getAdapterManager();
                String t = IActionConfig.class.getName();
                c1 = (IActionConfig)m.loadAdapter(actionConfig, t);
            }
            if (c1 != null) {
                c1.setProjectName(this.getProjectName());
                if (fv != null) {
                    c1.setVersion(fv);
                }
            }
            ActionConfig c2 = null;
            if (actionConfig instanceof ActionConfig) {
                c2 = (ActionConfig)actionConfig;
            } else if (actionConfig != null) {
                IAdapterManager m = Platform.getAdapterManager();
                String t = ActionConfig.class.getName();
                c2 = (ActionConfig)m.loadAdapter(actionConfig, t);
            }
            if (c2 != null) {
                c2.setFacetedProjectWorkingCopy(this);
                if (fv != null) {
                    c2.setProjectFacetVersion(fv);
                }
            }
        }
    }

    private void refreshProjectFacetActions() {
        Set<IProjectFacetVersion> base = this.getBaseProjectFacets();
        Set<IProjectFacetVersion> sel = this.getProjectFacets();
        HashSet<IFacetedProject.Action> old = new HashSet<IFacetedProject.Action>(this.actions);
        HashSet<IFacetedProject.Action> newActions = new HashSet<IFacetedProject.Action>();
        for (IProjectFacetVersion fv : base) {
            if (sel.contains(fv)) continue;
            newActions.add(this.createProjectFacetAction(old, IFacetedProject.Action.Type.UNINSTALL, fv));
        }
        for (IProjectFacetVersion fv : sel) {
            if (base.contains(fv)) continue;
            newActions.add(this.createProjectFacetAction(old, IFacetedProject.Action.Type.INSTALL, fv));
        }
        HashSet<IFacetedProject.Action> toadd = new HashSet<IFacetedProject.Action>();
        HashSet<IFacetedProject.Action> toremove = new HashSet<IFacetedProject.Action>();
        for (IFacetedProject.Action action1 : newActions) {
            for (IFacetedProject.Action action2 : newActions) {
                if (action1.getType() != IFacetedProject.Action.Type.UNINSTALL || action2.getType() != IFacetedProject.Action.Type.INSTALL) continue;
                IProjectFacetVersion f1 = action1.getProjectFacetVersion();
                IProjectFacetVersion f2 = action2.getProjectFacetVersion();
                if (f1.getProjectFacet() != f2.getProjectFacet()) continue;
                toremove.add(action1);
                toremove.add(action2);
                toadd.add(this.createProjectFacetAction(old, IFacetedProject.Action.Type.VERSION_CHANGE, f2));
            }
        }
        newActions.removeAll(toremove);
        newActions.addAll(toadd);
        this.actions = newActions;
        for (IFacetedProject.Action action : toremove) {
            Object actionConfig = action.getConfig();
            ActionConfig c = null;
            if (actionConfig instanceof ActionConfig) {
                c = (ActionConfig)actionConfig;
            } else if (actionConfig != null) {
                IAdapterManager m = Platform.getAdapterManager();
                String t = ActionConfig.class.getName();
                c = (ActionConfig)m.loadAdapter(actionConfig, t);
            }
            if (c == null) continue;
            c.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectFacetActionConfig(IProjectFacet facet, Object newActionConfig) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                IFacetedProject.Action oldAction = this.getProjectFacetAction(facet);
                if (oldAction == null) {
                    throw new IllegalArgumentException();
                }
                IProjectFacetVersion fv = oldAction.getProjectFacetVersion();
                IFacetedProject.Action newAction = new IFacetedProject.Action(oldAction.getType(), fv, newActionConfig);
                this.bindProjectFacetActionConfig(newActionConfig, fv);
                this.actions.remove(oldAction);
                this.actions.add(newAction);
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    @Override
    public void detect(IProgressMonitor monitor) {
        block15: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 1000);
            try {
                List<ProjectFacetDetector> detectors = ProjectFacetDetectorsExtensionPoint.getDetectors();
                monitor.worked(100);
                if (detectors.isEmpty()) break block15;
                SubProgressMonitor submon = new SubProgressMonitor(monitor, 900);
                submon.beginTask("", detectors.size());
                try {
                    for (ProjectFacetDetector detector : detectors) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        SubProgressMonitor detectorProgressMonitor = new SubProgressMonitor((IProgressMonitor)submon, 1);
                        try {
                            try {
                                detector.detect(this, (IProgressMonitor)detectorProgressMonitor);
                            }
                            catch (Exception e) {
                                FacetCorePlugin.log(e);
                                detectorProgressMonitor.done();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            detectorProgressMonitor.done();
                            throw throwable;
                        }
                        detectorProgressMonitor.done();
                    }
                }
                finally {
                    submon.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        Object object = this.lock;
        synchronized (object) {
            if (types.length == 0) {
                throw new IllegalArgumentException();
            }
            IFacetedProjectEvent.Type[] typeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IFacetedProjectEvent.Type type = typeArray[n2];
                this.listeners.get((Object)type).add(listener);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IFacetedProjectListener listener) {
        Object object = this.lock;
        synchronized (object) {
            for (List<IFacetedProjectListener> listeners : this.listeners.values()) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(IFacetedProjectEvent event) {
        List<IFacetedProjectListener> listenersToNotify = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.suspendEventNoticationCounter == 0) {
                listenersToNotify = this.listeners.get((Object)event.getType());
            } else {
                this.queuedEvents.add(event);
            }
        }
        if (listenersToNotify != null) {
            for (IFacetedProjectListener listener : listenersToNotify) {
                try {
                    listener.handleEvent(event);
                }
                catch (Exception e) {
                    FacetCorePlugin.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendEventNotification() {
        Object object = this.lock;
        synchronized (object) {
            ++this.suspendEventNoticationCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeEventNotification() {
        ArrayList<IFacetedProjectEvent> eventsToFire = null;
        Object object = this.lock;
        synchronized (object) {
            --this.suspendEventNoticationCounter;
            if (this.suspendEventNoticationCounter == 0) {
                if (!this.queuedEvents.isEmpty()) {
                    eventsToFire = new ArrayList<IFacetedProjectEvent>();
                    eventsToFire.addAll(this.queuedEvents);
                    this.queuedEvents.clear();
                }
            } else if (this.suspendEventNoticationCounter < 0) {
                throw new IllegalStateException();
            }
        }
        if (eventsToFire != null) {
            for (IFacetedProjectEvent event : eventsToFire) {
                this.notifyListeners(event);
            }
        }
    }

    @Override
    public IStatus validate(IProgressMonitor monitor) {
        return this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus validate() {
        Object object = this.lock;
        synchronized (object) {
            MultiStatus ms = Constraint.createMultiStatus();
            if (!this.projectNameValidation.isOK()) {
                StatusWrapper wrapper = new StatusWrapper(this.projectNameValidation);
                wrapper.setCode(1);
                ms.add((IStatus)wrapper);
            }
            for (IStatus st : this.problems) {
                StatusWrapper wrapper = new StatusWrapper(st);
                wrapper.setCode(-1);
                ms.add((IStatus)wrapper);
            }
            for (IRuntime runtime : this.targetedRuntimes) {
                IStatus st = runtime.validate((IProgressMonitor)new NullProgressMonitor());
                if (st.isOK()) continue;
                String msg = Resources.bind((String)Resources.invalidRuntimeMsg, (Object)runtime.getName(), (Object)st.getMessage());
                StatusWrapper wrapper = new StatusWrapper(st);
                wrapper.setMessage(msg);
                ms.add((IStatus)wrapper);
            }
            return ms;
        }
    }

    private void performValidation() {
        Set<IProjectFacetVersion> base = this.getBaseProjectFacets();
        ArrayList<IStatus> probs = new ArrayList<IStatus>();
        MultiStatus ms = (MultiStatus)ProjectFacetsManager.check(base, this.actions);
        IStatus[] iStatusArray = ms.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus st = iStatusArray[n2];
            probs.add(st);
            ++n2;
        }
        for (IProjectFacetVersion fv : base) {
            IProjectFacet f = fv.getProjectFacet();
            String msg = null;
            if (f.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetNotFound, (Object)f.getId());
            } else if (fv.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetVersionNotFound, (Object)f.getId(), (Object)fv.getVersionString());
            }
            if (msg == null) continue;
            Status sub = new Status(2, "org.eclipse.wst.common.project.facet.core", 0, msg, null);
            probs.add((IStatus)sub);
        }
        for (IRuntime r : this.getTargetedRuntimes()) {
            for (IProjectFacetVersion fv : this.getProjectFacets()) {
                if (r.supports(fv)) continue;
                String msg = NLS.bind((String)Resources.facetNotSupportedByTarget, (Object)fv.toString(), (Object)r.getLocalizedName());
                Status sub = new Status(4, "org.eclipse.wst.common.project.facet.core", 0, msg, null);
                probs.add((IStatus)sub);
            }
        }
        if (!probs.equals(this.problems)) {
            this.problems = probs;
            this.notifyListeners(new FacetedProjectEvent(this, IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED));
        }
    }

    @Override
    public boolean isDirty() {
        if (this.project == null) {
            return true;
        }
        return !this.equal(this.project.getFixedProjectFacets(), this.getFixedProjectFacets()) || !this.equal(this.project.getProjectFacets(), this.getProjectFacets()) || !this.equal(this.project.getTargetedRuntimes(), this.getTargetedRuntimes()) || !this.equal(this.project.getPrimaryRuntime(), this.getPrimaryRuntime());
    }

    private boolean equal(Object obj1, Object obj2) {
        return MiscUtil.equal(obj1, obj2);
    }

    private boolean equal(IRuntime r1, IRuntime r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.getName().equals(r2.getName());
    }

    private boolean equal(Set<IRuntime> set1, Set<IRuntime> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        for (IRuntime r1 : set1) {
            boolean found = false;
            for (IRuntime r2 : set2) {
                if (!r1.getName().equals(r2.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitChanges(IProgressMonitor monitor) throws CoreException {
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            FacetedProjectWorkingCopy clone;
            Object object = this.lock;
            synchronized (object) {
                clone = (FacetedProjectWorkingCopy)this.clone();
            }
            try {
                IFacetedProject fpj;
                if (this.project == null) {
                    this.project = fpj = ProjectFacetsManager.create(this.projectName, this.projectLocation, (IProgressMonitor)pm.newChild(10, 7));
                } else {
                    fpj = clone.getFacetedProject();
                    pm.worked(10);
                }
                ((FacetedProject)fpj).mergeChanges(clone, (IProgressMonitor)pm.newChild(90));
            }
            finally {
                clone.dispose();
            }
            object = this.lock;
            synchronized (object) {
                this.projectName = null;
                this.projectNameValidation = Status.OK_STATUS;
                this.projectLocation = null;
                this.revertChanges();
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChanges(IFacetedProjectWorkingCopy fpjwc) {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.setProjectName(fpjwc.getProjectName());
                this.setProjectLocation(fpjwc.getProjectLocation());
                this.setFixedProjectFacets(fpjwc.getFixedProjectFacets());
                this.setProjectFacets(fpjwc.getProjectFacets());
                this.setTargetedRuntimes(fpjwc.getTargetedRuntimes());
                this.setPrimaryRuntime(fpjwc.getPrimaryRuntime());
                IPreset selectedPreset = fpjwc.getSelectedPreset();
                if (selectedPreset != null) {
                    this.setSelectedPreset(selectedPreset.getId());
                }
                this.actions.clear();
                this.actions.addAll(((FacetedProjectWorkingCopy)fpjwc).actions);
                for (IFacetedProject.Action action : this.actions) {
                    this.bindProjectFacetActionConfig(action.getConfig(), null);
                }
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revertChanges() {
        this.suspendEventNotification();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.project == null) {
                    throw new UnsupportedOperationException();
                }
                this.setFixedProjectFacets(this.project.getFixedProjectFacets());
                this.setTargetedRuntimes(Collections.<IRuntime>emptySet());
                this.setProjectFacets(this.project.getProjectFacets());
                this.setTargetedRuntimes(this.project.getTargetedRuntimes());
                this.setPrimaryRuntime(this.project.getPrimaryRuntime());
                this.actions.clear();
            }
        }
        finally {
            this.resumeEventNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFacetedProjectWorkingCopy clone() {
        Object object = this.lock;
        synchronized (object) {
            FacetedProjectWorkingCopy clone = new FacetedProjectWorkingCopy(this.project);
            if (this.project == null) {
                clone.setProjectName(this.getProjectName());
                clone.setProjectLocation(this.getProjectLocation());
            }
            clone.setFixedProjectFacets(this.getFixedProjectFacets());
            clone.setProjectFacets(this.getProjectFacets());
            clone.setTargetedRuntimes(this.getTargetedRuntimes());
            clone.setPrimaryRuntime(this.getPrimaryRuntime());
            IPreset selectedPreset = this.getSelectedPreset();
            if (selectedPreset != null) {
                clone.setSelectedPreset(selectedPreset.getId());
            }
            clone.actions.clear();
            clone.actions.addAll(this.actions);
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Runnable> list = this.disposeTasks;
        synchronized (list) {
            for (Runnable task : this.disposeTasks) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    FacetCorePlugin.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeTask(Runnable task) {
        List<Runnable> list = this.disposeTasks;
        synchronized (list) {
            this.disposeTasks.add(task);
        }
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static final class Resources
    extends NLS {
        public static String couldNotSelectPreset;
        public static String facetNotFound;
        public static String facetVersionNotFound;
        public static String facetNotSupportedByTarget;
        public static String invalidRuntimeMsg;
        public static String refreshingAvailableRuntimesJobName;

        static {
            Resources.initializeMessages((String)FacetedProjectWorkingCopy.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

