/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallGraphAnalysis
extends TmfAbstractAnalysisModule
implements ICallGraphProvider {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.callgraphanalysis";
    private List<ThreadNode> fThreadNodes = new ArrayList<ThreadNode>();
    private final @Nullable CallStackAnalysis fCallStackAnalysis;

    protected CallGraphAnalysis() {
        this.fCallStackAnalysis = null;
    }

    public CallGraphAnalysis(CallStackAnalysis callStackAnalysis) {
        this.fCallStackAnalysis = callStackAnalysis;
    }

    public @NonNull String getHelpText() {
        String msg = Messages.CallGraphAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        CallStackAnalysis callStackAnalysis = this.fCallStackAnalysis;
        if (callStackAnalysis == null) {
            throw new NullPointerException("If the analysis is not set, this method should not be called");
        }
        return Collections.singleton(callStackAnalysis);
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (monitor == null || trace == null) {
            return false;
        }
        CallStackAnalysis callstackModule = this.fCallStackAnalysis;
        if (callstackModule == null) {
            return false;
        }
        callstackModule.schedule();
        callstackModule.waitForCompletion(monitor);
        String[] threadsPattern = callstackModule.getThreadsPattern();
        String[] processesPattern = callstackModule.getProcessesPattern();
        ITmfStateSystem ss = callstackModule.getStateSystem();
        if (ss == null || !this.iterateOverStateSystem(ss, threadsPattern, processesPattern, monitor)) {
            return false;
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    @VisibleForTesting
    protected boolean iterateOverStateSystem(ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, IProgressMonitor monitor) {
        List processQuarks = ss.getQuarks(processesPattern);
        HashMap<ThreadNode, List<Integer>> mainAttribs = new HashMap<ThreadNode, List<Integer>>();
        Iterator iterator = processQuarks.iterator();
        while (iterator.hasNext()) {
            int processQuark = (Integer)iterator.next();
            int processId = CallGraphAnalysis.getProcessId(ss, processQuark, ss.getCurrentEndTime());
            Iterator iterator2 = ss.getQuarks(processQuark, threadsPattern).iterator();
            while (iterator2.hasNext()) {
                List subAttributes;
                int threadQuark = (Integer)iterator2.next();
                int callStackQuark = ss.optQuarkRelative(threadQuark, new String[]{"CallStack"});
                if (callStackQuark == -2 || (subAttributes = ss.getSubAttributes(callStackQuark, false)).isEmpty()) continue;
                String threadName = ss.getAttributeName(threadQuark);
                long threadId = CallGraphAnalysis.getProcessId(ss, threadQuark, ss.getStartTime());
                CalledStringFunction initSegment = CalledFunctionFactory.create(0L, 0L, -1, threadName, processId, null);
                ThreadNode init = new ThreadNode(initSegment, 0, threadId);
                this.fThreadNodes.add(init);
                mainAttribs.put(init, subAttributes);
            }
        }
        CallGraphAnalysis.iterateOverCallStack2D(ss, mainAttribs, monitor);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean iterateOverCallStack2D(ITmfStateSystem ss, Map<ThreadNode, List<Integer>> parentAttribs, IProgressMonitor monitor) {
        try {
            long start = ss.getStartTime();
            long end = ss.getCurrentEndTime();
            HashMap<Integer, CallGraphLevel> attribToLevel = new HashMap<Integer, CallGraphLevel>();
            ArrayList<Integer> attributes = new ArrayList<Integer>();
            for (Map.Entry<ThreadNode, List<Integer>> entry : parentAttribs.entrySet()) {
                ThreadNode threadNode = entry.getKey();
                List<Integer> subAttributes = entry.getValue();
                attributes.addAll(subAttributes);
                CallGraphLevel prevLevel = null;
                int i = 0;
                while (i < subAttributes.size()) {
                    CallGraphLevel level = new CallGraphLevel(threadNode, i, prevLevel);
                    if (prevLevel != null) {
                        prevLevel.setChild(level);
                    }
                    prevLevel = level;
                    attribToLevel.put(subAttributes.get(i), level);
                    ++i;
                }
            }
            for (ITmfStateInterval interval : ss.query2D(attributes, end, start)) {
                if (monitor.isCanceled()) {
                    return false;
                }
                CallGraphLevel level = (CallGraphLevel)attribToLevel.get(interval.getAttribute());
                if (level == null) {
                    throw new NullPointerException("The level should not be null, we created it just before!");
                }
                long intervalStart = interval.getStartTime();
                long intervalEnd = interval.getEndTime();
                CallgraphRange range = new CallgraphRange(intervalStart, intervalEnd);
                Object value = interval.getValue();
                if (value == null) {
                    level.setCovered(range);
                } else {
                    AggregatedCalledFunction aggregated;
                    AggregatedCalledFunction parent = level.findParentAggregated(range);
                    if (parent == null) {
                        level.addInterval(interval);
                        continue;
                    }
                    FunctionCall parentData = level.getParentData(parent);
                    AbstractCalledFunction function = CalledFunctionFactory.create(intervalStart, intervalEnd + 1L, level.getDepth(), value, level.getProcessId(), (ICalledFunction)(parentData == null ? null : parentData.fFunc));
                    if (!level.recursiveCoverChildren(range, function, aggregated = new AggregatedCalledFunction(function, parent))) {
                        level.fAggregated.put(aggregated, new FunctionCall(range, function));
                        continue;
                    }
                    parent.addChild(function, aggregated);
                    level.setCovered(range);
                }
                level.tryToCompleteParentCoverage(range);
            }
            return true;
        }
        catch (StateSystemDisposedException e) {
            return false;
        }
    }

    protected void canceling() {
    }

    public Collection<ThreadNode> getFlameGraph() {
        CalledStringFunction initSegment = CalledFunctionFactory.create(0L, 0L, -1, "", 0, null);
        ThreadNode init = new ThreadNode(initSegment, 0, 0L);
        this.fThreadNodes.forEach(tn -> tn.getChildren().forEach(child -> init.addChild(initSegment, child.clone())));
        return Collections.singleton(init);
    }

    public List<ThreadNode> getThreadNodes() {
        return ImmutableList.copyOf(this.fThreadNodes);
    }

    private static int getProcessId(ITmfStateSystem ss, int processQuark, long curTime) {
        if (processQuark != -1) {
            try {
                ITmfStateInterval interval = ss.querySingleState(curTime, processQuark);
                String processName = ss.getAttributeName(processQuark);
                Object processValue = interval.getValue();
                if (processValue != null && (processValue instanceof Integer || processValue instanceof Long)) {
                    return ((Number)processValue).intValue();
                }
                return Integer.parseInt(processName);
            }
            catch (NumberFormatException | StateSystemDisposedException throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    private static class CallGraphLevel {
        private final ThreadNode fThreadNode;
        private final List<CallgraphRange> fRanges = new ArrayList<CallgraphRange>();
        private final Map<AggregatedCalledFunction, FunctionCall> fAggregated = new HashMap<AggregatedCalledFunction, FunctionCall>();
        private final List<ITmfStateInterval> fOrphanedIntervals = new ArrayList<ITmfStateInterval>();
        private final @Nullable CallGraphLevel fParent;
        private final int fDepth;
        private @Nullable CallGraphLevel fChild = null;

        public CallGraphLevel(ThreadNode threadNode, int depth, @Nullable CallGraphLevel parent) {
            this.fThreadNode = threadNode;
            this.fDepth = depth;
            this.fParent = parent;
        }

        public void addInterval(ITmfStateInterval interval) {
            this.fOrphanedIntervals.add(interval);
        }

        public void setChild(CallGraphLevel childLvl) {
            this.fChild = childLvl;
        }

        public void setCovered(CallgraphRange newRange) {
            ArrayList<CallgraphRange> toRemove = new ArrayList<CallgraphRange>();
            CallgraphRange addRange = newRange;
            for (CallgraphRange range : this.fRanges) {
                if (!newRange.overlapOrContiguous(range)) continue;
                addRange = addRange.getUnion(range);
                toRemove.add(range);
            }
            for (CallgraphRange range : toRemove) {
                this.fRanges.remove(range);
            }
            this.fRanges.add(addRange);
        }

        private @Nullable AggregatedCalledFunction findAggregated(CallgraphRange range) {
            for (Map.Entry<AggregatedCalledFunction, FunctionCall> entry : this.fAggregated.entrySet()) {
                if (!entry.getValue().fRange.includes(range)) continue;
                return entry.getKey();
            }
            return null;
        }

        public @Nullable AggregatedCalledFunction findParentAggregated(CallgraphRange range) {
            CallGraphLevel parent = this.fParent;
            if (parent == null) {
                return this.fThreadNode;
            }
            return parent.findAggregated(range);
        }

        private boolean isRangeCovered(CallgraphRange range) {
            for (CallgraphRange coveredRange : this.fRanges) {
                if (!coveredRange.includes(range)) continue;
                return true;
            }
            return false;
        }

        public boolean recursiveCoverChildren(CallgraphRange range, AbstractCalledFunction function, AggregatedCalledFunction aggregated) {
            CallGraphLevel child = this.fChild;
            if (child == null) {
                return true;
            }
            for (CallgraphRange childRange : child.fRanges) {
                CallgraphRange covered = range.getIntersection(childRange);
                if (covered == null) continue;
                this.setCovered(covered);
            }
            ArrayList<ITmfStateInterval> toRemove = new ArrayList<ITmfStateInterval>();
            for (ITmfStateInterval interval : child.fOrphanedIntervals) {
                if (!range.includes(interval)) continue;
                toRemove.add(interval);
                CallgraphRange childRange = new CallgraphRange(interval.getStartTime(), interval.getEndTime());
                AbstractCalledFunction childFunc = CalledFunctionFactory.create(childRange.fStart, childRange.fEnd + 1L, this.fDepth + 1, Objects.requireNonNull(interval.getValue()), this.fThreadNode.getProcessId(), (ICalledFunction)function);
                AggregatedCalledFunction childAgg = new AggregatedCalledFunction(childFunc, aggregated);
                if (child.recursiveCoverChildren(childRange, childFunc, childAgg)) {
                    aggregated.addChild(childFunc, childAgg);
                    child.setCovered(childRange);
                    this.setCovered(childRange);
                    continue;
                }
                child.fAggregated.put(childAgg, new FunctionCall(childRange, childFunc));
            }
            child.fOrphanedIntervals.removeAll(toRemove);
            return this.isRangeCovered(range);
        }

        public void tryToCompleteParentCoverage(CallgraphRange range) {
            CallGraphLevel parent = this.fParent;
            if (parent == null) {
                return;
            }
            parent.tryToCompleteCoverage(range, this);
        }

        private void tryToCompleteCoverage(CallgraphRange range, CallGraphLevel child) {
            ArrayList<AggregatedCalledFunction> toRemove = new ArrayList<AggregatedCalledFunction>();
            for (Map.Entry<AggregatedCalledFunction, FunctionCall> entry : this.fAggregated.entrySet()) {
                CallgraphRange parentRange = entry.getValue().fRange;
                if (!parentRange.overlap(range) || !child.isRangeCovered(parentRange)) continue;
                toRemove.add(entry.getKey());
                AggregatedCalledFunction parent = this.findParentAggregated(parentRange);
                if (parent == null) continue;
                parent.addChild(entry.getValue().fFunc, entry.getKey());
                this.setCovered(parentRange);
                this.tryToCompleteParentCoverage(parentRange);
            }
            for (AggregatedCalledFunction agg : toRemove) {
                this.fAggregated.remove(agg);
            }
        }

        public @Nullable FunctionCall getParentData(AggregatedCalledFunction parentCall) {
            CallGraphLevel parent = this.fParent;
            if (parent == null) {
                return null;
            }
            return parent.fAggregated.get(parentCall);
        }

        public int getDepth() {
            return this.fDepth;
        }

        public int getProcessId() {
            return this.fThreadNode.getProcessId();
        }
    }

    private static class CallgraphRange {
        private final long fStart;
        private final long fEnd;

        public CallgraphRange(long start, long end) {
            this.fStart = start;
            this.fEnd = end;
        }

        public boolean overlap(CallgraphRange other) {
            return this.fStart <= other.fEnd && this.fEnd >= other.fStart;
        }

        public boolean overlapOrContiguous(CallgraphRange other) {
            if (this.overlap(other)) {
                return true;
            }
            return this.fStart - 1L == other.fEnd || this.fEnd + 1L == other.fStart;
        }

        public boolean includes(CallgraphRange other) {
            return this.fStart <= other.fStart && this.fEnd >= other.fEnd;
        }

        public boolean includes(ITmfStateInterval interval) {
            return this.fStart <= interval.getStartTime() && this.fEnd >= interval.getEndTime();
        }

        public @Nullable CallgraphRange getIntersection(CallgraphRange other) {
            if (this.fStart > other.fEnd || this.fEnd < other.fStart) {
                return null;
            }
            return new CallgraphRange(Math.max(this.fStart, other.fStart), Math.min(this.fEnd, other.fEnd));
        }

        public CallgraphRange getUnion(CallgraphRange other) {
            return new CallgraphRange(Math.min(this.fStart, other.fStart), Math.max(this.fEnd, other.fEnd));
        }
    }

    private static class FunctionCall {
        CallgraphRange fRange;
        AbstractCalledFunction fFunc;

        public FunctionCall(CallgraphRange range, AbstractCalledFunction function) {
            this.fRange = range;
            this.fFunc = function;
        }
    }
}

