/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.text;

import java.util.regex.Pattern;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceContext;
import org.junit.Assert;
import org.junit.Test;

public class TextTraceContextTest {
    private final Long aLong1 = 12345L;
    private final Long aLong2 = 12346L;
    private final Long aLong3 = 12347L;
    private final TmfLongLocation fLocation1 = new TmfLongLocation(this.aLong1);
    private final TmfLongLocation fLocation2 = new TmfLongLocation(this.aLong2);
    private final long fRank1 = 1L;
    private final long fRank2 = 2L;
    private final TextTraceContext fContext1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
    private final TextTraceContext fContext2 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
    private final Pattern pattern1 = Pattern.compile("\\s*.*");
    private final Pattern pattern2 = Pattern.compile("\\s*.*");
    private final String line1 = "line1";
    private final String line2 = "line2";

    public TextTraceContextTest() {
        this.fContext1.firstLine = "line1";
        this.fContext1.firstLineMatcher = this.pattern1.matcher("line1");
        this.fContext1.nextLineLocation = this.aLong2;
        this.fContext2.firstLine = "line2";
        this.fContext2.firstLineMatcher = this.pattern2.matcher("line2");
        this.fContext2.nextLineLocation = this.aLong3;
    }

    @Test
    public void testTmfContextDefault() {
        TextTraceContext context = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation1, (Object)context.getLocation());
        Assert.assertEquals((String)"getRank", (long)1L, (long)context.getRank());
        Assert.assertNull((Object)context.firstLine);
        Assert.assertNull((Object)context.firstLineMatcher);
        Assert.assertEquals((long)0L, (long)context.nextLineLocation);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fContext1.equals((Object)this.fContext1));
        Assert.assertTrue((String)"equals", (boolean)this.fContext2.equals((Object)this.fContext2));
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)this.fContext2));
        Assert.assertFalse((String)"equals", (boolean)this.fContext2.equals((Object)this.fContext1));
    }

    @Test
    public void testEqualsSymmetry() {
        TextTraceContext context1 = new TextTraceContext(this.fContext1);
        TextTraceContext context2 = new TextTraceContext(this.fContext2);
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)this.fContext1));
        Assert.assertTrue((String)"equals", (boolean)this.fContext1.equals((Object)context1));
        Assert.assertTrue((String)"equals", (boolean)context2.equals((Object)this.fContext2));
        Assert.assertTrue((String)"equals", (boolean)this.fContext2.equals((Object)context2));
    }

    @Test
    public void testEqualsTransivity() {
        TextTraceContext context1 = new TextTraceContext(this.fContext1);
        TextTraceContext context2 = new TextTraceContext(this.fContext1);
        TextTraceContext context3 = new TextTraceContext(this.fContext1);
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)context2));
        Assert.assertTrue((String)"equals", (boolean)context2.equals((Object)context3));
        Assert.assertTrue((String)"equals", (boolean)context1.equals((Object)context3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)this.fContext2.equals(null));
    }

    @Test
    public void testNonEquals() {
        MyContext myContext = new MyContext((ITmfLocation)this.fLocation1, 1L);
        Assert.assertFalse((String)"equals", (boolean)this.fContext1.equals((Object)myContext));
        Assert.assertFalse((String)"equals", (boolean)myContext.equals(this.fContext1));
        TextTraceContext context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        TextTraceContext context2 = new TextTraceContext((ITmfLocation)this.fLocation2, 1L);
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
        context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context2 = new TextTraceContext((ITmfLocation)this.fLocation1, 2L);
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
        context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context1.firstLine = "line1";
        context2 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context2.firstLine = "line2";
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
        context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context1.firstLine = "line1";
        context1.firstLineMatcher = this.fContext1.firstLineMatcher;
        context2 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context2.firstLine = "line1";
        context2.firstLineMatcher = this.fContext2.firstLineMatcher;
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
        context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context1.firstLine = "line1";
        context1.firstLineMatcher = this.fContext1.firstLineMatcher;
        context1.nextLineLocation = this.aLong2;
        context2 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context2.firstLine = "line1";
        context2.firstLineMatcher = this.fContext1.firstLineMatcher;
        context2.nextLineLocation = this.aLong3;
        Assert.assertFalse((String)"equals", (boolean)context1.equals((Object)context2));
    }

    @Test
    public void testHashCode() {
        TextTraceContext context1 = new TextTraceContext(this.fContext1);
        TextTraceContext context2 = new TextTraceContext(this.fContext2);
        Assert.assertEquals((String)"hashCode", (long)this.fContext1.hashCode(), (long)context1.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.fContext2.hashCode(), (long)context2.hashCode());
        Assert.assertFalse((String)"hashCode", (this.fContext1.hashCode() == context2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"hashCode", (this.fContext2.hashCode() == context1.hashCode() ? 1 : 0) != 0);
        TmfContext nullContext1 = new TmfContext();
        TmfContext nullContext2 = new TmfContext(nullContext1);
        Assert.assertEquals((String)"hashCode", (long)nullContext1.hashCode(), (long)nullContext2.hashCode());
    }

    @Test
    public void testSetLocation() {
        TextTraceContext context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context1.setLocation((ITmfLocation)this.fLocation2);
        Assert.assertEquals((String)"getLocation", (Object)this.fLocation2, (Object)context1.getLocation());
        Assert.assertEquals((String)"getRank", (long)1L, (long)context1.getRank());
    }

    @Test
    public void testSetRank() {
        TextTraceContext context1 = new TextTraceContext(this.fContext1);
        context1.setRank(this.fContext2.getRank());
        Assert.assertEquals((String)"getLocation", (Object)this.fContext1.getLocation(), (Object)context1.getLocation());
        Assert.assertEquals((String)"getRank", (long)this.fContext2.getRank(), (long)context1.getRank());
    }

    @Test
    public void testIncreaseRank() {
        TextTraceContext context1 = new TextTraceContext((ITmfLocation)this.fLocation1, 1L);
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)2L, (long)context1.getRank());
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)3L, (long)context1.getRank());
        context1.setRank(-1L);
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context1.getRank());
        context1.increaseRank();
        Assert.assertEquals((String)"getRank", (long)-1L, (long)context1.getRank());
    }

    private static class MyContext
    extends TextTraceContext {
        public MyContext(ITmfLocation location, long rank) {
            super(location, rank);
        }
    }
}

