/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public class StateSystemStringInterner {
    private final Map<Integer, BiMap<String, Long>> fStringPools = new WeakHashMap<Integer, BiMap<String, Long>>();

    public long intern(ITmfStateSystemBuilder ss, String string, int quark) throws IndexOutOfBoundsException, TimeRangeException {
        Map stringPool = (Map)this.fStringPools.computeIfAbsent(quark, unused -> HashBiMap.create());
        Long index = (Long)stringPool.get(string);
        if (index == null) {
            long internValue = (long)stringPool.size() + ss.getStartTime();
            stringPool.put(string, internValue);
            ss.modifyAttribute(internValue, (Object)string, quark);
            return internValue;
        }
        return index;
    }

    public @Nullable String resolve(ITmfStateSystem ss, long value, int quark) throws StateSystemDisposedException {
        if (quark != -2) {
            BiMap stringPool = this.fStringPools.computeIfAbsent(quark, unused -> HashBiMap.create()).inverse();
            String string = (String)stringPool.get(value);
            if (string != null) {
                return string;
            }
            Object resolved = ss.querySingleState(value, quark).getValue();
            if (resolved instanceof String) {
                return (String)resolved;
            }
        }
        return null;
    }
}

