/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.CustomParserUtils;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomXmlParserInputWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomXmlParserOutputWizardPage;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CustomXmlParserWizard
extends Wizard
implements INewWizard {
    CustomXmlParserInputWizardPage inputPage;
    CustomXmlParserOutputWizardPage outputPage;
    private ISelection selection;
    CustomXmlTraceDefinition definition;
    String initialCategoryName;
    String initialDefinitionName;

    public CustomXmlParserWizard() {
        this(null);
    }

    public CustomXmlParserWizard(CustomXmlTraceDefinition definition) {
        this.definition = definition;
        if (definition != null) {
            this.initialCategoryName = definition.categoryName;
            this.initialDefinitionName = definition.definitionName;
        }
        this.setWindowTitle(Messages.CustomXmlParserInputWizardPage_windowTitle);
    }

    public boolean performFinish() {
        CustomXmlTraceDefinition def = this.outputPage.getDefinition();
        if (this.definition != null) {
            if (!this.initialCategoryName.equals(def.categoryName) || !this.initialDefinitionName.equals(def.definitionName)) {
                CustomXmlTraceDefinition.delete((String)this.initialCategoryName, (String)this.initialDefinitionName);
            }
            CustomParserUtils.cleanup(CustomXmlTrace.buildTraceTypeId((String)this.initialCategoryName, (String)this.initialDefinitionName));
        }
        def.save();
        CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName));
        return true;
    }

    public void addPages() {
        this.inputPage = new CustomXmlParserInputWizardPage(this.selection, this.definition);
        this.addPage((IWizardPage)this.inputPage);
        this.outputPage = new CustomXmlParserOutputWizardPage(this);
        this.addPage((IWizardPage)this.outputPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }
}

