/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.DoubleStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.LongStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class IntegerStateValue
extends TmfStateValue {
    private final int fValue;

    public IntegerStateValue(int valueAsInt) {
        this.fValue = valueAsInt;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.INTEGER;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof IntegerStateValue)) {
            return false;
        }
        IntegerStateValue other = (IntegerStateValue)object;
        return this.fValue == other.fValue;
    }

    public int hashCode() {
        return this.fValue;
    }

    public @Nullable String toString() {
        return String.format("%3d", this.fValue);
    }

    @Override
    public int unboxInt() {
        return this.fValue;
    }

    @Override
    public long unboxLong() {
        return this.fValue;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        switch (other.getType()) {
            case INTEGER: {
                IntegerStateValue otherIntValue = (IntegerStateValue)other;
                return Integer.compare(this.fValue, otherIntValue.fValue);
            }
            case DOUBLE: {
                double otherDoubleValue = ((DoubleStateValue)other).unboxDouble();
                return Double.compare(this.fValue, otherDoubleValue);
            }
            case LONG: {
                long otherLongValue = ((LongStateValue)other).unboxLong();
                return Long.compare(this.fValue, otherLongValue);
            }
            case NULL: {
                return Integer.compare(this.fValue, other.unboxInt());
            }
            case STRING: {
                throw new StateValueTypeException("An Integer state value cannot be compared to a String state value.");
            }
        }
        throw new StateValueTypeException("An Integer state value cannot be compared to the type " + (Object)((Object)other.getType()));
    }

    @Override
    public @Nullable Object unboxValue() {
        return this.fValue;
    }
}

