/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.Iterator;
import java.util.stream.IntStream;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.IndexedSeriesModel;
import org.eclipse.swtchart.model.Messages;

public class DoubleArraySeriesModel
implements IndexedSeriesModel<Integer>,
CartesianSeriesModel<Integer> {
    private final double[] xdata;
    private final double[] ydata;
    private final double minX;
    private final double maxX;
    private boolean isXMonotoneIncreasing;
    private final double minY;
    private final double maxY;

    public DoubleArraySeriesModel(double[] xSeries, double[] ySeries) {
        int i;
        if (xSeries.length != ySeries.length) {
            throw new IllegalArgumentException(Messages.getString("X_Y_LENGTH_DOESNT_MATCH"));
        }
        this.xdata = xSeries;
        this.ydata = ySeries;
        if (xSeries.length > 0) {
            double minX = xSeries[0];
            double maxX = xSeries[0];
            i = 1;
            while (i < xSeries.length) {
                if (minX > xSeries[i]) {
                    minX = xSeries[i];
                }
                if (maxX < xSeries[i]) {
                    maxX = xSeries[i];
                }
                if (xSeries[i - 1] > xSeries[i]) {
                    this.isXMonotoneIncreasing = false;
                }
                ++i;
            }
            this.minX = minX;
            this.maxX = maxX;
        } else {
            this.minX = 0.0;
            this.maxX = 0.0;
        }
        if (ySeries.length > 0) {
            double minY = ySeries[0];
            double maxY = ySeries[0];
            i = 1;
            while (i < ySeries.length) {
                if (minY > ySeries[i]) {
                    minY = ySeries[i];
                }
                if (maxY < ySeries[i]) {
                    maxY = ySeries[i];
                }
                ++i;
            }
            this.minY = minY;
            this.maxY = maxY;
        } else {
            this.minY = 0.0;
            this.maxY = 0.0;
        }
    }

    public boolean isXMonotoneIncreasing() {
        return this.isXMonotoneIncreasing;
    }

    @Override
    public Iterator<Integer> iterator() {
        return IntStream.range(0, this.xdata.length).iterator();
    }

    @Override
    public int size() {
        return this.xdata.length;
    }

    @Override
    public Integer itemAt(int index) throws IndexOutOfBoundsException {
        return index;
    }

    @Override
    public Number getX(Integer data) {
        int value = data;
        if (value >= 0 && value < this.xdata.length) {
            return this.xdata[value];
        }
        return null;
    }

    @Override
    public Number getY(Integer data) {
        int value = data;
        if (value >= 0 && value < this.ydata.length) {
            return this.ydata[data];
        }
        return null;
    }

    @Override
    public Number getMaxX() {
        return this.maxX;
    }

    @Override
    public Number getMinX() {
        return this.minX;
    }

    @Override
    public Number getMaxY() {
        return this.maxY;
    }

    @Override
    public Number getMinY() {
        return this.minY;
    }
}

