/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.common.core.search.SearchEngine;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.SearchMessages;
import org.eclipse.wst.common.ui.internal.search.SearchQueryResultCollector;
import org.eclipse.wst.common.ui.internal.search.SearchResult;
import org.eclipse.wst.common.ui.internal.search.basecode.Messages;

public abstract class AbstractSearchQuery
implements ISearchQuery {
    protected String fPattern;
    protected SearchScope fScope;
    protected SearchResult fResult;
    protected String fScopeDescription;

    public AbstractSearchQuery(String pattern, SearchScope scope, String scopeDescription) {
        this.fPattern = pattern;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new SearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            if (this.fPattern.length() > 0) {
                Object[] args = new Object[]{this.fPattern, this.fScopeDescription};
                return Messages.format(SearchMessages.FileSearchQuery_singularLabel, args);
            }
            Object[] args = new Object[]{"", this.fScopeDescription};
            return Messages.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        if (this.fPattern.length() > 0) {
            Object[] args = new Object[]{this.fPattern, new Integer(nMatches), this.fScopeDescription};
            return Messages.format(SearchMessages.FileSearchQuery_pluralPattern, args);
        }
        Object[] args = new Object[]{"", new Integer(nMatches), this.fScopeDescription};
        return Messages.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus run(IProgressMonitor pm) throws OperationCanceledException {
        SearchResult textResult = (SearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchQueryResultCollector collector = new SearchQueryResultCollector(textResult);
        String searchString = this.fPattern;
        if (searchString.trim().equals(String.valueOf('*'))) {
            searchString = new String();
        }
        String message = SearchMessages.TextSearchEngine_statusMessage;
        MultiStatus status = new MultiStatus("org.eclipse.search", 0, message, null);
        SearchEngine searchEngine = new SearchEngine();
        QualifiedName typeName = QualifiedName.valueOf((String)searchString);
        try {
            SearchPattern pattern = this.createSearchPattern(typeName);
            searchEngine.search(pattern, (SearchRequestor)collector, this.fScope, null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        return status;
    }

    protected abstract SearchPattern createSearchPattern(QualifiedName var1);

    public class SearchResultUpdater
    implements IResourceChangeListener,
    IQueryListener {
        SearchResult fResult;

        public SearchResultUpdater(SearchResult result) {
            this.fResult = result;
            NewSearchUI.addQueryListener((IQueryListener)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                this.handleDelta(delta);
            }
        }

        protected void handleDelta(IResourceDelta d) {
            try {
                d.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        switch (delta.getKind()) {
                            case 1: {
                                return false;
                            }
                            case 2: {
                                IResource res = delta.getResource();
                                if (!(res instanceof IFile)) break;
                                Match[] matches = SearchResultUpdater.this.fResult.getMatches(res);
                                SearchResultUpdater.this.fResult.removeMatches(matches);
                                break;
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void queryAdded(ISearchQuery query) {
        }

        public void queryRemoved(ISearchQuery query) {
            if (((Object)((Object)this.fResult)).equals(query.getSearchResult())) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                NewSearchUI.removeQueryListener((IQueryListener)this);
            }
        }

        public void queryStarting(ISearchQuery query) {
        }

        public void queryFinished(ISearchQuery query) {
        }
    }
}

