/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CreateFolder
extends ProcessRunner {
    @Override
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        CreateFolder.createFolder(args[0].getSimpleValue(), args[1].getSimpleValue(), monitor);
    }

    public static void createFolder(String projectName, String targetPath, IProgressMonitor monitor) throws ProcessFailureException {
        if (targetPath == null || targetPath.length() == 0) {
            return;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("CreateSourceFolder.0")) + projectName);
        }
        Path path = new Path(targetPath);
        try {
            int i = 1;
            while (i <= path.segmentCount()) {
                IFolder subfolder = projectHandle.getFolder(path.uptoSegment(i));
                if (!subfolder.exists()) {
                    subfolder.create(true, true, monitor);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("CreateSourceFolder.1")) + e.getMessage(), e);
        }
    }
}

