/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph;

import com.google.common.collect.ImmutableMap;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.analysis.profiling.core.base.FlameDefaultPalette;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlameGraphView;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.ITimeGraphStylePresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;

public class FlameGraphPresentationProvider
extends TimeGraphPresentationProvider
implements ITimeGraphStylePresentationProvider {
    private static final OutputElementStyle TRANSPARENT_STYLE = new OutputElementStyle(null, (Map)ImmutableMap.of());
    private static final Format FORMATTER = SubSecondTimeWithUnitFormat.getInstance();
    private StyleManager fStyleManager = new StyleManager(FlameDefaultPalette.getStyles());
    private Map<String, Integer> fKeyToIndex = new HashMap<String, Integer>();
    public static final int NUM_COLORS = FlameDefaultPalette.getStyles().size() + 1;
    private final StateItem[] fStateTable = new StateItem[NUM_COLORS];
    private FlameGraphView fView;

    public FlameGraphPresentationProvider() {
        this.fStateTable[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        this.getStateTable();
    }

    public @NonNull StyleManager getStyleManager() {
        return this.fStyleManager;
    }

    public @Nullable Object getStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getStyle(elementStyle, property);
    }

    public @Nullable Float getFloatStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getFactorStyle(elementStyle, property);
    }

    public @Nullable RGBAColor getColorStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getColorStyle(elementStyle, property);
    }

    public @Nullable OutputElementStyle getElementStyle(ITimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return null;
        }
        if (event instanceof FlamegraphEvent) {
            ITimeElement model = ((FlamegraphEvent)event).getModel();
            OutputElementStyle eventStyle = model.getStyle();
            if (eventStyle == null) {
                String name = event.getLabel();
                String key = name == null ? Integer.valueOf(model.getValue()) : name;
                eventStyle = FlameDefaultPalette.getStyleFor((Object)key);
            }
            return eventStyle;
        }
        return TRANSPARENT_STYLE;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public StateItem[] getStateTable() {
        if (this.fStateTable[1] == null) {
            @NonNull @NonNull Map styles = FlameDefaultPalette.getStyles();
            if (styles.isEmpty()) {
                int i = 0;
                while (i < NUM_COLORS) {
                    this.fStateTable[i + 1] = new StateItem(Collections.emptyMap());
                    ++i;
                }
                return this.fStateTable;
            }
            int tableIndex = 1;
            for (Map.Entry styleEntry : styles.entrySet()) {
                Object styleGroup;
                Object symbolType;
                Float width;
                Object styleName;
                RGBAColor color;
                String styleKey = (String)styleEntry.getKey();
                this.fKeyToIndex.put(styleKey, tableIndex);
                OutputElementStyle elementStyle = (OutputElementStyle)styleEntry.getValue();
                HashMap<String, Object> styleMap = new HashMap<String, Object>();
                RGBAColor bgColor = this.getColorStyle(elementStyle, "background-color");
                if (bgColor != null) {
                    RGB rgb = new RGB((int)bgColor.getRed(), (int)bgColor.getGreen(), (int)bgColor.getBlue());
                    styleMap.put("background-color", ColorUtils.toHexColor((RGB)rgb));
                }
                if ((color = this.getColorStyle(elementStyle, "color")) != null) {
                    RGB rgb = new RGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
                    styleMap.put("color", ColorUtils.toHexColor((RGB)rgb));
                }
                if ((styleName = this.getStyle(elementStyle, "style-name")) instanceof String) {
                    styleMap.put("style-name", styleName);
                } else {
                    styleMap.put("style-name", styleEntry.getKey());
                }
                Float height = this.getFloatStyle(elementStyle, "height");
                if (height != null) {
                    styleMap.put("height", height);
                }
                if ((width = this.getFloatStyle(elementStyle, "width")) != null) {
                    styleMap.put("width", width.intValue());
                }
                if ((symbolType = this.getStyle(elementStyle, "symbol-type")) instanceof String) {
                    styleMap.put("symbol-type", symbolType);
                }
                if ((styleGroup = this.getStyle(elementStyle, "style-group")) != null) {
                    styleMap.put("style-group", styleGroup);
                }
                this.fStateTable[tableIndex] = new StateItem(styleMap);
                ++tableIndex;
            }
        }
        return this.fStateTable;
    }

    public boolean displayTimesInTooltip() {
        return false;
    }

    public String getStateTypeName() {
        return Messages.FlameGraph_Depth;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        FlamegraphEvent fgEvent = (FlamegraphEvent)event;
        AggregatedCalledFunctionStatistics statistics = fgEvent.getStatistics();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Messages.FlameGraph_Symbol, (Object)fgEvent.getLabel());
        builder.put((Object)Messages.FlameGraph_NbCalls, (Object)NumberFormat.getIntegerInstance().format(statistics.getDurationStatistics().getNbElements()));
        builder.put((Object)String.valueOf(Messages.FlameGraph_Durations), (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_Duration), (Object)FORMATTER.format(event.getDuration()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMaxNumber()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMinNumber()));
        builder.put((Object)("\t" + Messages.FlameGraph_Deviation), (Object)FORMATTER.format(statistics.getDurationStatistics().getStdDev()));
        builder.put((Object)Messages.FlameGraph_SelfTimes, (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTime), (Object)FORMATTER.format(fgEvent.getSelfTime()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMax()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMin()));
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTimeDeviation), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getStdDev()));
        return builder.build();
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof FlamegraphEvent) {
            FlamegraphEvent flameGraphEvent = (FlamegraphEvent)event;
            return Math.floorMod(String.valueOf(flameGraphEvent.getValue()).hashCode(), NUM_COLORS) + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    public FlameGraphView getView() {
        return this.fView;
    }

    public void setView(FlameGraphView view) {
        this.fView = view;
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

