/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.ui.internal.XMLFormattingStrategy;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLStructuredContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.style.LineStyleProviderForXML;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class StructuredTextViewerConfigurationXML
extends StructuredTextViewerConfiguration {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForXML;
    private ILabelProvider fStatusLineLabelProvider;

    protected IPreferenceStore[] createPreferenceStores() {
        IPreferenceStore[] defaults = super.createPreferenceStores();
        ArrayList<IPreferenceStore> preferenceStores = new ArrayList<IPreferenceStore>();
        preferenceStores.add(XMLUIPlugin.getDefault().getPreferenceStore());
        int i = 0;
        while (i < defaults.length) {
            preferenceStores.add(defaults[i]);
            ++i;
        }
        return preferenceStores.toArray(new IPreferenceStore[preferenceStores.size()]);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        allStrategies.add(new AutoEditStrategyForTabs());
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] xmlTypes = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[xmlTypes.length + 2];
            this.fConfiguredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.fConfiguredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(xmlTypes, 0, this.fConfiguredContentTypes, index += 2, xmlTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = super.getContentAssistant(sourceViewer);
        if (assistant instanceof ContentAssistant) {
            ((ContentAssistant)assistant).enableAutoInsert(XMLUIPlugin.getInstance().getPreferenceStore().getBoolean("insertSingleSuggestion"));
        }
        return assistant;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        XMLStructuredContentAssistProcessor processor = new XMLStructuredContentAssistProcessor((ContentAssistant)this.getContentAssistant(), partitionType, (ITextViewer)sourceViewer);
        return new IContentAssistProcessor[]{processor};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (!(formatter instanceof MultiPassContentFormatter)) {
            formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.xml.XML_DEFAULT");
        }
        ((MultiPassContentFormatter)formatter).setMasterStrategy((IFormattingStrategy)new XMLFormattingStrategy());
        return formatter;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        ArrayList<String> prefixes = new ArrayList<String>();
        Preferences preferences = XMLCorePlugin.getDefault().getPluginPreferences();
        int indentationWidth = preferences.getInt("indentationSize");
        String indentCharPref = preferences.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                prefixes.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            prefixes.add(prefix.toString());
            ++i;
        }
        prefixes.add("");
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.wst.xml.XML_COMMENT" || partitionType == "org.eclipse.wst.xml.XML_DECL" || partitionType == "org.eclipse.wst.xml.XML_PI" || partitionType == "org.eclipse.wst.xml.PROCESSING_INSTRUCTION:") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForXML()};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForXML() {
        if (this.fLineStyleProviderForXML == null) {
            this.fLineStyleProviderForXML = new LineStyleProviderForXML();
        }
        return this.fLineStyleProviderForXML;
    }

    public ILabelProvider getStatusLineLabelProvider(ISourceViewer sourceViewer) {
        if (this.fStatusLineLabelProvider == null) {
            this.fStatusLineLabelProvider = new JFaceNodeLabelProvider(){

                @Override
                public String getText(Object element) {
                    if (element == null) {
                        return null;
                    }
                    StringBuffer s = new StringBuffer();
                    Node node = (Node)element;
                    while (node != null) {
                        if (node.getNodeType() != 9) {
                            s.insert(0, super.getText(node));
                        }
                        if ((node = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode()) == null || node.getNodeType() == 9) continue;
                        s.insert(0, '/');
                    }
                    return s.toString();
                }
            };
        }
        return this.fStatusLineLabelProvider;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put(ContentTypeIdForXML.ContentTypeID_XML, null);
        return targets;
    }
}

