/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;

public class CPPASTDesignatedInitializer
extends ASTNode
implements ICPPASTDesignatedInitializer,
IASTAmbiguityParent {
    private ICPPASTInitializerClause rhs;
    private ICPPASTDesignator[] designators = ICPPASTDesignator.EMPTY_ARRAY;
    private int designatorsPos;

    public CPPASTDesignatedInitializer() {
    }

    public CPPASTDesignatedInitializer(ICPPASTInitializerClause init) {
        this.setOperand(init);
    }

    @Override
    public CPPASTDesignatedInitializer copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDesignatedInitializer copy(IASTNode.CopyStyle style) {
        CPPASTDesignatedInitializer copy = new CPPASTDesignatedInitializer(this.rhs == null ? null : (ICPPASTInitializerClause)this.rhs.copy(style));
        ICPPASTDesignator[] iCPPASTDesignatorArray = this.getDesignators();
        int n = iCPPASTDesignatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTDesignator designator = iCPPASTDesignatorArray[n2];
            copy.addDesignator(designator == null ? null : designator.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public void addDesignator(ICPPASTDesignator designator) {
        this.assertNotFrozen();
        if (designator != null) {
            designator.setParent(this);
            designator.setPropertyInParent(DESIGNATOR);
            this.designators = ArrayUtil.appendAt(this.designators, this.designatorsPos++, designator);
        }
    }

    @Override
    public ICPPASTDesignator[] getDesignators() {
        this.designators = ArrayUtil.trim(this.designators, this.designatorsPos);
        return this.designators;
    }

    @Override
    public ICPPASTInitializerClause getOperand() {
        return this.rhs;
    }

    @Override
    public void setOperand(ICPPASTInitializerClause operand) {
        this.assertNotFrozen();
        this.rhs = operand;
        if (this.rhs != null) {
            this.rhs.setParent(this);
            this.rhs.setPropertyInParent(OPERAND);
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return this.rhs.getEvaluation();
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTDesignator[] ds = this.getDesignators();
        int i = 0;
        while (i < ds.length) {
            if (!ds[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.rhs != null && !this.rhs.accept(action)) {
            return false;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.rhs) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.rhs = (ICPPASTInitializerClause)other;
        }
    }
}

