/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayDefinition2Test {
    private @NonNull CTFTrace trace = new CTFTrace();
    private ArrayDefinition charArrayFixture;
    private ArrayDefinition stringArrayFixture;
    private ArrayDefinition longArrayFixture;

    @Before
    public void setUp() {
        this.charArrayFixture = this.createCharArray();
        this.stringArrayFixture = this.createStringArray();
        this.longArrayFixture = this.createLongArray();
    }

    private ArrayDefinition createLongArray() {
        IntegerDeclaration decl = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"none", (long)8L);
        List<@NonNull Definition> defs = ArrayDefinition2Test.createIntDefs(10, 32);
        ArrayDefinition temp = this.setUpDeclaration((IDeclaration)decl, defs);
        return temp;
    }

    private ArrayDefinition createCharArray() {
        IntegerDeclaration decl = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.UTF8, (String)"none", (long)8L);
        List<@NonNull Definition> defs = ArrayDefinition2Test.createIntDefs(4, 8);
        ArrayDefinition temp = this.setUpDeclaration((IDeclaration)decl, defs);
        return temp;
    }

    private ArrayDefinition createStringArray() {
        StringDeclaration strDecl = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        List<@NonNull Definition> defs = ArrayDefinition2Test.createDefs();
        ArrayDefinition temp = this.setUpDeclaration((IDeclaration)strDecl, defs);
        return temp;
    }

    private ArrayDefinition setUpDeclaration(@NonNull IDeclaration decl, @NonNull List<@NonNull Definition> defs) {
        ArrayDeclaration ad = new ArrayDeclaration(0, decl);
        ArrayDefinition temp = new ArrayDefinition((CompoundDeclaration)ad, (IDefinitionScope)this.trace, "Testx", defs);
        return temp;
    }

    private static @NonNull List<@NonNull Definition> createIntDefs(int size, int bits) {
        ArrayList<@NonNull Definition> defs = new ArrayList<Definition>(size);
        int i = 0;
        while (i < size) {
            String content = "test" + i;
            defs.add((Definition)new IntegerDefinition(IntegerDeclaration.createDeclaration((int)bits, (boolean)false, (int)16, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.UTF8, (String)content, (long)24L), null, content, (long)i));
            ++i;
        }
        return defs;
    }

    private static @NonNull List<@NonNull Definition> createDefs() {
        int size = 4;
        ArrayList<@NonNull Definition> defs = new ArrayList<Definition>();
        int i = 0;
        while (i < size) {
            String content = "test" + i;
            defs.add((Definition)new StringDefinition(StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8), null, content, content));
            ++i;
        }
        return defs;
    }

    @Test
    public void testArrayDefinition_baseDeclaration() {
        CompoundDeclaration declaration = (CompoundDeclaration)this.charArrayFixture.getDeclaration();
        String fieldName = "";
        ArrayDefinition result = new ArrayDefinition(declaration, (IDefinitionScope)this.trace, fieldName, Arrays.asList(new Definition[0]));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testArrayDefinition_newDeclaration() {
        ArrayDeclaration declaration = new ArrayDeclaration(0, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        IDefinitionScope definitionScope = ArrayDefinition2Test.getDefinitionScope();
        String fieldName = "";
        ArrayDefinition result = new ArrayDefinition((CompoundDeclaration)declaration, definitionScope, fieldName, Arrays.asList(new Definition[0]));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDeclaration() {
        CompoundDeclaration result = (CompoundDeclaration)this.charArrayFixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testgetElem_noDefs() {
        int i = 0;
        IDefinition result = (IDefinition)this.charArrayFixture.getDefinitions().get(i);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testgetElem_withDefs() {
        List<@NonNull Definition> defs = ArrayDefinition2Test.createDefs();
        IDefinitionScope definitionScope = ArrayDefinition2Test.getDefinitionScope();
        ArrayDefinition ad = new ArrayDefinition((CompoundDeclaration)this.charArrayFixture.getDeclaration(), definitionScope, "test", defs);
        int j = 1;
        IDefinition result = (IDefinition)ad.getDefinitions().get(j);
        Assert.assertNotNull((Object)result);
    }

    private static @NonNull IDefinitionScope getDefinitionScope() {
        return new IDefinitionScope(){

            public Definition lookupDefinition(String lookupPath) {
                return null;
            }

            public LexicalScope getScopePath() {
                return null;
            }
        };
    }

    @Test
    public void testRead_noDefs() throws CTFException {
        BitBuffer input = new BitBuffer(Util.testMemory(ByteBuffer.allocateDirect(128)));
        this.charArrayFixture.getDeclaration().createDefinition(null, "test", input);
    }

    @Test
    public void testToString_char() {
        String result = this.charArrayFixture.toString();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString_long() {
        String result = this.longArrayFixture.toString();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString_string() {
        String result = this.stringArrayFixture.toString();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString_withDefs() {
        String result = this.charArrayFixture.toString();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToStringStringArray() {
        String result = this.stringArrayFixture.toString();
        Assert.assertNotNull((Object)result);
    }
}

