/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCanvas;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTimeGraphViewTestBase;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlFlowViewTest
extends KernelTimeGraphViewTestBase {
    private static final String DIALOG_OK = "OK";
    private static final String DIALOG_CANCEL = "Cancel";
    private static final String THREAD_PRESENTATION_HIERARCHICAL = "Hierarchical";
    private static final String THREAD_PRESENTATION_FLAT = "Flat";
    private static final String DYNAMIC_FILTER_ACTIVE_THREADS_ONLY_TOGGLE = "Active Threads only";
    private static final String DYNAMIC_FILTER_ON_CPU_FIELD_MESSAGE = "e.g. 0-3,5,7-8";
    private static final String DYNAMIC_FILTERS_ALL_ACTIVE_RADIO = "All Active Threads";
    private static final String DYNAMIC_FILTERS_ON_CPU_RADIO = "Active Threads on CPUs:";
    private static final String DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX = "Show Active Threads Only";
    private static final String DYNAMIC_FILTERS_SHELL_TEXT = "Dynamic Filters Configuration";
    private static final String DYNAMIC_FILTER_CONFIGURE_LABEL = "Configure...";
    private static final String CHECK_SELECTED = "Check selected";
    private static final String CHECK_ALL = "Check all";
    private static final String CHECK_SUBTREE = "Check subtree";
    private static final String CHECK_ACTIVE = "Check Active";
    private static final String UNCHECK_SELECTED = "Uncheck selected";
    private static final String UNCHECK_ALL = "Uncheck all";
    private static final String UNCHECK_SUBTREE = "Uncheck subtree";
    private static final String UNCHECK_INACTIVE = "Uncheck Inactive";
    private static final String FOLLOW_CPU_BACKWARD = "Follow CPU Backward";
    private static final String FOLLOW_CPU_FORWARD = "Follow CPU Forward";
    private static final String SELECT_PREVIOUS_STATE_CHANGE = "Select Previous State Change";
    private static final String SELECT_NEXT_STATE_CHANGE = "Select Next State Change";
    private static final @NonNull ITmfTimestamp START_TIME = TmfTimestamp.fromNanos((long)1368000272650993664L);
    private static final @NonNull ITmfTimestamp TID1_TIME1 = TmfTimestamp.fromNanos((long)1368000272651208498L);
    private static final @NonNull ITmfTimestamp TID1_TIME2 = TmfTimestamp.fromNanos((long)1368000272656149680L);
    private static final @NonNull ITmfTimestamp TID1_TIME3 = TmfTimestamp.fromNanos((long)1368000272656364514L);
    private static final @NonNull ITmfTimestamp TID1_TIME4 = TmfTimestamp.fromNanos((long)1368000272663239202L);
    private static final @NonNull ITmfTimestamp TID1_TIME5 = TmfTimestamp.fromNanos((long)1368000272663454036L);
    private static final @NonNull ITmfTimestamp TID1_TIME6 = TmfTimestamp.fromNanos((long)1368000272665602376L);
    private static final @NonNull ITmfTimestamp TID2_TIME1 = TmfTimestamp.fromNanos((long)1368000272651853000L);
    private static final @NonNull ITmfTimestamp TID2_TIME2 = TmfTimestamp.fromNanos((long)1368000272652067834L);
    private static final @NonNull ITmfTimestamp TID2_TIME3 = TmfTimestamp.fromNanos((long)1368000272652282668L);
    private static final @NonNull ITmfTimestamp TID2_TIME4 = TmfTimestamp.fromNanos((long)1368000272652497502L);
    private static final @NonNull ITmfTimestamp TID5_TIME1 = TmfTimestamp.fromNanos((long)1368000272652497502L);

    @Override
    protected SWTBotView getViewBot() {
        return fBot.viewByTitle("Control Flow");
    }

    @Override
    protected SWTBotView openView() {
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.controlflow");
        return this.getViewBot();
    }

    @Override
    protected List<String> getLegendValues() {
        return Arrays.asList("Unknown", "Usermode", "System call", "Interrupt", "Wait blocked", "Wait for CPU", "Wait");
    }

    @Override
    protected List<String> getToolbarTooltips() {
        return Arrays.asList("Optimize", "", "Hide Empty Rows", "Show View Filters", "Show Legend", "", "Reset the Time Scale to Default", SELECT_PREVIOUS_STATE_CHANGE, SELECT_NEXT_STATE_CHANGE, "", "Add Bookmark...", "Previous Marker", "Next Marker", "", "Select Previous Process", "Select Next Process", "Zoom In", "Zoom Out", "", "Hide Arrows", FOLLOW_CPU_BACKWARD, FOLLOW_CPU_FORWARD, "Go to previous event of the selected thread", "Go to next event of the selected thread", "", "Pin View");
    }

    @Override
    @Before
    public void before() {
        SWTBotView viewBot = this.getViewBot();
        viewBot.show();
        super.before();
        viewBot.setFocus();
    }

    @Test
    public void testKeyboardLeftRight() {
        SWTBotView viewBot = this.getViewBot();
        SWTBotCanvas canvas = viewBot.bot().canvas(1);
        this.testNextPreviousEvent(() -> {
            canvas.setFocus();
            canvas.pressShortcut(new KeyStroke[]{Keystrokes.RIGHT});
        }, () -> {
            canvas.setFocus();
            canvas.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.RIGHT});
        }, () -> {
            canvas.setFocus();
            canvas.pressShortcut(new KeyStroke[]{Keystrokes.LEFT});
        }, () -> {
            canvas.setFocus();
            canvas.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.LEFT});
        });
    }

    @Test
    public void testToolBarSelectNextPreviousStateChange() {
        SWTBotView viewBot = this.getViewBot();
        this.testNextPreviousEvent(() -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(SELECT_NEXT_STATE_CHANGE).click(131072);
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(SELECT_PREVIOUS_STATE_CHANGE).click();
        }, () -> {
            SWTBotToolbarButton sWTBotToolbarButton = viewBot.toolbarButton(SELECT_PREVIOUS_STATE_CHANGE).click(131072);
        });
    }

    private void testNextPreviousEvent(Runnable selectNext, Runnable shiftSelectNext, Runnable selectPrevious, Runnable shiftSelectPrevious) {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(this.getViewBot().bot());
        timeGraph.setFocus();
        timeGraph.getEntry(new String[]{LttngTraceGenerator.getName(), "gnuplot"}).select();
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME2, TID1_TIME2));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME3)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME3));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME4));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME5));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME6));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME6)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME6));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME5));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME4));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME2));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME3, TID1_TIME2)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME2));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        selectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME4)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME4));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME3));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME2));
        shiftSelectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME1)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME2));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME3));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        shiftSelectNext.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME5));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID1_TIME4, TID1_TIME5)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME5));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME4, TID1_TIME4));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME3, TID1_TIME3));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME2, TID1_TIME2));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        selectPrevious.run();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    @Test
    public void testFilter() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(1000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        SWTBotView viewBot = this.getViewBot();
        SWTBotToolbarButton filterButton = viewBot.toolbarButton("Show View Filters");
        filterButton.click();
        SWTBot bot = fBot.shell("Filter").activate().bot();
        SWTBotTree treeBot = bot.tree();
        int checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)"default", (long)226L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.button(CHECK_ACTIVE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_ACTIVE, (long)69L, (long)checked);
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_ALL, (long)226L, (long)checked);
        bot.button(UNCHECK_INACTIVE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)UNCHECK_INACTIVE, (long)69L, (long)checked);
        treeBot.getTreeItem(LttngTraceGenerator.getName()).select("gnuplot");
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_SELECTED, (long)2L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        bot.button(CHECK_SUBTREE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)CHECK_SUBTREE, (long)2L, (long)checked);
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SELECTED).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)225L, (long)checked);
        bot.button(CHECK_ALL).click();
        bot.button(UNCHECK_SUBTREE).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)UNCHECK_SELECTED, (long)225L, (long)checked);
        bot.button(UNCHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((long)0L, (long)checked);
        bot.text().setText("half-life 3");
        SWTBotTreeItem treeItem = treeBot.getTreeItem(LttngTraceGenerator.getName());
        treeItem.rowCount();
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)treeItem, (int)25));
        bot.button(CHECK_ALL).click();
        checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)"Filtered", (long)26L, (long)checked);
        bot.button(DIALOG_OK).click();
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotTimeGraphEntry traceEntry = timeGraph.getEntry(new String[]{LttngTraceGenerator.getName()});
        SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray = traceEntry.getEntries();
        int n = sWTBotTimeGraphEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTimeGraphEntry entry = sWTBotTimeGraphEntryArray[n2];
            Assert.assertEquals((String)"Filtered Control flow view", (Object)"Half-life 3", (Object)entry.getText());
            ++n2;
        }
    }

    @Test
    public void testDynamicFiltersDialog() {
        String valid_cpu_ranges = "0,1,2-100";
        String invalid_cpu_ranges = "-1,1";
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, range.getStartTime(), range.getEndTime()));
        this.timeGraphIsReadyCondition(range);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        SWTBotShell shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        SWTBotCheckBox activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        SWTBotRadio onCpuRadio = shell.bot().radio(DYNAMIC_FILTERS_ON_CPU_RADIO);
        SWTBotRadio allActiveRadio = shell.bot().radio(DYNAMIC_FILTERS_ALL_ACTIVE_RADIO);
        SWTBotText onCpuField = shell.bot().textWithMessage(DYNAMIC_FILTER_ON_CPU_FIELD_MESSAGE);
        Assert.assertFalse((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertFalse((boolean)onCpuRadio.isEnabled());
        Assert.assertFalse((boolean)allActiveRadio.isEnabled());
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        activeThreadsCheckbox.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        Assert.assertTrue((boolean)allActiveRadio.isSelected());
        onCpuRadio.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuField.isEnabled());
        Assert.assertFalse((boolean)allActiveRadio.isSelected());
        Assert.assertTrue((boolean)onCpuRadio.isSelected());
        allActiveRadio.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        Assert.assertTrue((boolean)allActiveRadio.isSelected());
        Assert.assertFalse((boolean)onCpuRadio.isSelected());
        onCpuRadio.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuField.isEnabled());
        Assert.assertFalse((boolean)allActiveRadio.isSelected());
        Assert.assertTrue((boolean)onCpuRadio.isSelected());
        onCpuField.setText(invalid_cpu_ranges);
        Assert.assertFalse((boolean)shell.bot().button(DIALOG_OK).isEnabled());
        onCpuField.setText(valid_cpu_ranges);
        Assert.assertTrue((boolean)shell.bot().button(DIALOG_OK).isEnabled());
        shell.bot().button(DIALOG_OK).click();
        this.timeGraphIsReadyCondition(range);
        Assert.assertTrue((boolean)this.getViewBot().viewMenu(DYNAMIC_FILTER_ACTIVE_THREADS_ONLY_TOGGLE).isChecked());
        Assert.assertTrue((boolean)this.getViewBot().viewMenu(THREAD_PRESENTATION_FLAT).isChecked());
        Assert.assertFalse((boolean)this.getViewBot().viewMenu(THREAD_PRESENTATION_HIERARCHICAL).isChecked());
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        onCpuRadio = shell.bot().radio(DYNAMIC_FILTERS_ON_CPU_RADIO);
        allActiveRadio = shell.bot().radio(DYNAMIC_FILTERS_ALL_ACTIVE_RADIO);
        onCpuField = shell.bot().textWithMessage(DYNAMIC_FILTER_ON_CPU_FIELD_MESSAGE);
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuField.isEnabled());
        Assert.assertFalse((boolean)allActiveRadio.isSelected());
        Assert.assertTrue((boolean)onCpuRadio.isSelected());
        Assert.assertTrue((boolean)onCpuField.isEnabled());
        Assert.assertEquals((String)"CPU ranges not equal", (Object)onCpuField.getText(), (Object)valid_cpu_ranges);
        allActiveRadio.click();
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        Assert.assertEquals((String)"Cpu ranges not equal", (Object)onCpuField.getText(), (Object)valid_cpu_ranges);
        shell.bot().button(DIALOG_OK).click();
        this.timeGraphIsReadyCondition(range);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        onCpuRadio = shell.bot().radio(DYNAMIC_FILTERS_ON_CPU_RADIO);
        allActiveRadio = shell.bot().radio(DYNAMIC_FILTERS_ALL_ACTIVE_RADIO);
        onCpuField = shell.bot().textWithMessage(DYNAMIC_FILTER_ON_CPU_FIELD_MESSAGE);
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        Assert.assertTrue((boolean)allActiveRadio.isEnabled());
        Assert.assertTrue((boolean)onCpuRadio.isEnabled());
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        Assert.assertTrue((boolean)allActiveRadio.isSelected());
        Assert.assertFalse((boolean)onCpuRadio.isSelected());
        Assert.assertFalse((boolean)onCpuField.isEnabled());
        Assert.assertEquals((String)"CPU ranges not equal", (Object)onCpuField.getText(), (Object)valid_cpu_ranges);
        shell.bot().button(DIALOG_CANCEL).click();
    }

    @Test
    public void testDynamicFiltering() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, range.getStartTime(), range.getEndTime()));
        this.timeGraphIsReadyCondition(range);
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotTimeGraphEntry traceEntry = timeGraph.getEntry(new String[]{LttngTraceGenerator.getName()});
        SWTBotUtils.waitUntil(entry -> entry.getEntries().length == 225, (Object)traceEntry, () -> "Entries size expected:225 actual:" + traceEntry.getEntries().length);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        SWTBotShell shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        SWTBotCheckBox activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        Assert.assertFalse((boolean)activeThreadsCheckbox.isChecked());
        activeThreadsCheckbox.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        shell.bot().button(DIALOG_OK).click();
        this.timeGraphIsReadyCondition(range);
        range = new TmfTimeRange(START_TIME, START_TIME.normalize(50000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, range.getStartTime(), range.getEndTime()));
        this.timeGraphIsReadyCondition(range);
        SWTBotUtils.waitUntil(entry -> entry.getEntries().length == 7, (Object)traceEntry, () -> "Entries size expected:7 actual:" + traceEntry.getEntries().length);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        activeThreadsCheckbox.click();
        Assert.assertFalse((boolean)activeThreadsCheckbox.isChecked());
    }

    @Test
    public void testDynamicFilteringCpu() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, range.getStartTime(), range.getEndTime()));
        this.timeGraphIsReadyCondition(range);
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotTimeGraphEntry traceEntry = timeGraph.getEntry(new String[]{LttngTraceGenerator.getName()});
        SWTBotUtils.waitUntil(entry -> entry.getEntries().length == 225, (Object)traceEntry, () -> "Entries size expected:225 actual:" + traceEntry.getEntries().length);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        SWTBotShell shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        SWTBotCheckBox activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        Assert.assertFalse((boolean)activeThreadsCheckbox.isChecked());
        SWTBotRadio onCpuRadio = shell.bot().radio(DYNAMIC_FILTERS_ON_CPU_RADIO);
        SWTBotText onCpuField = shell.bot().textWithMessage(DYNAMIC_FILTER_ON_CPU_FIELD_MESSAGE);
        activeThreadsCheckbox.click();
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        onCpuRadio.click();
        onCpuField.setText("0");
        shell.bot().button(DIALOG_OK).click();
        this.timeGraphIsReadyCondition(range);
        range = new TmfTimeRange(START_TIME, START_TIME.normalize(50000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, range.getStartTime(), range.getEndTime()));
        this.timeGraphIsReadyCondition(range);
        SWTBotUtils.waitUntil(entry -> entry.getEntries().length == 1, (Object)traceEntry, () -> "Entries size expected:1 actual:" + traceEntry.getEntries().length);
        this.getViewBot().viewMenu(DYNAMIC_FILTER_CONFIGURE_LABEL).click();
        shell = fBot.shell(DYNAMIC_FILTERS_SHELL_TEXT).activate();
        activeThreadsCheckbox = shell.bot().checkBox(DYNAMIC_FILTERS_SHOW_ACTIVE_THREADS_ONLY_CHECKBOX);
        Assert.assertTrue((boolean)activeThreadsCheckbox.isChecked());
        activeThreadsCheckbox.click();
        Assert.assertFalse((boolean)activeThreadsCheckbox.isChecked());
    }

    @Test
    public void testToolBarFollowCPUForwardBackward() {
        TmfTimeRange range = new TmfTimeRange(START_TIME, START_TIME.normalize(10000000L, -9));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)range));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, START_TIME));
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        SWTBotView viewBot = this.getViewBot();
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(viewBot.bot());
        timeGraph.setFocus();
        timeGraph.getEntry(new String[]{LttngTraceGenerator.getName(), "gnuplot"}).select();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME1, TID2_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME2)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME3));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID5_TIME1)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"5"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID5_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME4));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME3));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME2, TID2_TIME1)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME3)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME3));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID1_TIME1));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID1_TIME1)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"1"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID1_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        viewBot.toolbarButton(FOLLOW_CPU_FORWARD).click(131072);
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME4));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(TID2_TIME3, TID2_TIME4)));
        fBot.waitUntil(ConditionHelpers.timeGraphSelectionContains((SWTBotTimeGraph)timeGraph, (int)1, (String)"2"));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(TID2_TIME4));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME3, TID2_TIME3));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME2, TID2_TIME2));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID2_TIME1, TID2_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(TID1_TIME1, TID1_TIME1));
        viewBot.toolbarButton(FOLLOW_CPU_BACKWARD).click();
        this.timeGraphIsReadyCondition(new TmfTimeRange(START_TIME, START_TIME));
        fBot.waitUntil(ConditionHelpers.selectionRange((TmfTimeRange)new TmfTimeRange(START_TIME, START_TIME)));
        Assert.assertTrue((boolean)TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange().contains(START_TIME));
    }

    private void timeGraphIsReadyCondition(@NonNull TmfTimeRange selectionRange) {
        IWorkbenchPart part = this.getViewBot().getViewReference().getPart(false);
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)part), (TmfTimeRange)selectionRange, (ITmfTimestamp)selectionRange.getEndTime()));
    }
}

