/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        Rectangle rect;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int layoutWidth = this.layout.getWidth();
        if (wHint == 0) {
            this.layout.setWidth(1);
            rect = DPIUtil.autoScaleUp(this.layout.getBounds());
            width = 0;
            height = rect.height;
        } else {
            this.layout.setWidth(DPIUtil.autoScaleDown(wHint));
            rect = DPIUtil.autoScaleUp(this.layout.getBounds());
            width = rect.width;
            height = rect.height;
        }
        this.layout.setWidth(layoutWidth);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_widget_set_focusable(this.handle, true);
        } else {
            GTK3.gtk_widget_set_has_window(this.handle, true);
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
        this.layout = new TextLayout(this.display);
        this.disabledColor = new Color(LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.layout.setFont(this.getFont());
        this.text = "";
        this.initAccessible();
    }

    @Override
    void drawWidget(GC gc) {
        int selStart = this.selection.x;
        int selEnd = this.selection.y;
        if (selStart > selEnd) {
            selStart = this.selection.y;
            selEnd = this.selection.x;
        }
        selEnd = -1;
        selStart = -1;
        if ((this.state & 0x10) != 0) {
            gc.setForeground(this.disabledColor);
        }
        this.layout.draw(gc, 0, 0, selStart, selEnd, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            Rectangle[] rects = this.getRectanglesInPixels(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = DPIUtil.autoScaleDown(rects[i]);
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
                ++i;
            }
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        this.styleLinkParts();
        this.redraw();
    }

    @Override
    void fixStyle() {
        this.fixStyle(this.handle);
    }

    void initAccessible() {
        if (GTK.GTK4) {
            return;
        }
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                e.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            @Override
            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SWT.getMessage("SWT_Press");
            }

            @Override
            public void getSelection(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return this.linkColor != null ? this.linkColor : this.display.getSystemColor(36);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectanglesInPixels(int linkIndex) {
        int lineCount = this.layout.getLineCount();
        Rectangle[] rects = new Rectangle[lineCount];
        int[] lineOffsets = this.layout.getLineOffsets();
        Point point = this.offsets[linkIndex];
        int lineStart = 1;
        while (point.x > lineOffsets[lineStart]) {
            ++lineStart;
        }
        int lineEnd = 1;
        while (point.y > lineOffsets[lineEnd]) {
            ++lineEnd;
        }
        int index = 0;
        if (lineStart == lineEnd) {
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, point.y));
        } else {
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, lineOffsets[lineStart] - 1));
            rects[index++] = DPIUtil.autoScaleUp(this.layout.getBounds(lineOffsets[lineEnd - 1], point.y));
            if (lineEnd - lineStart > 1) {
                int i = lineStart;
                while (i < lineEnd - 1) {
                    rects[index++] = DPIUtil.autoScaleUp(this.layout.getLineBounds(i));
                    ++i;
                }
            }
        }
        if (rects.length != index) {
            Rectangle[] tmp = new Rectangle[index];
            System.arraycopy(rects, 0, tmp, 0, index);
            rects = tmp;
        }
        return rects;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        eventType = Link.fixGdkEventTypeValues(eventType);
        int[] eventButton = new int[1];
        if (GTK.GTK4) {
            eventButton[0] = GDK.gdk_button_event_get_button(event);
        } else {
            GDK.gdk_event_get_button(event, eventButton);
        }
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        if (eventButton[0] == 1 && eventType == 4) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int x = (int)eventX[0];
            int y = (int)eventY[0];
            if ((this.style & 0x8000000) != 0) {
                x = this.getClientWidth() - x;
            }
            int offset = DPIUtil.autoScaleUp(this.layout.getOffset(x, y, null));
            int oldSelectionX = this.selection.x;
            int oldSelectionY = this.selection.y;
            this.selection.x = offset;
            this.selection.y = -1;
            if (oldSelectionX != -1 && oldSelectionY != -1) {
                if (oldSelectionX > oldSelectionY) {
                    int temp = oldSelectionX;
                    oldSelectionX = oldSelectionY;
                    oldSelectionY = temp;
                }
                Rectangle rect = DPIUtil.autoScaleUp(this.layout.getBounds(oldSelectionX, oldSelectionY));
                this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, false);
            }
            int j = 0;
            while (j < this.offsets.length) {
                Rectangle[] rects = this.getRectanglesInPixels(j);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rect = rects[i];
                    if (rect.contains(x, y)) {
                        this.focusIndex = j;
                        this.redraw();
                        return result;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return result;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        long result = super.gtk_button_release_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        int[] eventButton = new int[1];
        if (GTK.GTK4) {
            eventButton[0] = GDK.gdk_button_event_get_button(event);
        } else {
            GDK.gdk_event_get_button(event, eventButton);
        }
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        if (eventButton[0] == 1) {
            int x = (int)eventX[0];
            int y = (int)eventY[0];
            if ((this.style & 0x8000000) != 0) {
                x = this.getClientWidth() - x;
            }
            Rectangle[] rects = this.getRectanglesInPixels(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = rects[i];
                if (rect.contains(x, y)) {
                    Event ev = new Event();
                    ev.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, ev, true);
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        long context = GTK.gtk_widget_get_style_context(widget);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        GTK.gtk_render_background(context, cairo, 0.0, 0.0, width, height);
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        long result = super.gtk_event_after(widget, gdkEvent);
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        switch (eventType) {
            case 12: {
                this.redraw();
            }
        }
        return result;
    }

    @Override
    boolean gtk4_key_press_event(long controller, int keyval, int keycode, int state, long event) {
        boolean handled = super.gtk4_key_press_event(controller, keyval, keycode, state, event);
        if (!handled && this.focusIndex != -1) {
            switch (keyval) {
                case 32: 
                case 65293: 
                case 65421: {
                    Event jEvent = new Event();
                    jEvent.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, jEvent, true);
                    break;
                }
                case 65289: {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    break;
                }
                case 65056: {
                    if (this.focusIndex <= 0) break;
                    --this.focusIndex;
                    this.redraw();
                }
            }
        }
        return handled;
    }

    @Override
    long gtk_key_press_event(long widget, long eventPtr) {
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        int[] key = new int[1];
        GDK.gdk_event_get_keyval(eventPtr, key);
        switch (key[0]) {
            case 32: 
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
            case 65289: {
                if (this.focusIndex >= this.offsets.length - 1) break;
                ++this.focusIndex;
                this.redraw();
                break;
            }
            case 65056: {
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return result;
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        long result = super.gtk_motion_notify_event(widget, event);
        if (result != 0L) {
            return result;
        }
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        int[] state = new int[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(event, eventX, eventY);
            state[0] = GDK.gdk_event_get_modifier_state(event);
        } else {
            GDK.gdk_event_get_coords(event, eventX, eventY);
            GDK.gdk_event_get_state(event, state);
        }
        int x = (int)eventX[0];
        int y = (int)eventY[0];
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        if ((state[0] & 0x100) != 0) {
            int oldSelection = this.selection.y;
            this.selection.y = DPIUtil.autoScaleUp(this.layout.getOffset(x, y, null));
            if (this.selection.y != oldSelection) {
                int newSelection = this.selection.y;
                if (oldSelection > newSelection) {
                    int temp = oldSelection;
                    oldSelection = newSelection;
                    newSelection = temp;
                }
                Rectangle rect = this.layout.getBounds(oldSelection, newSelection);
                this.redrawInPixels(rect.x, rect.y, rect.width, rect.height, false);
            }
        } else {
            int j = 0;
            while (j < this.offsets.length) {
                Rectangle[] rects = this.getRectanglesInPixels(j);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rect = rects[i];
                    if (rect.contains(x, y)) {
                        this.setCursor(this.display.getSystemCursor(21));
                        return result;
                    }
                    ++i;
                }
                ++j;
            }
            this.setCursor(null);
        }
        return result;
    }

    @Override
    boolean hooksPaint() {
        return true;
    }

    @Override
    boolean mnemonicHit(char key) {
        char uckey = Character.toUpperCase(key);
        String parsedText = this.layout.getText();
        int i = 0;
        while (i < this.mnemonics.length - 1) {
            char mnemonic;
            if (this.mnemonics[i] != -1 && uckey == Character.toUpperCase(mnemonic = parsedText.charAt(this.mnemonics[i]))) {
                if (!this.setFocus()) {
                    return false;
                }
                this.focusIndex = i;
                this.redraw();
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        char uckey = Character.toUpperCase(key);
        String parsedText = this.layout.getText();
        int i = 0;
        while (i < this.mnemonics.length - 1) {
            char mnemonic;
            if (this.mnemonics[i] != -1 && uckey == Character.toUpperCase(mnemonic = parsedText.charAt(this.mnemonics[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        this.linkColor = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuilder result = new StringBuilder();
        StringBuilder buffer = new StringBuilder(string);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c2;
            char c = Character.toLowerCase(buffer.charAt(index));
            if (c == '\\' && index + 1 < length && ((c2 = Character.toLowerCase(buffer.charAt(index + 1))) == '<' || c2 == '>')) {
                buffer.deleteCharAt(index);
                --length;
            }
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer.toString().toCharArray(), start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer.toString().toCharArray(), linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer.toString().toCharArray(), linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer.toString().toCharArray(), refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer.toString().toCharArray(), start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer.toString().toCharArray(), Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuilder result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0) {
            this.layout.setWidth(DPIUtil.autoScaleDown(width > 0 ? width : -1));
            this.redraw();
        }
        return result;
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        this.layout.setFont(Font.gtk_new(this.display, font));
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.linkColor)) {
                return;
            }
        } else if (this.linkColor == null) {
            return;
        }
        this.linkColor = color;
        if (this.getEnabled()) {
            this.styleLinkParts();
            this.redraw();
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        this.layout.setOrientation(this.style & 0x6000000);
        if (!create) {
            this.redraw(true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        this.styleLinkParts();
        int[] bidiSegments = new int[this.offsets.length * 2];
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            bidiSegments[i * 2] = point.x;
            bidiSegments[i * 2 + 1] = point.y + 1;
            ++i;
        }
        this.layout.setSegments(bidiSegments);
        TextStyle mnemonicStyle = new TextStyle(null, null, null);
        mnemonicStyle.underline = true;
        int i2 = 0;
        while (i2 < this.mnemonics.length) {
            int mnemonic = this.mnemonics[i2];
            if (mnemonic != -1) {
                this.layout.setStyle(mnemonicStyle, mnemonic, mnemonic);
            }
            ++i2;
        }
        this.redraw();
    }

    @Override
    void showWidget() {
        super.showWidget();
        this.fixStyle(this.handle);
    }

    void styleLinkParts() {
        boolean enabled = (this.state & 0x10) == 0;
        TextStyle linkStyle = new TextStyle(null, enabled ? this.getLinkForeground() : this.disabledColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
    }

    @Override
    int traversalCode(int key, long event) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int bits = super.traversalCode(key, event);
        if (key == 65289 && this.focusIndex < this.offsets.length - 1) {
            return bits & 0xFFFFFFEF;
        }
        if (key == 65056 && this.focusIndex > 0) {
            return bits & 0xFFFFFFF7;
        }
        return bits;
    }
}

