/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.trace.internal.datamodel.ModifiedDebugOptions;
import org.eclipse.ui.trace.internal.datamodel.TracingComponent;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;
import org.eclipse.ui.trace.internal.utils.TracingUtils;
import org.osgi.framework.Bundle;

public class TracingCollections {
    private ModifiedDebugOptions fModifiedDebugOptions = null;
    private Map<String, TracingComponent> fComponentCollection = new HashMap<String, TracingComponent>();
    private Map<String, List<TracingComponentDebugOption>> fDebugOptionCollection = new HashMap<String, List<TracingComponentDebugOption>>();
    private Map<Bundle, Properties> fBundleOptionsCollection = new HashMap<Bundle, Properties>();
    private Map<Bundle, Boolean> fBundleConsumedCollection = new HashMap<Bundle, Boolean>();
    private Map<Bundle, List<TracingComponent>> fBundleComponentCollection = new HashMap<Bundle, List<TracingComponent>>();
    private static TracingCollections instance = null;

    protected TracingCollections() {
        this.fModifiedDebugOptions = new ModifiedDebugOptions();
    }

    public static TracingCollections getInstance() {
        if (instance == null) {
            instance = new TracingCollections();
        }
        return instance;
    }

    public ModifiedDebugOptions getModifiedDebugOptions() {
        return this.fModifiedDebugOptions;
    }

    public void storeTracingDebugOption(TracingComponentDebugOption newDebugOption) {
        if (newDebugOption != null) {
            List<TracingComponentDebugOption> debugOptions = this.fDebugOptionCollection.get(newDebugOption.getOptionPath());
            if (debugOptions == null) {
                debugOptions = new ArrayList<TracingComponentDebugOption>();
                this.fDebugOptionCollection.put(newDebugOption.getOptionPath(), debugOptions);
            }
            if (!debugOptions.contains(newDebugOption)) {
                debugOptions.add(newDebugOption);
            }
        }
    }

    public TracingComponentDebugOption[] getTracingDebugOptions(String optionPath) {
        List<TracingComponentDebugOption> debugOptions = null;
        if (optionPath != null) {
            debugOptions = this.fDebugOptionCollection.get(optionPath);
        }
        if (debugOptions == null) {
            debugOptions = Collections.emptyList();
        }
        return debugOptions.toArray(new TracingComponentDebugOption[debugOptions.size()]);
    }

    public TracingComponent getTracingComponent(IConfigurationElement element) {
        String id;
        TracingComponent component = null;
        if (element != null && (id = element.getAttribute("id")) != null) {
            component = this.fComponentCollection.get(id);
            if (component == null) {
                component = new TracingComponent(element);
                this.fComponentCollection.put(id, component);
            } else {
                component.addBundles(element);
                String newComponentLabel = element.getAttribute("label");
                if (newComponentLabel != null) {
                    component.setLabel(newComponentLabel);
                }
            }
        }
        return component;
    }

    public Properties getDebugOptions(Bundle bundle) {
        Properties results = null;
        if (bundle != null && (results = this.fBundleOptionsCollection.get(bundle)) == null) {
            results = TracingUtils.loadOptionsFromBundle(bundle);
            this.fBundleOptionsCollection.put(bundle, results);
        }
        return results;
    }

    public void setBundleIsConsumed(Bundle bundle, boolean consumed) {
        if (bundle != null) {
            this.fBundleConsumedCollection.put(bundle, consumed);
        }
    }

    public boolean isBundleConsumed(Bundle bundle) {
        Boolean isConsumed;
        boolean result = false;
        if (bundle != null && (isConsumed = this.fBundleConsumedCollection.get(bundle)) != null) {
            result = isConsumed;
        }
        return result;
    }

    public void storeBundleInComponent(TracingComponent component, Bundle bundle) {
        if (bundle != null && component != null) {
            List<TracingComponent> components = this.fBundleComponentCollection.get(bundle);
            if (components == null) {
                components = new ArrayList<TracingComponent>();
                this.fBundleComponentCollection.put(bundle, components);
            }
            components.add(component);
        }
    }

    public TracingComponent[] getComponentsContainingBundle(Bundle bundle) {
        List<TracingComponent> components = null;
        if (bundle != null) {
            components = this.fBundleComponentCollection.get(bundle);
        }
        if (components == null) {
            components = Collections.emptyList();
        }
        return components.toArray(new TracingComponent[components.size()]);
    }

    public final void clear() {
        this.fComponentCollection.clear();
        this.fDebugOptionCollection.clear();
        this.fBundleOptionsCollection.clear();
        this.fBundleConsumedCollection.clear();
        this.fBundleComponentCollection.clear();
    }
}

