/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartialStateSystem2DTest {
    private static final String PSS_USAGE_FILE = "testfiles/partialSS_2d.xml";
    private static final @NonNull String TEST_FILE_NAME = "test-partial-2DQuery";
    private static final long START_TIME = 10L;
    private static File fStateFile;
    private IKernelTrace fTrace;
    private TestLttngKernelAnalysisModule fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        if (trace != null) {
            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
            File[] fileArray = suppDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(PSS_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        PartialStateSystem2DTest.deleteSuppFiles((ITmfTrace)trace);
        fStateFile = new File(String.valueOf(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace)) + TEST_FILE_NAME);
        if (fStateFile.exists()) {
            fStateFile.delete();
        }
        this.fModule = new TestLttngKernelAnalysisModule(TEST_FILE_NAME);
        try {
            Assert.assertTrue((boolean)this.fModule.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)((Object)this.fModule));
        this.fModule.schedule();
        Assert.assertTrue((boolean)this.fModule.waitForCompletion());
        this.fTrace = trace;
    }

    @After
    public void cleanup() {
        IKernelTrace testTrace = this.fTrace;
        if (testTrace != null) {
            testTrace.dispose();
        }
        this.fModule.dispose();
    }

    protected static void testContinuous(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, long start, long end, int totalCount) {
        TreeMultimap treeMap = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        iterable.forEach(arg_0 -> PartialStateSystem2DTest.lambda$1((Multimap)treeMap, arg_0));
        Assert.assertEquals((String)"Wrong number of intervals returned", (long)totalCount, (long)treeMap.size());
        Assert.assertEquals((String)"There should only be as many Sets of intervals as quarks", (long)quarks.size(), (long)treeMap.keySet().size());
        for (Integer quark : quarks) {
            Collection orderedSet = treeMap.get((Object)quark);
            Assert.assertFalse((String)("There should be intervals for quark: " + quark), (boolean)orderedSet.isEmpty());
            ITmfStateInterval previous = null;
            for (ITmfStateInterval interval : orderedSet) {
                if (previous == null) {
                    Assert.assertTrue((String)("The first interval: " + interval + "should intersect start: " + start), (boolean)interval.intersects(start));
                } else {
                    Assert.assertEquals((String)("Current interval: " + interval + " should have been contiguous to the previous one " + previous), (long)(previous.getEndTime() + 1L), (long)interval.getStartTime());
                }
                previous = interval;
            }
            Assert.assertNotNull((String)("There should have been at least one interval for quark " + quark), previous);
            Assert.assertTrue((String)("last interval: " + previous + " should intersect end " + end), (boolean)previous.intersects(end));
        }
    }

    @Test
    public void testContinuous2DQuery() throws AttributeNotFoundException, IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        String attributePath = "0";
        int attributeQuark = ss.getQuarkAbsolute(new String[]{"CPUs", attributePath, "Current_thread"});
        Iterable iterable = ss.query2D(Collections.singleton(attributeQuark), 10L, end);
        PartialStateSystem2DTest.testContinuous(iterable, Collections.singleton(attributeQuark), 10L, end, 4);
        attributePath = "1";
        int integerQuark = ss.getQuarkAbsolute(new String[]{"CPUs", attributePath, "Current_thread"});
        iterable = ss.query2D(Collections.singleton(integerQuark), 10L, end);
        PartialStateSystem2DTest.testContinuous(iterable, Collections.singleton(integerQuark), 10L, end, 7);
        int proc1Quark = ss.getQuarkAbsolute(new String[]{"Threads", "100"});
        int proc2Quark = ss.getQuarkAbsolute(new String[]{"Threads", "200"});
        ImmutableList quarks = ImmutableList.of((Object)proc1Quark, (Object)proc2Quark);
        iterable = ss.query2D((Collection)quarks, 10L, end);
        PartialStateSystem2DTest.testContinuous(iterable, (Collection<Integer>)quarks, 10L, end, 8);
        int proc3Quark = ss.getQuarkAbsolute(new String[]{"Threads", "300"});
        int proc4Quark = ss.getQuarkAbsolute(new String[]{"Threads", "400"});
        quarks = ImmutableList.of((Object)proc3Quark, (Object)proc4Quark);
        iterable = ss.query2D((Collection)quarks, 10L, end);
        PartialStateSystem2DTest.testContinuous(iterable, (Collection<Integer>)quarks, 10L, end, 14);
        int nbAttributes = ss.getNbAttributes();
        ArrayList<Integer> quarksList = new ArrayList<Integer>();
        int i = 0;
        while (i < nbAttributes) {
            quarksList.add(i);
            ++i;
        }
        iterable = ss.query2D(quarksList, 10L, end);
        PartialStateSystem2DTest.testContinuous(iterable, quarksList, 10L, end, 61);
    }

    protected static void testDiscrete(Iterable<ITmfStateInterval> iterable, Collection<Integer> quarks, Collection<Long> times, int totalCount) {
        HashSet<ITmfStateInterval> set = new HashSet<ITmfStateInterval>();
        int countTimeStamps = 0;
        for (ITmfStateInterval interval : iterable) {
            Assert.assertTrue((boolean)quarks.contains(interval.getAttribute()));
            Assert.assertTrue((String)("interval: " + interval + " was returned twice"), (boolean)set.add(interval));
            int timeStamps = (int)times.stream().filter(arg_0 -> ((ITmfStateInterval)interval).intersects(arg_0)).count();
            Assert.assertTrue((String)("interval: " + interval + " does not intersect any time stamp: " + times), (timeStamps > 0 ? 1 : 0) != 0);
            countTimeStamps += timeStamps;
        }
        Assert.assertEquals((String)"incorrect number of intervals returned", (long)totalCount, (long)set.size());
        Assert.assertEquals((String)"All the queried time stamps were not covered", (long)(times.size() * quarks.size()), (long)countTimeStamps);
    }

    @Test
    public void testDiscrete2DQuery() throws AttributeNotFoundException, IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        List times = StateSystemUtils.getTimes((long)10L, (long)end, (long)10L);
        Assert.assertEquals((long)4L, (long)times.size());
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)times));
        int proc1Quark = ss.getQuarkAbsolute(new String[]{"Threads", "100"});
        Iterable iterable = ss.query2D(Collections.singleton(proc1Quark), (Collection)times);
        PartialStateSystem2DTest.testDiscrete(iterable, Collections.singleton(proc1Quark), times, 4);
        int proc3Quark = ss.getQuarkAbsolute(new String[]{"Threads", "300"});
        iterable = ss.query2D(Collections.singleton(proc3Quark), (Collection)times);
        PartialStateSystem2DTest.testDiscrete(iterable, Collections.singleton(proc3Quark), times, 4);
        ImmutableList quarks = ImmutableList.of((Object)proc1Quark, (Object)proc3Quark);
        iterable = ss.query2D((Collection)quarks, (Collection)times);
        PartialStateSystem2DTest.testDiscrete(iterable, (Collection<Integer>)quarks, times, 8);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIOOB2DQuery() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Set<Long> times = Collections.singleton(35L);
        int stringQuark = Integer.MAX_VALUE;
        ss.query2D(Collections.singleton(stringQuark), times);
    }

    @Test(expected=TimeRangeException.class)
    public void testTimeRangeException2DContinous() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        ss.query2D(Collections.singleton(0), 0L, 35L);
    }

    @Test(expected=TimeRangeException.class)
    public void testTimeRangeException2DDiscrete() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        ss.query2D(Collections.singleton(0), Collections.singleton(Long.MIN_VALUE));
    }

    @Test
    public void testEmpty2DQuery() throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Iterable iterable = ss.query2D(Collections.emptyList(), Collections.singleton(35L));
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
        iterable = ss.query2D(Collections.singleton(0), Collections.emptyList());
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
        iterable = ss.query2D(Collections.emptyList(), 35L, 38L);
        Assert.assertNotNull((Object)iterable);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)iterable));
    }

    @Test
    public void testReverse2DQuery() throws AttributeNotFoundException, IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        long end = ss.getCurrentEndTime();
        int proc1Quark = ss.getQuarkAbsolute(new String[]{"Threads", "100"});
        Iterable iterable = ss.query2D(Collections.singleton(proc1Quark), end, 10L);
        PartialStateSystem2DTest.testContinuous(iterable, Collections.singleton(proc1Quark), 10L, end, 4);
        int proc3Quark = ss.getQuarkAbsolute(new String[]{"Threads", "300"});
        iterable = ss.query2D(Collections.singleton(proc3Quark), end, 10L);
        PartialStateSystem2DTest.testContinuous(iterable, Collections.singleton(proc3Quark), 10L, end, 7);
        ImmutableList quarks = ImmutableList.of((Object)proc1Quark, (Object)proc3Quark);
        iterable = ss.query2D((Collection)quarks, end, 10L);
        PartialStateSystem2DTest.testContinuous(iterable, (Collection<Integer>)quarks, 10L, end, 11);
    }

    private static /* synthetic */ void lambda$1(Multimap multimap, ITmfStateInterval interval) {
        Assert.assertTrue((String)("Interval: " + interval + " was already returned: " + multimap), (boolean)multimap.put((Object)interval.getAttribute(), (Object)interval));
    }

    @NonNullByDefault
    private static class TestLttngKernelAnalysisModule
    extends KernelAnalysisModule {
        private final String htFileName;

        public TestLttngKernelAnalysisModule(String htFileName) {
            this.htFileName = htFileName;
        }

        protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
            return TmfStateSystemAnalysisModule.StateSystemBackendType.PARTIAL;
        }

        protected String getSsFileName() {
            return this.htFileName;
        }
    }
}

