/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTAmbiguousDeclarator
extends ASTAmbiguousNode
implements IASTAmbiguousDeclarator,
ICPPASTDeclarator {
    private IASTDeclarator[] dtors = new IASTDeclarator[2];
    private int dtorPos = -1;
    private IASTInitializer fInitializer;

    public CPPASTAmbiguousDeclarator(IASTDeclarator ... decls) {
        IASTDeclarator[] iASTDeclaratorArray = decls;
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator d = iASTDeclaratorArray[n2];
            if (d != null) {
                this.addDeclarator(d);
            }
            ++n2;
        }
    }

    @Override
    protected void beforeResolution() {
        IScope scope = CPPVisitor.getContainingNonTemplateScope(this);
        if (scope instanceof ICPPASTInternalScope) {
            ((ICPPASTInternalScope)scope).populateCache();
        }
    }

    @Override
    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
        if (this.fInitializer != null) {
            ((IASTDeclarator)best).setInitializer(this.fInitializer);
            this.fInitializer.accept(resolver);
        }
    }

    @Override
    public IASTDeclarator copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTDeclarator copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclarator(IASTDeclarator d) {
        this.assertNotFrozen();
        if (d != null) {
            this.dtors = ArrayUtil.appendAt(IASTDeclarator.class, this.dtors, ++this.dtorPos, d);
            d.setParent(this);
            d.setPropertyInParent(SUBDECLARATOR);
        }
    }

    @Override
    public IASTDeclarator[] getDeclarators() {
        this.dtors = ArrayUtil.trimAt(IASTDeclarator.class, this.dtors, this.dtorPos);
        return this.dtors;
    }

    @Override
    public IASTNode[] getNodes() {
        return this.getDeclarators();
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    @Override
    public IASTName getName() {
        return this.dtors[0].getName();
    }

    @Override
    public IASTDeclarator getNestedDeclarator() {
        return this.dtors[0].getNestedDeclarator();
    }

    @Override
    public IASTPointerOperator[] getPointerOperators() {
        return this.dtors[0].getPointerOperators();
    }

    @Override
    public void addPointerOperator(IASTPointerOperator operator) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return this.dtors[0].getAttributes();
    }

    @Override
    @Deprecated
    public void addAttribute(IASTAttribute attribute) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public IASTAttributeSpecifier[] getAttributeSpecifiers() {
        return this.dtors[0].getAttributeSpecifiers();
    }

    @Override
    public void addAttributeSpecifier(IASTAttributeSpecifier attributeSpecifier) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public int getRoleForName(IASTName name) {
        return this.dtors[0].getRoleForName(name);
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.fInitializer = initializer;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public void setNestedDeclarator(IASTDeclarator nested) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public boolean declaresParameterPack() {
        return false;
    }

    @Override
    public void setDeclaresParameterPack(boolean val) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }
}

