/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatisticsAnalysis;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.ITypedDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreStatisticsDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeDataProvider<SegmentStoreStatisticsModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider";
    private static final String STATISTICS_SUFFIX = ".statistics";
    private static final String TOTAL_PREFIX = "Total_";
    private static final String SELECTION_PREFIX = "Selection_";
    private static final Map<IStatisticsAnalysis, SegmentStoreStatisticsDataProvider> PROVIDER_MAP = new WeakHashMap<IStatisticsAnalysis, SegmentStoreStatisticsDataProvider>();
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final IStatisticsAnalysis fProvider;
    private final String fId;
    private @Nullable String fRootEntryName;
    private final Map<String, Long> fIdToType = new HashMap<String, Long>();
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private final @Nullable IAnalysisModule fModule;
    private SegmentStoreStatisticsAspects fAspects = new SegmentStoreStatisticsAspects();

    public static synchronized @Nullable SegmentStoreStatisticsDataProvider getOrCreate(ITmfTrace trace, AbstractSegmentStatisticsAnalysis module) {
        return PROVIDER_MAP.computeIfAbsent(module, p -> new SegmentStoreStatisticsDataProvider(trace, (IStatisticsAnalysis)p, String.valueOf(module.getId()) + STATISTICS_SUFFIX));
    }

    public SegmentStoreStatisticsDataProvider(ITmfTrace trace, IStatisticsAnalysis provider, String id) {
        super(trace);
        this.fId = id;
        this.fProvider = provider;
        this.fModule = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
    }

    public SegmentStoreStatisticsDataProvider(ITmfTrace trace, IStatisticsAnalysis provider, String id, List<IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>> userDefinedAspects) {
        this(trace, provider, id);
        this.fAspects = new SegmentStoreStatisticsAspects(userDefinedAspects);
    }

    public TmfModelResponse<TmfTreeModel<SegmentStoreStatisticsModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        IStatistics<ISegment> statsTotal;
        IAnalysisModule module = this.fModule;
        if (module != null) {
            if (monitor != null) {
                module.waitForCompletion(monitor);
                if (monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
            } else {
                module.waitForCompletion();
            }
        }
        if ((statsTotal = this.fProvider.getStatsTotal()) == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<SegmentStoreStatisticsModel> list = new ArrayList<SegmentStoreStatisticsModel>();
        String rootName = this.getRootEntryName();
        if (rootName == null) {
            rootName = this.getTrace().getName();
        }
        list.add(new SegmentStoreStatisticsModel(this.fTraceId, -1L, this.getCellLabels(NonNullUtils.nullToEmptyString((Object)rootName), statsTotal), statsTotal));
        long totalId = this.getUniqueId(TOTAL_PREFIX);
        list.add(new SegmentStoreStatisticsModel(totalId, this.fTraceId, this.getCellLabels(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Total), statsTotal), statsTotal));
        Map totalStats = this.fProvider.getStatsPerType();
        for (Map.Entry entry : totalStats.entrySet()) {
            IStatistics<ISegment> statistics = entry.getValue();
            list.add(new SegmentStoreStatisticsModel(this.getUniqueId(TOTAL_PREFIX + entry.getKey()), totalId, this.getCellLabels(entry.getKey(), statistics), statistics));
        }
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(fetchParameters);
        if (filter != null && isFiltered != null && isFiltered.booleanValue()) {
            IProgressMonitor nonNullMonitor;
            long end;
            long start = filter.getStart();
            IStatistics<ISegment> statsForRange = this.fProvider.getStatsForRange(start, end = filter.getEnd(), nonNullMonitor = monitor != null ? monitor : new NullProgressMonitor());
            if (statsForRange == null) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            long selectionId = this.getUniqueId(SELECTION_PREFIX);
            if (statsForRange.getNbElements() > 0L) {
                list.add(new SegmentStoreStatisticsModel(selectionId, this.fTraceId, this.getCellLabels(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Selection), statsForRange), statsForRange));
                Map selectionStats = this.fProvider.getStatsPerTypeForRange(start, end, nonNullMonitor);
                for (Map.Entry entry : selectionStats.entrySet()) {
                    IStatistics<ISegment> statistics = entry.getValue();
                    list.add(new SegmentStoreStatisticsModel(this.getUniqueId(SELECTION_PREFIX + entry.getKey()), selectionId, this.getCellLabels(entry.getKey(), statistics), statistics));
                }
            }
        }
        TmfTreeModel.Builder treeModelBuilder = new TmfTreeModel.Builder();
        treeModelBuilder.setColumnDescriptors(this.getColumnDescriptors());
        treeModelBuilder.setEntries(Collections.unmodifiableList(list));
        return new TmfModelResponse((Object)treeModelBuilder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private List<ITableColumnDescriptor> getColumnDescriptors() {
        ImmutableList.Builder headers = new ImmutableList.Builder();
        for (IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics> aspect : this.fAspects.getAspects()) {
            TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
            builder.setText(Objects.requireNonNull(aspect.getName()));
            builder.setTooltip(Objects.requireNonNull(aspect.getHelpText()));
            if (aspect instanceof ITypedDataAspect) {
                builder.setDataType(((ITypedDataAspect)aspect).getDataType());
            }
            headers.add((Object)builder.build());
        }
        return headers.build();
    }

    private List<String> getCellLabels(String name, IStatistics<ISegment> statistics) {
        SegmentStoreStatisticsAspects.NamedStatistics namedStatistics = new SegmentStoreStatisticsAspects.NamedStatistics(name, statistics);
        ImmutableList.Builder labels = new ImmutableList.Builder();
        for (IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics> aspect : this.fAspects.getAspects()) {
            labels.add((Object)NonNullUtils.nullToEmptyString(aspect.apply(namedStatistics)));
        }
        return labels.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUniqueId(String name) {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            return this.fIdToType.computeIfAbsent(name, n -> ENTRY_ID.getAndIncrement());
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            this.fIdToType.clear();
        }
        if (this.fModule != null) {
            this.fModule.dispose();
        }
    }

    public void setRootEntryName(@Nullable String rootName) {
        this.fRootEntryName = rootName;
    }

    public final @Nullable String getRootEntryName() {
        return this.fRootEntryName;
    }

    public void setMapper(Function<Number, String> mapper) {
        this.fAspects.setMapper(mapper);
    }

    public void setLabelMapper(UnaryOperator<String> mapper) {
        this.fAspects.setLabelMapper(mapper);
    }
}

