/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreAnalysisModule;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.StubSegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreTableDataProviderTest {
    private static ITmfVirtualTableDataProvider<@NonNull TmfTreeDataModel, @NonNull VirtualTableLine> fDataProvider;
    private static final String START_TIME_COLUMN_NAME = "Start Time";
    private static final String END_TIME_COLUMN_NAME = "End Time";
    private static final String DURATION_COLUMN_NAME = "Duration";
    private static final String TABLE_COMPARATOR_EXPRESSION_KEY = "table_comparator_expression";
    private static final String TABLE_SEARCH_EXPRESSION_KEY = "table_search_expressions";
    private static final String TABLE_SEARCH_DIRECTION_KEY = "table_search_direction";
    private static Map<String, Long> fColumns;
    private static TmfXmlTraceStub fTrace;

    static {
        fColumns = Collections.emptyMap();
    }

    @BeforeClass
    public static void init() throws TmfAnalysisException {
        fTrace = new TmfXmlTraceStubNs();
        @NonNull SegmentStoreAnalysisModule fixture = SegmentStoreTableDataProviderTest.getValidSegment((ITmfTrace)fTrace);
        TmfXmlTraceStub trace = fTrace;
        Assert.assertNotNull((Object)trace);
        fDataProvider = new SegmentStoreTableDataProvider((ITmfTrace)fTrace, (ISegmentStoreProvider)fixture, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
        fColumns = SegmentStoreTableDataProviderTest.fetchColumnId();
    }

    private static @NonNull SegmentStoreAnalysisModule getValidSegment(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStoreProvider preFixture = new StubSegmentStoreProvider();
        preFixture.setTrace(trace);
        SegmentStoreAnalysisModule fixture = new SegmentStoreAnalysisModule(trace);
        if (trace instanceof TmfXmlTraceStubNs) {
            ((TmfXmlTraceStubNs)trace).addAnalysisModule((IAnalysisModule)fixture);
        }
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<String, Long> fetchColumnId() {
        @NonNull TmfTreeModel columns = (TmfTreeModel)fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, 0L, 1)), null).getModel();
        if (columns == null) {
            return Collections.emptyMap();
        }
        @NonNull List columnEntries = columns.getEntries();
        Assert.assertEquals((Object)START_TIME_COLUMN_NAME, (Object)((TmfTreeDataModel)columnEntries.get(0)).getName());
        Assert.assertEquals((Object)END_TIME_COLUMN_NAME, (Object)((TmfTreeDataModel)columnEntries.get(1)).getName());
        Assert.assertEquals((Object)DURATION_COLUMN_NAME, (Object)((TmfTreeDataModel)columnEntries.get(2)).getName());
        Assert.assertEquals((Object)"Stub Column", (Object)((TmfTreeDataModel)columnEntries.get(3)).getName());
        LinkedHashMap<String, Long> expectedColumns = new LinkedHashMap<String, Long>();
        for (TmfTreeDataModel column : columnEntries) {
            expectedColumns.put(column.getName(), column.getId());
        }
        return expectedColumns;
    }

    @AfterClass
    public static void tearDown() {
        fTrace.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchColumn() {
        Long startTimeColumnId = fColumns.get(START_TIME_COLUMN_NAME);
        Long endTimeColumnId = fColumns.get(END_TIME_COLUMN_NAME);
        Long durationColumnId = fColumns.get(DURATION_COLUMN_NAME);
        Long customColumndId = fColumns.get("Stub Column");
        Assert.assertNotNull((Object)startTimeColumnId);
        Assert.assertNotNull((Object)endTimeColumnId);
        Assert.assertNotNull((Object)durationColumnId);
        Assert.assertNotNull((Object)customColumndId);
        List<@NonNull TmfTreeDataModel> expectedColumnEntries = Arrays.asList(new TmfTreeDataModel(startTimeColumnId.longValue(), -1L, Collections.singletonList(START_TIME_COLUMN_NAME)), new TmfTreeDataModel(endTimeColumnId.longValue(), -1L, Collections.singletonList(END_TIME_COLUMN_NAME)), new TmfTreeDataModel(durationColumnId.longValue(), -1L, Collections.singletonList(DURATION_COLUMN_NAME)), new TmfTreeDataModel(customColumndId.longValue(), -1L, Collections.singletonList("Stub Column")));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, 0L, 1)), null);
        @NonNull TmfTreeModel currentColumnModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)currentColumnModel);
        @NonNull List currentColumnEntries = Objects.requireNonNull(currentColumnModel).getEntries();
        Assert.assertEquals(expectedColumnEntries, (Object)currentColumnEntries);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineZeroIndex() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(1L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(4L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineNonZeroIndex() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 10L, 5);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(10L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(10L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(11L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(11L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(12L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(12L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(5L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(13L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(13L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(14L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(14L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(14L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 10L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineTimeOut() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 3200L, 5);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(3200L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3199L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3200L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(1L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3201L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3199L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3201L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3202L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3199L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3202L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3203L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3199L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3203L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3204L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3199L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3204L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(5L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 3200L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineCornerIndex() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 1000L, 5);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(1000L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(994L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1001L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1002L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1002L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(1L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1003L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1003L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1004L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1004L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 1000L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineWithSearch() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderTest.lineTime(7000L));
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "NEXT");
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(7000L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7001L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7001L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(1L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7002L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7002L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7003L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7003L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7004L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7004L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))));
        expectedData.forEach(sl -> sl.setActiveProperties(8));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 7000L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineWithSearchPrevious() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 65534L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderTest.lineTime(7000L));
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "PREVIOUS");
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(7006L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7006L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7005L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7005L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(5L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7004L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7004L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7003L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7003L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(7002L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7000L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7002L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))));
        expectedData.forEach(sl -> sl.setActiveProperties(8));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 7006L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineWithSearchTypo() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderTest.lineTime(7000L));
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        String typo = "T";
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "NEXT" + typo);
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        Assert.assertNull((Object)response.getModel());
        Assert.assertEquals((Object)response.getStatus(), (Object)ITmfResponse.Status.FAILED);
        Assert.assertEquals((Object)response.getStatusMessage(), (Object)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineCrossIndexes() {
        int count = 2000;
        long previousStartTime = 0L;
        ArrayList<@NonNull VirtualTableLine> expectedData = new ArrayList<VirtualTableLine>();
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(new ArrayList<Long>(fColumns.values()), 0L, count);
        long i = 0L;
        while (i < (long)count) {
            if (i % 7L == 0L) {
                previousStartTime = i;
            }
            expectedData.add(new VirtualTableLine(i, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(previousStartTime)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(i)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(i - previousStartTime)), new VirtualTableCell("Stub Content"))));
            ++i;
        }
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineWithEndTimeComparator() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        Long endTimeColumnID = fColumns.get(END_TIME_COLUMN_NAME);
        Assert.assertNotNull((Object)endTimeColumnID);
        fetchParameters.put(TABLE_COMPARATOR_EXPRESSION_KEY, endTimeColumnID);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65534L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65534L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65527L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65533L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65527L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65532L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(5L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65527L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65531L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65527L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65530L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLineWithDurationComparator() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        Long durationColumnID = fColumns.get(DURATION_COLUMN_NAME);
        Assert.assertNotNull((Object)durationColumnID);
        fetchParameters.put(TABLE_COMPARATOR_EXPRESSION_KEY, durationColumnID);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(14L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(14L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(28L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(28L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(0L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLastLinesWithEndComparator() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 65529L, 5);
        Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        Long endTimeColumnID = fColumns.get(END_TIME_COLUMN_NAME);
        Assert.assertNotNull((Object)endTimeColumnID);
        fetchParameters.put(TABLE_COMPARATOR_EXPRESSION_KEY, endTimeColumnID);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(65529L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(5L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(5L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65530L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(4L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(4L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65531L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(3L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(3L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65532L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(2L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65533L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(1L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 65529L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderFetchLastLinesWithDurationComparator() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 65529L, 5);
        Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        Long durationColumnID = fColumns.get(DURATION_COLUMN_NAME);
        Assert.assertNotNull((Object)durationColumnID);
        fetchParameters.put(TABLE_COMPARATOR_EXPRESSION_KEY, durationColumnID);
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(65529L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65492L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65498L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65530L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65499L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65505L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65531L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65506L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65512L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65532L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65513L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65519L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))), new VirtualTableLine(65533L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65520L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineTime(65526L)), new VirtualTableCell(SegmentStoreTableDataProviderTest.lineDuration(6L)), new VirtualTableCell("Stub Content"))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 65529L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    private static String lineTime(long milliseconds) {
        return TmfTimestamp.fromNanos((long)milliseconds).toString();
    }

    private static String lineDuration(long duration) {
        return new DecimalFormat("###,###.##").format(duration);
    }
}

