/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.event;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.junit.Assert;
import org.junit.Test;

public class CTFCallsiteTest {
    private static CTFCallsite GenerateCS(long ip) {
        return new CTFCallsite("event name", "func name", ip, "file.java", 1L);
    }

    @Test
    public void constructorTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertNotNull((Object)cs);
    }

    @Test
    public void getterTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertEquals((String)"instruction pointer", (long)1L, (long)cs.getIp());
        Assert.assertEquals((String)"event name", (Object)"event name", (Object)cs.getEventName());
        Assert.assertEquals((String)"file name", (Object)"file.java", (Object)cs.getFileName());
        Assert.assertEquals((String)"function name", (Object)"func name", (Object)cs.getFunctionName());
        Assert.assertEquals((String)"line number", (long)1L, (long)cs.getLineNumber());
    }

    @Test
    public void hashCodeTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        HashMap<CTFCallsite, Object> test = new HashMap<CTFCallsite, Object>();
        test.put(cs, new Object());
        Assert.assertTrue((boolean)test.containsKey(cs));
        Assert.assertTrue((boolean)test.containsKey(CTFCallsiteTest.GenerateCS(1L)));
        Assert.assertFalse((boolean)test.containsKey(CTFCallsiteTest.GenerateCS(2L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event nam", "func name", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func nam", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func name", 1L, "file.jav", 1L)));
        Assert.assertFalse((boolean)test.containsKey(new CTFCallsite("event name", "func name", 1L, "file.java", 2L)));
    }

    @Test
    public void equalsTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        CTFCallsite cs1 = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertEquals((Object)cs, (Object)cs);
        Assert.assertEquals((Object)cs, (Object)cs1);
        Assert.assertEquals((Object)cs, (Object)new CTFCallsite("event name", "func name", 1L, "file.java", 1L));
        Assert.assertFalse((boolean)cs.equals(null));
        Assert.assertFalse((boolean)cs.equals((Object)-1));
        Assert.assertFalse((boolean)cs.equals((Object)new CTFCallsite("event nam", "func name", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)cs.equals((Object)new CTFCallsite("event name", "func nam", 1L, "file.java", 1L)));
        Assert.assertFalse((boolean)cs.equals((Object)new CTFCallsite("event name", "func name", 2L, "file.java", 1L)));
        Assert.assertFalse((boolean)cs.equals((Object)new CTFCallsite("event name", "func name", 1L, "file.jav", 1L)));
        Assert.assertFalse((boolean)cs.equals((Object)new CTFCallsite("event name", "func name", 1L, "file.java", 2L)));
    }

    @Test
    public void comparatorTest() {
        CTFCallsite[] cs = new CTFCallsite[5];
        long[] lArray = new long[5];
        lArray[0] = 1L;
        lArray[2] = -2L;
        lArray[3] = 2L;
        lArray[4] = -1L;
        long[] vals = lArray;
        int i = 0;
        while (i < 5) {
            cs[i] = CTFCallsiteTest.GenerateCS(vals[i]);
            ++i;
        }
        Arrays.sort(cs, (o1, o2) -> Long.compareUnsigned(o1.getIp(), o2.getIp()));
        Assert.assertEquals((long)0L, (long)cs[0].getIp());
        Assert.assertEquals((long)1L, (long)cs[1].getIp());
        Assert.assertEquals((long)2L, (long)cs[2].getIp());
        Assert.assertEquals((long)-2L, (long)cs[3].getIp());
        Assert.assertEquals((long)-1L, (long)cs[4].getIp());
    }

    @Test
    public void toStringTest() {
        CTFCallsite cs = CTFCallsiteTest.GenerateCS(1L);
        Assert.assertEquals((Object)"file.java/func name:1", (Object)cs.toString());
    }
}

