/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph.model.TimeGraphLineEntry;
import org.eclipse.tracecompass.tmf.core.model.ICoreElementResolver;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.EventIterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;

public class TimeGraphEntry
implements ITimeGraphEntry,
ICoreElementResolver {
    public static final Comparator<ITimeEvent> WITHIN_COMPARATOR = (e1, e2) -> {
        int comp = Long.compare(e1.getTime(), e2.getTime());
        if (comp > 0) {
            return comp;
        }
        comp = Long.compare(e1.getTime() + e1.getDuration(), e2.getTime() + e2.getDuration());
        if (comp < 0) {
            return comp;
        }
        return 0;
    };
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TimeGraphEntry.class);
    private TimeGraphEntry fParent = null;
    private final List<@NonNull TimeGraphEntry> fChildren = new CopyOnWriteArrayList<TimeGraphEntry>();
    private @NonNull List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>();
    private @NonNull List<ITimeEvent> fZoomedEventList = new ArrayList<ITimeEvent>();
    private Comparator<ITimeGraphEntry> fComparator;
    private Sampling fSampling;
    private @NonNull ITmfTreeDataModel fModel;
    private long fStartTime;
    private long fEndTime;

    public static TimeGraphEntry create(TimeGraphEntryModel model, ITimeGraphEntry.DisplayStyle style) {
        switch (style) {
            case LINE: {
                return new TimeGraphLineEntry(model);
            }
            case STATE: {
                return new TimeGraphEntry(model);
            }
        }
        throw new IllegalStateException("Invalid style " + style.toString());
    }

    public TimeGraphEntry(String name, long startTime, long endTime) {
        this(new TimeGraphEntryModel(-1L, -1L, Collections.singletonList(name), startTime, endTime));
    }

    public TimeGraphEntry(@NonNull TimeGraphEntryModel model) {
        this.fModel = model;
        this.fStartTime = model.getStartTime();
        this.fEndTime = model.getEndTime();
    }

    public TimeGraphEntry(@NonNull ITmfTreeDataModel model) {
        this.fModel = model;
        if (model instanceof TimeGraphEntryModel) {
            this.updateModel((TimeGraphEntryModel)model);
        } else {
            this.fStartTime = 0L;
            this.fEndTime = Long.MAX_VALUE;
        }
    }

    @Override
    public TimeGraphEntry getParent() {
        return this.fParent;
    }

    public void setParent(TimeGraphEntry entry) {
        this.fParent = entry;
    }

    @Override
    public synchronized boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public synchronized List<@NonNull TimeGraphEntry> getChildren() {
        return this.fChildren;
    }

    public synchronized void clearChildren() {
        this.fChildren.clear();
    }

    @Override
    public String getName() {
        return this.getEntryModel().getName();
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    public void updateEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public boolean hasTimeEvents() {
        return this.fModel instanceof ITimeGraphEntryModel ? ((ITimeGraphEntryModel)this.fModel).hasRowModel() : true;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        if (this.hasTimeEvents()) {
            return new EventIterator(this.fEventList, this.fZoomedEventList);
        }
        return null;
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        if (!this.hasTimeEvents()) {
            return null;
        }
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public void addEvent(ITimeEvent event) {
        int lastIndex = this.fEventList.size() - 1;
        if (lastIndex >= 0 && this.fEventList.get(lastIndex).getTime() == event.getTime()) {
            this.fEventList.set(lastIndex, event);
        } else {
            this.fEventList.add(event);
        }
        this.updateEntryBounds(event);
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList != null ? eventList : new ArrayList<ITimeEvent>();
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        if (eventList != null) {
            this.fZoomedEventList = eventList;
        } else {
            this.fZoomedEventList = new ArrayList<ITimeEvent>();
            this.fSampling = null;
        }
    }

    public void addZoomedEvent(ITimeEvent event) {
        long lastStart;
        long start = event.getTime();
        int lastIndex = this.fZoomedEventList.size() - 1;
        long l = lastStart = lastIndex >= 0 ? this.fZoomedEventList.get(lastIndex).getTime() : Long.MIN_VALUE;
        if (start > lastStart) {
            this.fZoomedEventList.add(event);
        } else if (start == lastStart) {
            this.fZoomedEventList.set(lastIndex, event);
        } else if (start < this.fZoomedEventList.get(0).getTime()) {
            this.fZoomedEventList.clear();
            this.fZoomedEventList.add(event);
        }
        this.updateEntryBounds(event);
    }

    public void updateZoomedEvent(ITimeEvent event) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog poc = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "UpdateZoomedEvent", new Object[0]);){
            long last;
            long first;
            int index;
            long start = this.getStartTime();
            long end = this.getEndTime();
            if (this.fZoomedEventList.isEmpty()) {
                this.fZoomedEventList.add(new NullTimeEvent(this, start, end));
            }
            if ((index = Collections.binarySearch(this.fZoomedEventList, event, WITHIN_COMPARATOR)) >= 0) {
                ITimeEvent current = this.fZoomedEventList.get(index);
                if (!(current instanceof NullTimeEvent)) {
                    return;
                }
                if (current.getTime() == event.getTime()) {
                    this.fZoomedEventList.set(index++, event);
                } else if (current.getTime() < event.getTime()) {
                    this.fZoomedEventList.set(index++, new NullTimeEvent(this, current.getTime(), event.getTime() - current.getTime()));
                    this.fZoomedEventList.add(index++, event);
                }
                long eventEndTime = event.getTime() + event.getDuration();
                long currentEndTime = current.getTime() + current.getDuration();
                if (eventEndTime < currentEndTime) {
                    this.fZoomedEventList.add(index, new NullTimeEvent(this, eventEndTime + 1L, currentEndTime - eventEndTime));
                }
            } else if ((index = -index + 1) < this.fZoomedEventList.size()) {
                this.fZoomedEventList.add(index, event);
            } else {
                this.fZoomedEventList.add(event);
            }
            this.updateEntryBounds(event);
            long l = first = this.fZoomedEventList.isEmpty() ? start : this.fZoomedEventList.get(0).getTime();
            if (start < first) {
                this.fZoomedEventList.add(0, new NullTimeEvent(this, start, first - start));
            }
            long l2 = last = this.fZoomedEventList.isEmpty() ? end : this.fZoomedEventList.get(this.fZoomedEventList.size() - 1).getTime() + this.fZoomedEventList.get(this.fZoomedEventList.size() - 1).getDuration();
            if (end > last) {
                this.fZoomedEventList.add(new NullTimeEvent(this, last, end - last));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateEntryBounds(ITimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return;
        }
        long start = event.getTime();
        long newStart = this.getStartTime() == -1L ? start : Long.min(start, this.getStartTime());
        long end = start + event.getDuration();
        long newEnd = this.getEndTime() == -1L ? end : Long.max(end, this.getEndTime());
        this.fStartTime = newStart;
        this.fEndTime = newEnd;
    }

    public synchronized void addChild(@NonNull TimeGraphEntry child) {
        if (this.fComparator == null) {
            this.addChild(this.fChildren.size(), child);
        } else {
            int i = Collections.binarySearch(this.fChildren, child, this.fComparator);
            if (i >= 0) {
                ++i;
                while (i < this.fChildren.size() && this.fComparator.compare(child, this.fChildren.get(i)) == 0) {
                    ++i;
                }
            } else {
                i = -i - 1;
            }
            this.addChild(i, child);
        }
    }

    public synchronized void addChild(int index, @NonNull TimeGraphEntry child) {
        if (child.getParent() == this) {
            return;
        }
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        child.setParent(this);
        this.fChildren.add(index, child);
    }

    public synchronized void removeChild(@NonNull TimeGraphEntry child) {
        if (child.getParent() == this) {
            child.setParent(null);
        }
        this.fChildren.remove(child);
    }

    public synchronized void sortChildren(Comparator<ITimeGraphEntry> comparator) {
        this.fComparator = comparator;
        if (comparator == null || this.fChildren.isEmpty()) {
            return;
        }
        ArrayList<@NonNull TimeGraphEntry> copy = new ArrayList<TimeGraphEntry>(this.fChildren);
        copy.sort(comparator);
        this.fChildren.clear();
        this.fChildren.addAll(copy);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.fModel.getLabels()) + ")";
    }

    @Override
    public boolean matches(@NonNull Pattern pattern) {
        return pattern.matcher(this.fModel.getName()).find();
    }

    public Sampling getSampling() {
        return this.fSampling;
    }

    public void setSampling(Sampling sampling) {
        this.fSampling = sampling;
    }

    public @NonNull ITmfTreeDataModel getEntryModel() {
        return this.fModel;
    }

    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        if (this.fModel instanceof ICoreElementResolver) {
            return ((ICoreElementResolver)this.fModel).getMetadata();
        }
        return ImmutableMultimap.of();
    }

    public void updateModel(@NonNull TimeGraphEntryModel model) {
        if (this.fModel.getId() != model.getId()) {
            throw new IllegalArgumentException("TimeGraphEntry should be updated with a TimeGraphEntryModel with the same id.");
        }
        this.fModel = model;
        this.fStartTime = model.getStartTime();
        this.fEndTime = model.getEndTime();
    }

    public void updateModel(@NonNull ITmfTreeDataModel model) {
        if (this.fModel.getId() != model.getId()) {
            throw new IllegalArgumentException("TimeGraphEntry should be updated with a TimeGraphEntryModel with the same id.");
        }
        this.fModel = model;
    }

    public boolean hasZoomedEvents() {
        int i = 0;
        while (i < this.fZoomedEventList.size()) {
            if (!(this.fZoomedEventList.get(i) instanceof NullTimeEvent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class Sampling {
        private final long fZoomStart;
        private final long fZoomEnd;
        private final long fResolution;
        private final @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> fPredicates;

        public Sampling(long zoomStart, long zoomEnd, long resolution) {
            this.fZoomStart = zoomStart;
            this.fZoomEnd = zoomEnd;
            this.fResolution = resolution;
            this.fPredicates = Collections.emptyMap();
        }

        public Sampling(long zoomStart, long zoomEnd, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, long resolution) {
            this.fZoomStart = zoomStart;
            this.fZoomEnd = zoomEnd;
            this.fResolution = resolution;
            this.fPredicates = predicates;
        }

        public int hashCode() {
            return Objects.hash(this.fZoomStart, this.fZoomEnd, this.fResolution);
        }

        public boolean equals(Object arg0) {
            if (arg0 == this) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0 instanceof Sampling) {
                Sampling other = (Sampling)arg0;
                return this.fZoomStart == other.fZoomStart && this.fZoomEnd == other.fZoomEnd && this.fResolution == other.fResolution && this.fPredicates.equals(other.fPredicates);
            }
            return false;
        }
    }
}

