/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.MathUtil;

public abstract class MultiLevelSkipListWriter {
    protected final int numberOfSkipLevels;
    private final int skipInterval;
    private final int skipMultiplier;
    private ByteBuffersDataOutput[] skipBuffer;

    protected MultiLevelSkipListWriter(int skipInterval, int skipMultiplier, int maxSkipLevels, int df) {
        this.skipInterval = skipInterval;
        this.skipMultiplier = skipMultiplier;
        int numberOfSkipLevels = df <= skipInterval ? 1 : 1 + MathUtil.log(df / skipInterval, skipMultiplier);
        if (numberOfSkipLevels > maxSkipLevels) {
            numberOfSkipLevels = maxSkipLevels;
        }
        this.numberOfSkipLevels = numberOfSkipLevels;
    }

    protected MultiLevelSkipListWriter(int skipInterval, int maxSkipLevels, int df) {
        this(skipInterval, skipInterval, maxSkipLevels, df);
    }

    protected void init() {
        this.skipBuffer = new ByteBuffersDataOutput[this.numberOfSkipLevels];
        for (int i = 0; i < this.numberOfSkipLevels; ++i) {
            this.skipBuffer[i] = ByteBuffersDataOutput.newResettableInstance();
        }
    }

    protected void resetSkip() {
        if (this.skipBuffer == null) {
            this.init();
        } else {
            for (int i = 0; i < this.skipBuffer.length; ++i) {
                this.skipBuffer[i].reset();
            }
        }
    }

    protected abstract void writeSkipData(int var1, DataOutput var2) throws IOException;

    public void bufferSkip(int df) throws IOException {
        assert (df % this.skipInterval == 0);
        int numLevels = 1;
        df /= this.skipInterval;
        while (df % this.skipMultiplier == 0 && numLevels < this.numberOfSkipLevels) {
            ++numLevels;
            df /= this.skipMultiplier;
        }
        long childPointer = 0L;
        for (int level = 0; level < numLevels; ++level) {
            this.writeSkipData(level, this.skipBuffer[level]);
            long newChildPointer = this.skipBuffer[level].size();
            if (level != 0) {
                this.writeChildPointer(childPointer, this.skipBuffer[level]);
            }
            childPointer = newChildPointer;
        }
    }

    public long writeSkip(IndexOutput output) throws IOException {
        long skipPointer = output.getFilePointer();
        if (this.skipBuffer == null || this.skipBuffer.length == 0) {
            return skipPointer;
        }
        for (int level = this.numberOfSkipLevels - 1; level > 0; --level) {
            long length = this.skipBuffer[level].size();
            if (length <= 0L) continue;
            this.writeLevelLength(length, output);
            this.skipBuffer[level].copyTo(output);
        }
        this.skipBuffer[0].copyTo(output);
        return skipPointer;
    }

    protected void writeLevelLength(long levelLength, IndexOutput output) throws IOException {
        output.writeVLong(levelLength);
    }

    protected void writeChildPointer(long childPointer, DataOutput skipBuffer) throws IOException {
        skipBuffer.writeVLong(childPointer);
    }
}

