/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class AsynchronousSchedulingRuleFactory {
    private static AsynchronousSchedulingRuleFactory fgFactory = null;

    private AsynchronousSchedulingRuleFactory() {
    }

    public static AsynchronousSchedulingRuleFactory getDefault() {
        if (fgFactory == null) {
            fgFactory = new AsynchronousSchedulingRuleFactory();
        }
        return fgFactory;
    }

    public ISchedulingRule newSerialRule() {
        return new SerialRule();
    }

    public ISchedulingRule newSerialPerObjectRule(Object lock) {
        return new SerialPerObjectRule(lock);
    }

    static class SerialPerObjectRule
    implements ISchedulingRule {
        private Object fObject = null;

        public SerialPerObjectRule(Object lock) {
            this.fObject = lock;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof SerialPerObjectRule) {
                SerialPerObjectRule vup = (SerialPerObjectRule)rule;
                return this.fObject == vup.fObject;
            }
            return false;
        }
    }

    static class SerialRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SerialRule;
        }
    }
}

