/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.core.DefaultFileModificationValidator;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DefaultUIFileModificationValidator
extends DefaultFileModificationValidator {
    public IStatus validateEdit(IFile[] allFiles, FileModificationValidationContext context) {
        IFile[] readOnlyFiles = this.getReadOnlyFiles(allFiles);
        if (readOnlyFiles.length > 0 && context != null) {
            Shell shell = this.getShell(context);
            boolean[] ok = new boolean[1];
            if (readOnlyFiles.length == 1) {
                DefaultUIFileModificationValidator.syncExec(() -> {
                    boolean bl = MessageDialog.openQuestion((Shell)shell, (String)TeamUIMessages.DefaultUIFileModificationValidator_3, (String)NLS.bind((String)TeamUIMessages.DefaultUIFileModificationValidator_4, (Object[])new String[]{readOnlyFiles[0].getFullPath().toString()}));
                });
            } else {
                DefaultUIFileModificationValidator.syncExec(() -> {
                    boolean bl = FileListDialog.openQuestion(shell, readOnlyFiles);
                });
            }
            if (ok[0]) {
                this.setWritable(readOnlyFiles);
            }
        } else if (readOnlyFiles.length > 0 && context == null && this.isMakeWrittableWhenContextNotProvided()) {
            this.setWritable(readOnlyFiles);
        }
        return this.getStatus(readOnlyFiles);
    }

    private Shell getShell(FileModificationValidationContext context) {
        if (context.getShell() != null) {
            return (Shell)context.getShell();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    private static void syncExec(Runnable runnable) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(runnable);
    }

    public IStatus validateSave(IFile file) {
        if (file.isReadOnly() && this.isMakeWrittableWhenContextNotProvided()) {
            IFile[] readOnlyFiles = new IFile[]{file};
            this.setWritable(readOnlyFiles);
            return this.getStatus(readOnlyFiles);
        }
        return this.getDefaultStatus(file);
    }

    private boolean isMakeWrittableWhenContextNotProvided() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.validate_edit_with_no_context");
    }

    private IFile[] getReadOnlyFiles(IFile[] files) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.isReadOnly()) {
                result.add(file);
            }
            ++n2;
        }
        return result.toArray(new IFile[result.size()]);
    }

    protected IStatus setWritable(IFile[] files) {
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            ResourceAttributes attributes = file.getResourceAttributes();
            if (attributes != null) {
                attributes.setReadOnly(false);
            }
            try {
                file.setResourceAttributes(attributes);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static class FileListDialog
    extends DetailsDialog {
        private final IFile[] files;

        public static boolean openQuestion(Shell shell, IFile[] files) {
            FileListDialog dialog = new FileListDialog(shell, files);
            int code = dialog.open();
            return code == 0;
        }

        public FileListDialog(Shell parentShell, IFile[] files) {
            super(parentShell, TeamUIMessages.DefaultUIFileModificationValidator_0);
            this.files = files;
            this.setImageKey("dialog_warning_image");
        }

        @Override
        protected void createMainDialogArea(Composite parent) {
            this.createWrappingLabel(parent, TeamUIMessages.DefaultUIFileModificationValidator_1);
        }

        @Override
        protected Composite createDropDownDialogArea(Composite parent) {
            Composite composite = this.createComposite(parent);
            this.createWrappingLabel(composite, TeamUIMessages.DefaultUIFileModificationValidator_2);
            List fileList = new List(composite, 2818);
            GridData data = new GridData();
            data.heightHint = 75;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            fileList.setLayoutData((Object)data);
            fileList.setFont(parent.getFont());
            IFile[] iFileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                fileList.add(file.getFullPath().toString());
                ++n2;
            }
            return composite;
        }

        @Override
        protected void updateEnablements() {
        }

        @Override
        protected boolean includeCancelButton() {
            return false;
        }

        @Override
        protected boolean includeOkButton() {
            return false;
        }

        @Override
        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            super.createButtonsForButtonBar(parent);
        }

        @Override
        protected void buttonPressed(int id) {
            if (2 == id) {
                this.okPressed();
            } else if (3 == id) {
                this.cancelPressed();
            } else {
                super.buttonPressed(id);
            }
        }
    }
}

