/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.EditionHistoryPage;
import org.eclipse.team.internal.ui.history.GenericHistoryDropAdapter;
import org.eclipse.team.internal.ui.history.GenericHistoryViewDefaultPage;
import org.eclipse.team.internal.ui.history.HistoryPageSourceWorkbenchPart;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.history.ElementLocalHistoryPageSource;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;

public class GenericHistoryView
extends PageBookView
implements IHistoryView,
IPropertyChangeListener,
IShowInTarget {
    private static final String HISTORY_VIEW_GROUP = "org.eclipse.team.ui.historyView";
    private static final String NAVIGATION_GROUP = "org.eclipse.team.ui.navigation";
    private static final int MAX_NAVIGATION_HISTORY_ENTRIES = 15;
    private Action refreshAction;
    private Action linkWithEditorAction;
    private Action pinAction;
    private NavigationHistoryAction navigateAction;
    DropTarget dropTarget;
    GenericHistoryDropAdapter dropAdapter;
    NavigationHistory navigationHistory = new NavigationHistory();
    private Object lastSelectedElement;
    private final ISelectionListener selectionListener = new ISelectionListener(){
        private boolean isUpdatingSelection = false;

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (this.isUpdatingSelection) {
                return;
            }
            try {
                this.isUpdatingSelection = true;
                if (GenericHistoryView.this == part) {
                    return;
                }
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structSelection = (IStructuredSelection)selection;
                    GenericHistoryView.this.lastSelectedElement = structSelection.getFirstElement();
                    if (!GenericHistoryView.this.isLinkingEnabled() || !GenericHistoryView.this.checkIfPageIsVisible()) {
                        return;
                    }
                    GenericHistoryView.this.showLastSelectedElement();
                }
            }
            finally {
                this.isUpdatingSelection = false;
            }
        }
    };
    private boolean linkingEnabled;
    private boolean viewPinned;

    static boolean sameSource(IHistoryPageSource source1, IHistoryPageSource source2) {
        return Objects.equals(source1, source2);
    }

    private boolean matches(IPage page, Object object, IHistoryPageSource pageSource) {
        Object input;
        if (page instanceof IHistoryPage && (input = ((IHistoryPage)page).getInput()) != null) {
            return input.equals(object) && GenericHistoryView.sameSource(this.getPageSourceFor(object, pageSource), this.getCurrentPageSource());
        }
        return false;
    }

    private IHistoryPageSource getCurrentPageSource() {
        IWorkbenchPart part = this.getCurrentContributingPart();
        if (part instanceof HistoryPageSourceWorkbenchPart) {
            return ((HistoryPageSourceWorkbenchPart)part).getSource();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorActivated((IEditorPart)part);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.lastSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (this.lastSelectedElement == null) {
            this.lastSelectedElement = this.getSite().getPage().getActiveEditor();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.linkingEnabled = TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_generichistory_view_linking");
        this.configureToolbars(this.getViewSite().getActionBars());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.initDragAndDrop();
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
    }

    private void configureToolbars(IActionBars actionBars) {
        this.pinAction = new Action(TeamUIMessages.GenericHistoryView_PinCurrentHistory, TeamUIPlugin.getImageDescriptor("elcl16/pin.png")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.linkWithEditorAction.setChecked(false);
                    GenericHistoryView.this.setLinkingEnabled(false);
                }
                GenericHistoryView.this.setViewPinned(this.isChecked());
            }
        };
        this.pinAction.setChecked(this.isViewPinned());
        this.pinAction.setToolTipText(TeamUIMessages.GenericHistoryView_0);
        this.refreshAction = new Action(TeamUIMessages.GenericHistoryView_Refresh, TeamUIPlugin.getImageDescriptor("elcl16/refresh.png")){

            public void run() {
                GenericHistoryView.this.getHistoryPage().refresh();
            }
        };
        this.refreshAction.setToolTipText(TeamUIMessages.GenericHistoryView_RefreshTooltip);
        this.refreshAction.setEnabled(true);
        this.linkWithEditorAction = new Action(TeamUIMessages.GenericHistoryView_LinkWithEditor, TeamUIPlugin.getImageDescriptor("elcl16/synced.png")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.pinAction.setChecked(false);
                    GenericHistoryView.this.setViewPinned(false);
                }
                GenericHistoryView.this.setLinkingEnabled(GenericHistoryView.this.isViewPinned() ? false : this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingEnabled());
        this.linkWithEditorAction.setToolTipText(TeamUIMessages.GenericHistoryView_LinkWithTooltip);
        this.navigateAction = new NavigationHistoryAction();
        Utils.initAction((IAction)this.navigateAction, "action.previousHistory.");
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator(HISTORY_VIEW_GROUP));
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.refreshAction);
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.linkWithEditorAction);
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.pinAction);
        tbm.add((IContributionItem)new Separator(NAVIGATION_GROUP));
        tbm.appendToGroup(NAVIGATION_GROUP, (IAction)this.navigateAction);
        tbm.update(false);
    }

    boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("pref_generichistory_view_linking", enabled);
        if (enabled) {
            this.showLastSelectedElement();
        }
    }

    void setViewPinned(boolean pinned) {
        this.viewPinned = pinned;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), PluginTransfer.getInstance()};
        this.dropTarget = new DropTarget((Control)this.getPageBook(), ops);
        this.dropTarget.setTransfer(transfers);
        this.dropAdapter = new GenericHistoryDropAdapter(this);
        this.dropTarget.addDropListener((DropTargetListener)this.dropAdapter);
    }

    public void setFocus() {
        if (this.isLinkingEnabled() && this.lastSelectedElement != null) {
            this.showLastSelectedElement();
        }
        this.getCurrentPage().setFocus();
    }

    private void showLastSelectedElement() {
        if (this.lastSelectedElement != null) {
            if (this.lastSelectedElement instanceof IEditorPart) {
                this.editorActivated((IEditorPart)this.lastSelectedElement);
            } else {
                Object resource;
                if (this.lastSelectedElement instanceof SyncInfoModelElement) {
                    SyncInfoModelElement syncInfoModelElement = (SyncInfoModelElement)this.lastSelectedElement;
                    resource = syncInfoModelElement.getSyncInfo().getLocal();
                } else {
                    resource = Adapters.adapt((Object)this.lastSelectedElement, IResource.class);
                }
                if (resource != null) {
                    this.showHistoryPageFor(resource, false, false, null);
                } else {
                    this.showHistoryPageFor(this.lastSelectedElement, false, false, null);
                }
            }
            this.lastSelectedElement = null;
        }
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.addNavigationHistoryEntry();
    }

    private void addNavigationHistoryEntry() {
        Object input;
        if (this.getCurrentPage() != null && (input = this.getHistoryPage().getInput()) != null) {
            this.navigationHistory.addEntry(input, this.getHistoryPage().getName(), this.getPageSourceFor(input, null));
        }
    }

    @Override
    public IHistoryPage showHistoryFor(Object object, boolean force) {
        return this.showHistoryPageFor(object, true, force, null);
    }

    public IHistoryPage showHistoryPageFor(Object object, boolean refresh, boolean force, IHistoryPageSource pageSource) {
        this.lastSelectedElement = null;
        if (Policy.DEBUG_HISTORY) {
            String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
            System.out.println(time + ": GenericHistoryView#showHistoryPageFor, the object to show is: " + String.valueOf(object));
        }
        if (!this.checkIfPageIsVisible()) {
            return null;
        }
        if ((pageSource = this.getPageSourceFor(object, pageSource)) == null || !pageSource.canShowHistoryFor(object)) {
            return null;
        }
        IHistoryPage existingPage = this.checkForExistingPage(object, refresh, force, pageSource);
        if (existingPage != null) {
            return existingPage;
        }
        if (this.isViewPinned() && !force) {
            return this.handlePinnedView(object, refresh, pageSource);
        }
        HistoryPageSourceWorkbenchPart part = new HistoryPageSourceWorkbenchPart(object, pageSource, (IWorkbenchPartSite)this.getViewSite());
        super.partActivated((IWorkbenchPart)part);
        if (Policy.DEBUG_HISTORY) {
            String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
            System.out.println(time + ": GenericHistoryView#showHistoryPageFor, the page showing the history is: " + String.valueOf(this.getHistoryPage()));
        }
        return this.getHistoryPage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PageBookView.PageRec getPageRec(IWorkbenchPart part) {
        PageBookView.PageRec rec = super.getPageRec(part);
        if (rec == null || !(part instanceof HistoryPageSourceWorkbenchPart)) return rec;
        IHistoryPage historyPage = (IHistoryPage)rec.page;
        HistoryPageSourceWorkbenchPart p = (HistoryPageSourceWorkbenchPart)part;
        Object newInput = p.getObject();
        if (!historyPage.isValidInput(newInput)) {
            if (!(historyPage instanceof EditionHistoryPage)) return null;
            ((EditionHistoryPage)historyPage).setInput(((ElementLocalHistoryPageSource)p.getSource()).internalGetFile(newInput), newInput);
        } else {
            historyPage.setInput(newInput);
        }
        ((HistoryPage)historyPage).setHistoryView(this);
        this.setContentDescription(historyPage.getName());
        return rec;
    }

    private IHistoryPageSource getPageSourceFor(Object object, IHistoryPageSource pageSource) {
        IHistoryPageSource source;
        if (object == null || pageSource != null) {
            return pageSource;
        }
        IResource resource = Utils.getResource(object);
        if (resource == null) {
            return (IHistoryPageSource)Adapters.adapt((Object)object, IHistoryPageSource.class);
        }
        if (resource.getProject() == null) {
            return null;
        }
        RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (teamProvider == null) {
            return LocalHistoryPageSource.getInstance();
        }
        IFileHistoryProvider fileHistory = teamProvider.getFileHistoryProvider();
        if (fileHistory != null && (source = (IHistoryPageSource)Adapters.adapt((Object)fileHistory, IHistoryPageSource.class)) != null) {
            return source;
        }
        return (IHistoryPageSource)Adapters.adapt((Object)teamProvider, IHistoryPageSource.class);
    }

    private IHistoryPage handlePinnedView(Object object, boolean refresh, IHistoryPageSource source) {
        try {
            GenericHistoryView historyView = this.findUnpinnedHistoryView();
            if (historyView != null) {
                this.getSite().getPage().activate((IWorkbenchPart)historyView);
                return historyView.showHistoryPageFor(object, refresh, true, source);
            }
            String id = "org.eclipse.team.ui.GenericHistoryView" + System.currentTimeMillis();
            IViewPart view = this.getSite().getPage().showView("org.eclipse.team.ui.GenericHistoryView", id, 3);
            this.getSite().getPage().activate((IWorkbenchPart)view);
            if (view instanceof GenericHistoryView) {
                return ((GenericHistoryView)view).showHistoryPageFor(object, refresh, true, source);
            }
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    private IHistoryPage checkForExistingPage(Object object, boolean refresh, boolean thisViewOnly, IHistoryPageSource pageSource) {
        IHistoryPage tempPage = this.checkForExistingPage(object, refresh, pageSource);
        if (tempPage != null || thisViewOnly) {
            return tempPage;
        }
        tempPage = this.searchHistoryViewsForObject(object, refresh, pageSource);
        if (tempPage != null) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)tempPage.getHistoryView());
        }
        return tempPage;
    }

    private IHistoryPage checkForExistingPage(Object object, boolean refresh, IHistoryPageSource pageSource) {
        if (this.getCurrentPage() != null && this.matches(this.getCurrentPage(), object, pageSource)) {
            IHistoryPage tempPage = (IHistoryPage)this.getCurrentPage();
            if (refresh) {
                tempPage.refresh();
            }
            return tempPage;
        }
        return null;
    }

    private IHistoryPage searchHistoryViewsForObject(Object object, boolean refresh, IHistoryPageSource pageSource) {
        IViewReference[] historyViews;
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] iViewReferenceArray = historyViews = page.getViewReferences();
        int n = historyViews.length;
        int n2 = 0;
        while (n2 < n) {
            GenericHistoryView ghv;
            IHistoryPage historyPage;
            IViewPart historyView;
            IViewReference h = iViewReferenceArray[n2];
            if (h.getId().equals("org.eclipse.team.ui.GenericHistoryView") && (historyView = h.getView(true)) instanceof GenericHistoryView && (historyPage = (ghv = (GenericHistoryView)historyView).checkForExistingPage(object, refresh, pageSource)) != null) {
                return historyPage;
            }
            ++n2;
        }
        return null;
    }

    public GenericHistoryView findUnpinnedHistoryView() {
        IViewReference[] historyViews;
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] iViewReferenceArray = historyViews = page.getViewReferences();
        int n = historyViews.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart historyView;
            IViewReference h = iViewReferenceArray[n2];
            if (h.getId().equals("org.eclipse.team.ui.GenericHistoryView") && !((GenericHistoryView)(historyView = h.getView(false))).isViewPinned()) {
                return (GenericHistoryView)historyView;
            }
            ++n2;
        }
        return null;
    }

    boolean isViewPinned() {
        return this.viewPinned;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        HistoryPageSourceWorkbenchPart p = (HistoryPageSourceWorkbenchPart)part;
        IHistoryPageSource source = p.getSource();
        Page page = source.createPage(p.getObject());
        if (page != null) {
            this.initPage((IPageBookViewPage)page);
            IHistoryPage historyPage = (IHistoryPage)page;
            historyPage.addPropertyChangeListener(this);
            historyPage.setSite(new WorkbenchHistoryPageSite(this, page.getSite()));
            page.createControl((Composite)this.getPageBook());
            historyPage.setInput(p.getObject());
            ((HistoryPage)page).setHistoryView(this);
            this.setContentDescription(historyPage.getName());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        if (page instanceof IHistoryPage) {
            ((IHistoryPage)page).removePropertyChangeListener(this);
        }
        page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        if (part instanceof HistoryPageSourceWorkbenchPart) {
            HistoryPageSourceWorkbenchPart p = (HistoryPageSourceWorkbenchPart)part;
            Object object = p.getObject();
            return p.getSource().canShowHistoryFor(object);
        }
        return false;
    }

    protected IPage createDefaultPage(PageBook book) {
        GenericHistoryViewDefaultPage page = new GenericHistoryViewDefaultPage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    protected void editorActivated(IEditorPart editor) {
        this.lastSelectedElement = editor;
        if (editor == null || !this.isLinkingEnabled() || !this.checkIfPageIsVisible() || this.isViewPinned()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        if (file != null) {
            this.showHistory(file);
        } else {
            Object pageSource = Adapters.adapt((Object)input, IHistoryPageSource.class);
            if (pageSource != null) {
                this.showHistory(input);
            }
        }
    }

    private boolean checkIfPageIsVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.removeDropListener((DropTargetListener)this.dropAdapter);
        }
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        this.navigateAction.dispose();
        super.dispose();
    }

    @Override
    public IHistoryPage showHistoryFor(Object object) {
        return this.showHistoryFor(object, false);
    }

    @Override
    public IHistoryPage getHistoryPage() {
        return (IHistoryPage)this.getCurrentPage();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.getCurrentPage()) {
            if (event.getProperty().equals("org.eclipse.team.ui.name")) {
                Display.getDefault().asyncExec(() -> {
                    IHistoryPage historyPage = this.getHistoryPage();
                    this.setContentDescription(historyPage.getName());
                    this.navigationHistory.updateName(historyPage, this.getPageSourceFor(historyPage.getInput(), null));
                });
            } else {
                event.getProperty().equals("org.eclipse.team.ui.description");
            }
        }
    }

    public IHistoryView findAppropriateHistoryViewFor(Object input, IHistoryPageSource pageSource) {
        IHistoryPage page = this.searchHistoryViewsForObject(input, false, pageSource);
        if (page != null) {
            return page.getHistoryView();
        }
        return this.findUnpinnedHistoryView();
    }

    private void showHistory(Object object) {
        if (this.getHistoryPage().getInput() != object) {
            this.showHistoryPageFor(object, false, false, null);
        }
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && this.showHistoryFor(ss.getFirstElement()) != null) {
            return true;
        }
        if (context.getInput() != null) {
            return this.showHistoryFor(context.getInput()) != null;
        }
        return false;
    }

    static abstract class MenuCreator
    implements IMenuCreator {
        private MenuManager menuManager;

        MenuCreator() {
        }

        public void dispose() {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }

        public Menu getMenu(Control parent) {
            Menu fMenu = null;
            if (this.menuManager == null) {
                this.menuManager = new MenuManager();
                fMenu = this.menuManager.createContextMenu(parent);
                IAction[] actions = this.getDropDownActions();
                int i = actions.length - 1;
                while (i >= 0) {
                    IAction action = actions[i];
                    this.menuManager.add(action);
                    --i;
                }
                this.updateMenuState();
            } else {
                fMenu = this.menuManager.getMenu();
            }
            return fMenu;
        }

        protected void updateMenuState() {
            if (this.menuManager != null) {
                this.menuManager.update(true);
            }
        }

        protected abstract IAction[] getDropDownActions();

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void rebuildMenu() {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }
    }

    class NavigationHistory {
        List<NavigationHistoryEntry> history = new ArrayList<NavigationHistoryEntry>();
        int position;
        private boolean navigating;

        NavigationHistory() {
        }

        public int size() {
            return this.history.size();
        }

        public void gotoPreviousEntry() {
            if (this.position > 0) {
                --this.position;
                this.gotoEntry();
            } else {
                this.position = this.history.size() - 1;
                this.gotoEntry();
            }
        }

        private void gotoEntry() {
            try {
                this.navigating = true;
                NavigationHistoryEntry currentEntry = this.getCurrentEntry();
                GenericHistoryView.this.showHistoryPageFor(currentEntry.object, true, true, currentEntry.source);
            }
            finally {
                this.navigating = false;
            }
        }

        private NavigationHistoryEntry getCurrentEntry() {
            return this.history.get(this.position);
        }

        public void addEntry(Object object, String name, IHistoryPageSource source) {
            if (!this.navigating) {
                NavigationHistoryEntry navigationHistoryEntry = new NavigationHistoryEntry(object, name, source);
                if (this.history.contains(navigationHistoryEntry)) {
                    this.history.remove(navigationHistoryEntry);
                }
                this.history.add(navigationHistoryEntry);
                if (this.history.size() > 15) {
                    this.history.remove(0);
                }
                this.position = this.history.size() - 1;
            }
            GenericHistoryView.this.navigateAction.update();
        }

        public NavigationHistoryEntry[] getEntries() {
            return this.history.toArray(new NavigationHistoryEntry[this.history.size()]);
        }

        private NavigationHistoryEntry getEntry(int i) {
            return this.history.get(i);
        }

        public void gotoEntry(NavigationHistoryEntry navigationHistoryEntry) {
            this.position = this.history.indexOf(navigationHistoryEntry);
            this.gotoEntry();
        }

        public NavigationHistoryEntry getPreviousEntry() {
            int next = this.position - 1;
            if (next < 0) {
                next = this.size() - 1;
            }
            return this.getEntry(next);
        }

        public void updateName(IHistoryPage historyPage, IHistoryPageSource pageSource) {
            NavigationHistoryEntry[] historyEntries;
            NavigationHistoryEntry[] navigationHistoryEntryArray = historyEntries = this.getEntries();
            int n = historyEntries.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationHistoryEntry historyEntry = navigationHistoryEntryArray[n2];
                if (historyEntry.matches(historyPage, pageSource)) {
                    historyEntry.name = historyPage.getName();
                }
                ++n2;
            }
            GenericHistoryView.this.navigateAction.update();
        }
    }

    class NavigationHistoryAction
    extends Action {
        private MenuCreator menuCreator = new MenuCreator(){

            @Override
            protected IAction[] getDropDownActions() {
                return NavigationHistoryAction.this.getActions();
            }
        };
        private IAction[] actions;

        public NavigationHistoryAction() {
            this.setMenuCreator(this.menuCreator);
            this.update();
        }

        private IAction[] createActions() {
            NavigationHistoryEntry[] entries = this.getDropDownEntries();
            ArrayList<NavigationHistoryEntryAction> actions = new ArrayList<NavigationHistoryEntryAction>();
            NavigationHistoryEntry[] navigationHistoryEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationHistoryEntry navigationHistoryEntry = navigationHistoryEntryArray[n2];
                actions.add(new NavigationHistoryEntryAction(navigationHistoryEntry));
                ++n2;
            }
            return actions.toArray(new IAction[actions.size()]);
        }

        protected NavigationHistoryEntry[] getDropDownEntries() {
            return GenericHistoryView.this.navigationHistory.getEntries();
        }

        public void run() {
            GenericHistoryView.this.navigationHistory.gotoPreviousEntry();
            this.updateCheckState();
        }

        public void update() {
            this.setEnabled(GenericHistoryView.this.navigationHistory.size() > 1);
            if (this.isEnabled()) {
                this.setToolTipText(NLS.bind((String)TeamUIMessages.GenericHistoryView_1, (Object)GenericHistoryView.this.navigationHistory.getPreviousEntry().name));
            } else {
                this.setToolTipText(TeamUIMessages.GenericHistoryView_2);
            }
            this.actions = null;
            this.menuCreator.rebuildMenu();
            this.updateCheckState();
        }

        private void updateCheckState() {
            IAction[] actions;
            IAction[] iActionArray = actions = this.getActions();
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                if (action instanceof NavigationHistoryEntryAction) {
                    NavigationHistoryEntryAction a = (NavigationHistoryEntryAction)action;
                    a.update();
                }
                ++n2;
            }
            this.menuCreator.updateMenuState();
        }

        public void dispose() {
            this.menuCreator.dispose();
        }

        private IAction[] getActions() {
            if (this.actions == null) {
                this.actions = this.createActions();
            }
            return this.actions;
        }
    }

    static class NavigationHistoryEntry {
        Object object;
        String name;
        IHistoryPageSource source;

        public NavigationHistoryEntry(Object object, String name, IHistoryPageSource source) {
            this.object = object;
            this.name = name;
            this.source = source;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NavigationHistoryEntry) {
                NavigationHistoryEntry other = (NavigationHistoryEntry)obj;
                return other.object.equals(this.object) && GenericHistoryView.sameSource(this.source, other.source);
            }
            return false;
        }

        public boolean matches(IHistoryPage historyPage, IHistoryPageSource pageSource) {
            return this.object.equals(historyPage.getInput()) && GenericHistoryView.sameSource(this.source, pageSource);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    class NavigationHistoryEntryAction
    extends Action {
        private final NavigationHistoryEntry navigationHistoryEntry;

        public NavigationHistoryEntryAction(NavigationHistoryEntry navigationHistoryEntry) {
            super(navigationHistoryEntry.name);
            this.navigationHistoryEntry = navigationHistoryEntry;
        }

        public void run() {
            GenericHistoryView.this.navigationHistory.gotoEntry(this.navigationHistoryEntry);
            GenericHistoryView.this.navigateAction.updateCheckState();
        }

        public void update() {
            this.setChecked(GenericHistoryView.this.navigationHistory.getCurrentEntry() == this.navigationHistoryEntry);
        }
    }
}

