/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.util.KeyKind;
import org.eclipse.jdt.internal.core.util.KeyToSignature;

public final class BindingKey {
    private final String key;

    public BindingKey(String key) {
        this.key = key;
    }

    public static String createArrayTypeBindingKey(String typeKey, int arrayDimension) {
        StringBuilder buffer = new StringBuilder();
        while (arrayDimension-- > 0) {
            buffer.append('[');
        }
        buffer.append(typeKey);
        return buffer.toString();
    }

    public static String createParameterizedTypeBindingKey(String genericTypeKey, String[] argumentTypeKeys) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Signature.getTypeErasure(genericTypeKey));
        buffer.insert(buffer.length() - 1, '<');
        int i = 0;
        int length = argumentTypeKeys.length;
        while (i < length) {
            String argumentTypeKey = argumentTypeKeys[i];
            buffer.insert(buffer.length() - 1, argumentTypeKey);
            ++i;
        }
        buffer.insert(buffer.length() - 1, '>');
        return buffer.toString();
    }

    public static String createTypeBindingKey(String typeName) {
        return Signature.createTypeSignature(typeName.replace('.', '/'), true);
    }

    public static String createTypeVariableBindingKey(String typeVariableName, String declaringKey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(declaringKey);
        buffer.append(':');
        buffer.append('T');
        buffer.append(typeVariableName);
        buffer.append(';');
        return buffer.toString();
    }

    public static String createWilcardTypeBindingKey(String typeKey, char kind) {
        switch (kind) {
            case '*': {
                return "*";
            }
            case '-': {
                return "-" + typeKey;
            }
            case '+': {
                return "+" + typeKey;
            }
        }
        return null;
    }

    public static String createWildcardTypeBindingKey(String genericTypeKey, char boundKind, String boundTypeKey, int rank) {
        Object wildCardKey;
        switch (boundKind) {
            case '*': {
                wildCardKey = new String(TypeConstants.WILDCARD_STAR);
                break;
            }
            case '-': {
                wildCardKey = new String(TypeConstants.WILDCARD_MINUS) + boundTypeKey;
                break;
            }
            case '+': {
                wildCardKey = new String(TypeConstants.WILDCARD_PLUS) + boundTypeKey;
                break;
            }
            default: {
                return null;
            }
        }
        return genericTypeKey + "{" + rank + "}" + (String)wildCardKey;
    }

    public BindingKey getDeclaringType() {
        int end = this.key.lastIndexOf(46);
        if (end == -1 && (end = this.key.lastIndexOf(36)) == -1) {
            return null;
        }
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        if ((kind.flags & 0x10) != 0) {
            return null;
        }
        Object typeKey = this.key.substring(0, end);
        if (((String)typeKey).charAt(((String)typeKey).length() - 1) != ';') {
            typeKey = (String)typeKey + ";";
        }
        return new BindingKey((String)typeKey);
    }

    public String[] getThrownExceptions() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 3);
        keyToSignature.parse();
        return keyToSignature.getThrownExceptions();
    }

    public String[] getTypeArguments() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 1);
        keyToSignature.parse();
        return keyToSignature.getTypeArguments();
    }

    public boolean isRawType() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x100) != 0;
    }

    public boolean isParameterizedType() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x80) != 0;
    }

    public boolean isParameterizedMethod() {
        KeyKind kind = new KeyKind(this.key);
        kind.parse();
        return (kind.flags & 0x400) != 0;
    }

    public String toSignature() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 0);
        keyToSignature.parse();
        return keyToSignature.signature.toString();
    }

    public String toString() {
        return this.key;
    }
}

