/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callstack.provider;

import org.eclipse.tracecompass.analysis.profiling.core.tests.data.CallStackTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataBigCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataSmallCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CallStackDataProviderFactoryTest {
    private static CallStackTestData fTraceData1;
    private static CallStackTestData fTraceData2;
    private static TmfExperiment fExperiment;
    private static TmfExperiment fExperimentSingleTrace;
    private static CallStackDataProviderFactory fFactory;

    @BeforeClass
    public static void setup() {
        fTraceData1 = new TestDataSmallCallStack();
        fTraceData2 = new TestDataBigCallStack();
        TmfXmlTraceStub trace1 = (TmfXmlTraceStub)fTraceData1.getTrace();
        TmfXmlTraceStub trace2 = (TmfXmlTraceStub)fTraceData2.getTrace();
        CallStackAnalysisStub module = (CallStackAnalysisStub)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace1, CallStackAnalysisStub.class, (String)"org.eclipse.tracecompass.profiling.callstack.test");
        Assert.assertNotNull((Object)((Object)module));
        module = (CallStackAnalysisStub)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace2, CallStackAnalysisStub.class, (String)"org.eclipse.tracecompass.profiling.callstack.test");
        Assert.assertNotNull((Object)((Object)module));
        ITmfTrace[] traces = new ITmfTrace[]{trace1};
        fExperimentSingleTrace = new TmfExperiment(ITmfEvent.class, "experiment", traces, 1000, null);
        traces = new ITmfTrace[]{trace1, trace2};
        fExperiment = new TmfExperiment(ITmfEvent.class, "experiment", traces, 1000, null);
        fFactory = new CallStackDataProviderFactory();
    }

    @AfterClass
    public static void tearDown() {
        CallStackTestData[] traceData = new CallStackTestData[]{fTraceData1, fTraceData2};
        int i = 0;
        while (i < traceData.length) {
            if (traceData[i] != null) {
                traceData[i].dispose();
            }
            ++i;
        }
        TmfExperiment[] experiments = new TmfExperiment[]{fExperiment, fExperimentSingleTrace};
        int i2 = 0;
        while (i2 < traceData.length) {
            if (experiments[i2] != null) {
                experiments[i2].dispose();
            }
            ++i2;
        }
    }

    @Test
    public void testCreateProviderForTrace() {
        ITmfTrace trace = fTraceData1.getTrace();
        Assert.assertNotNull((Object)trace);
        ITmfTreeDataProvider dp = fFactory.createProvider(trace);
        Assert.assertNotNull((Object)dp);
        Assert.assertTrue((boolean)(dp instanceof CallStackDataProvider));
    }

    @Test
    public void testCreateProviderForExperiment() {
        Assert.assertNotNull((Object)fExperiment);
        ITmfTreeDataProvider dp = fFactory.createProvider((ITmfTrace)fExperiment);
        Assert.assertNotNull((Object)dp);
        TmfTimeGraphCompositeDataProvider compositeDp = (TmfTimeGraphCompositeDataProvider)dp;
        Assert.assertTrue((boolean)(dp instanceof TmfTimeGraphCompositeDataProvider));
        Assert.assertEquals((Object)"org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider", (Object)compositeDp.getId());
        Assert.assertNotNull((Object)fExperimentSingleTrace);
        dp = fFactory.createProvider((ITmfTrace)fExperimentSingleTrace);
        Assert.assertNotNull((Object)dp);
        Assert.assertTrue((boolean)(dp instanceof CallStackDataProvider));
    }
}

