/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCallSite;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.EdgeStateValue;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FunctionTidAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack.CallStackHostUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.instrumented.SymbolAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class InstrumentedCallStackAnalysis
extends TmfStateSystemAnalysisModule
implements IFlameChartProvider,
ICallGraphProvider {
    public static final String CALL_STACK = "CallStack";
    private @Nullable CallStackSeries fCallStacks;
    private final CallGraphAnalysis fCallGraph;
    private boolean fIsCallStackSeriesFinalized = false;
    private final ListenerList<IAnalysisProgressListener> fListeners = new ListenerList(1);
    private boolean fAutomaticCallgraph = true;

    protected InstrumentedCallStackAnalysis() {
        this.fCallGraph = new CallGraphAnalysis(this);
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!super.setTrace(trace)) {
            return false;
        }
        return this.fCallGraph.setTrace(trace);
    }

    public void setName(String name) {
        super.setName(name);
        this.fCallGraph.setName(name);
    }

    @Override
    public synchronized @Nullable CallStackSeries getCallStackSeries() {
        CallStackSeries callstacks = this.fCallStacks;
        ITmfStateSystem ss = this.getStateSystem();
        ITmfTrace trace = this.getTrace();
        if (ss == null || trace == null) {
            return null;
        }
        boolean isStateSystemBuilt = ss.waitUntilBuilt(0L);
        if (callstacks == null) {
            List<String[]> patterns = this.getPatterns();
            if (patterns.isEmpty()) {
                return null;
            }
            this.fCallStacks = callstacks = new CallStackSeries(ss, patterns, 0, "", this.getCallStackHostResolver(trace), this.getCallStackTidResolver());
        } else if (!this.fIsCallStackSeriesFinalized) {
            callstacks.updateRootGroup(this.getPatterns(), 0);
        }
        if (isStateSystemBuilt) {
            this.fIsCallStackSeriesFinalized = true;
        }
        return callstacks;
    }

    protected CallStackHostUtils.TraceHostIdResolver getCallStackHostResolver(ITmfTrace trace) {
        return new CallStackHostUtils.TraceHostIdResolver(trace);
    }

    protected @Nullable CallStackSeries.IThreadIdResolver getCallStackTidResolver() {
        return new CallStackSeries.AttributeValueThreadResolver(1);
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        this.fCallGraph.setId(this.getId());
        boolean ret = super.executeAnalysis(monitor);
        if (!ret) {
            return ret;
        }
        ISegmentStore<ISegment> segmentStore = this.getSegmentStore();
        if (segmentStore != null) {
            this.sendUpdate(segmentStore);
        }
        if (this.fAutomaticCallgraph) {
            this.fCallGraph.schedule();
        }
        return true;
    }

    public boolean waitForCompletion() {
        boolean waitForCompletion = super.waitForCompletion();
        if (this.fAutomaticCallgraph) {
            waitForCompletion &= this.fCallGraph.waitForCompletion();
        }
        return waitForCompletion;
    }

    public boolean waitForCompletion(IProgressMonitor monitor) {
        boolean waitForCompletion = super.waitForCompletion(monitor);
        if (this.fAutomaticCallgraph) {
            waitForCompletion &= this.fCallGraph.waitForCompletion(monitor);
        }
        return waitForCompletion;
    }

    /*
     * Exception decompiling
     */
    protected List<String[]> getPatterns() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> findCallStackPatterns(ITmfStateSystem ss, int quark) {
        LinkedList<String> patterns = new LinkedList<String>();
        int nCallStackChild = 0;
        if (ss.getNbAttributes() == 0) {
            return patterns;
        }
        List subQuarks = ss.getSubAttributes(quark, false);
        boolean isCallStack = false;
        List<Object> subPatterns = new LinkedList<String>();
        for (Integer subQuark : subQuarks) {
            if (ss.getAttributeName(subQuark.intValue()).equals(CALL_STACK)) {
                isCallStack = true;
                continue;
            }
            @NonNull LinkedList<String> neighbourSubPatterns = subPatterns;
            subPatterns = this.findCallStackPatterns(ss, subQuark);
            if (!subPatterns.isEmpty()) {
                ++nCallStackChild;
                InstrumentedCallStackAnalysis.mergeSubPatterns(subPatterns, neighbourSubPatterns);
                continue;
            }
            subPatterns = neighbourSubPatterns;
        }
        if (!subPatterns.isEmpty()) {
            patterns.addAll(subPatterns);
        }
        if (nCallStackChild > 0 || isCallStack) {
            patterns.push(ss.getAttributeName(quark));
        }
        return patterns;
    }

    private static void mergeSubPatterns(List<String> pattern1, List<String> pattern2) {
        if (!pattern2.isEmpty()) {
            int i = 0;
            while (i < Integer.max(pattern1.size(), pattern2.size())) {
                if (i > Integer.min(pattern1.size() - 1, pattern2.size() - 1)) {
                    if (i > pattern1.size() - 1) {
                        pattern1.add(pattern2.get(i));
                    }
                } else if (!pattern1.get(i).equals(pattern2.get(i))) {
                    pattern1.set(i, "*");
                }
                ++i;
            }
        }
    }

    @Override
    public @NonNull String getHostId() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return "";
        }
        return trace.getHostId();
    }

    public List<ITmfStateInterval> getLinks(long start, long end, IProgressMonitor monitor) {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        Collection<Integer> quarks = this.getEdgeQuarks();
        if (quarks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ITmfStateInterval> list = new ArrayList<ITmfStateInterval>();
        try {
            for (ITmfStateInterval interval : ss.query2D(quarks, start, end)) {
                Object value = interval.getValue();
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (!(value instanceof EdgeStateValue)) continue;
                list.add(interval);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph(start, end);
    }

    @Override
    public CallGraph getCallGraph() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph();
    }

    @Override
    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getGroupDescriptors();
    }

    @Override
    public String getTitle() {
        return this.fCallGraph.getTitle();
    }

    public void dispose() {
        super.dispose();
        this.fCallGraph.dispose();
    }

    @Override
    public AggregatedCallSite createCallSite(Object symbol) {
        return this.fCallGraph.createCallSite(symbol);
    }

    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        CallStackSeries series = this.getCallStackSeries();
        if (series == null) {
            return null;
        }
        return series;
    }

    public void addListener(IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        if (this.getCallStackTidResolver() != null) {
            return ImmutableList.of((Object)FunctionTidAspect.TID_ASPECT, (Object)SymbolAspect.SYMBOL_ASPECT);
        }
        return Collections.singletonList(SymbolAspect.SYMBOL_ASPECT);
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete((ISegmentStoreProvider)this, store);
        }
    }

    public void triggerAutomatically(boolean trigger) {
        this.fAutomaticCallgraph = trigger;
    }

    protected Collection<Integer> getEdgeQuarks() {
        return Collections.emptyList();
    }

    @Override
    public boolean isComplete() {
        if (!this.waitForInitialization()) {
            return true;
        }
        ITmfStateSystem stateSystem = this.getStateSystem();
        if (stateSystem == null) {
            throw new IllegalStateException("The initialiation is complete, so the state system must not be null");
        }
        return stateSystem.waitUntilBuilt(0L);
    }

    @Override
    public long getEnd() {
        if (!this.waitForInitialization()) {
            return Integer.MIN_VALUE;
        }
        ITmfStateSystem stateSystem = this.getStateSystem();
        if (stateSystem == null) {
            throw new IllegalStateException("The initialiation is complete, so the state system must not be null");
        }
        return stateSystem.getCurrentEndTime();
    }

    @Override
    public @NonNull List<String> getExtraDataSets() {
        return this.fCallGraph.getExtraDataSets();
    }

    @Override
    public IWeightedTreeProvider.MetricType getWeightType() {
        return this.fCallGraph.getWeightType();
    }

    @Override
    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return this.fCallGraph.getAdditionalMetrics();
    }

    @Override
    public String toDisplayString(AggregatedCallSite object) {
        return this.fCallGraph.toDisplayString(object);
    }

    @Override
    public Object getAdditionalMetric(AggregatedCallSite object, int metricIndex) {
        return this.fCallGraph.getAdditionalMetric(object, metricIndex);
    }

    @Override
    public IDataPalette getPalette() {
        this.fCallGraph.schedule();
        return this.fCallGraph.getPalette();
    }
}

