/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;

public class CallStackElement
implements ICallStackElement {
    public static final int DEFAULT_SYMBOL_KEY = -1;
    private final String fName;
    private final IWeightedTreeGroupDescriptor fDescriptor;
    private final @Nullable IWeightedTreeGroupDescriptor fNextDescriptor;
    private final Collection<ICallStackElement> fChildren = new ArrayList<ICallStackElement>();
    private @Nullable ICallStackElement fParent;
    private @Nullable ICallStackElement fSymbolKeyElement = null;

    public CallStackElement(String name, IWeightedTreeGroupDescriptor descriptor) {
        this(name, descriptor, null, null);
    }

    public CallStackElement(String name, IWeightedTreeGroupDescriptor descriptor, @Nullable IWeightedTreeGroupDescriptor nextGroup, @Nullable ICallStackElement parent) {
        this.fName = name;
        this.fDescriptor = descriptor;
        this.fParent = parent;
        this.fNextDescriptor = nextGroup;
        if (parent instanceof CallStackElement) {
            this.fSymbolKeyElement = ((CallStackElement)parent).fSymbolKeyElement;
        }
    }

    @Override
    public Collection<ICallStackElement> getChildrenElements() {
        return this.fChildren;
    }

    @Override
    public void addChild(ITree child) {
        if (!(child instanceof ICallStackElement)) {
            throw new IllegalArgumentException("The CallStackElement hierarchy does not support children of type " + child.getClass().getName());
        }
        this.fChildren.add((ICallStackElement)child);
        child.setParent(this);
    }

    @Override
    public void setParent(@Nullable ITree parent) {
        if (parent != null && !(parent instanceof ICallStackElement)) {
            throw new IllegalArgumentException("The CallStackElement hierarchy does not support parent of type " + parent.getClass().getName());
        }
        this.fParent = (ICallStackElement)parent;
    }

    @Override
    public IWeightedTreeGroupDescriptor getGroup() {
        return this.fDescriptor;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isLeaf() {
        return this.fNextDescriptor == null;
    }

    @Override
    public boolean isCallStack() {
        return this.isLeaf();
    }

    @Override
    public @Nullable IWeightedTreeGroupDescriptor getNextGroup() {
        return this.fNextDescriptor;
    }

    @Override
    public void setSymbolKeyElement(ICallStackElement element) {
        this.fSymbolKeyElement = element;
    }

    @Override
    public boolean isSymbolKeyElement() {
        return this.fSymbolKeyElement == this;
    }

    @Override
    public final int getSymbolKeyAt(long startTime) {
        int processId = -1;
        if (this.isSymbolKeyElement()) {
            return this.retrieveSymbolKeyAt(startTime);
        }
        ICallStackElement symbolKeyElement = this.fSymbolKeyElement;
        if (symbolKeyElement == null) {
            return processId;
        }
        return symbolKeyElement.getSymbolKeyAt(startTime);
    }

    protected int retrieveSymbolKeyAt(long time) {
        return -1;
    }

    @Override
    public @Nullable ICallStackElement getParentElement() {
        return this.fParent;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public @Nullable ITree getParent() {
        return this.getParentElement();
    }

    @Override
    public Collection<ITree> getChildren() {
        ArrayList<ITree> list = new ArrayList<ITree>();
        list.addAll(this.fChildren);
        return list;
    }

    @Override
    public CallStackElement copyElement() {
        return new CallStackElement(this.fName, this.fDescriptor, this.fNextDescriptor, null);
    }
}

