/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class CallStackHostUtils {
    private CallStackHostUtils() {
    }

    private static final class AttributeNameHostProvider
    implements IHostIdProvider {
        private final String fHostId;

        public AttributeNameHostProvider(ITmfStateSystem ss, int quark) {
            String host = "";
            try {
                host = ss.getAttributeName(quark);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.fHostId = host;
        }

        @Override
        public @NonNull String apply(Long time) {
            return this.fHostId;
        }
    }

    public static final class AttributeNameHostResolver
    implements IHostIdResolver {
        private int fLevel;

        public AttributeNameHostResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @NonNull IHostIdProvider apply(ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            ArrayList<InstrumentedCallStackElement> elements = new ArrayList<InstrumentedCallStackElement>();
            InstrumentedCallStackElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                throw new IllegalArgumentException("The host should never resolve to null, level " + this.fLevel + " is not available");
            }
            InstrumentedCallStackElement stackElement = (InstrumentedCallStackElement)elements.get(this.fLevel);
            return new AttributeNameHostProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    private static final class AttributeValueHostProvider
    implements IHostIdProvider {
        private final ITmfStateSystem fSs;
        private final int fQuark;
        private @Nullable ITmfStateInterval fInterval;
        private String fLastHostId = "";

        public AttributeValueHostProvider(ITmfStateSystem ss, int quark) {
            this.fSs = ss;
            this.fQuark = quark;
        }

        @Override
        public @NonNull String apply(Long time) {
            ITmfStateInterval interval = this.fInterval;
            String hostId = this.fLastHostId;
            if (interval != null && interval.intersects(time.longValue())) {
                return hostId;
            }
            try {
                interval = this.fSs.querySingleState(time.longValue(), this.fQuark);
                hostId = String.valueOf(interval.getValue());
            }
            catch (StateSystemDisposedException e) {
                interval = null;
                hostId = "";
            }
            this.fInterval = interval;
            this.fLastHostId = hostId;
            return hostId;
        }
    }

    public static final class AttributeValueHostResolver
    implements IHostIdResolver {
        private int fLevel;

        public AttributeValueHostResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @NonNull IHostIdProvider apply(ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            ArrayList<InstrumentedCallStackElement> elements = new ArrayList<InstrumentedCallStackElement>();
            InstrumentedCallStackElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                throw new IllegalArgumentException("The host should never resolve to null, level " + this.fLevel + " is not available");
            }
            InstrumentedCallStackElement stackElement = (InstrumentedCallStackElement)elements.get(this.fLevel);
            return new AttributeValueHostProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    public static interface IHostIdProvider
    extends Function<Long, String> {
    }

    public static interface IHostIdResolver
    extends Function<ICallStackElement, IHostIdProvider> {
    }

    private static class TraceHostIdProvider
    implements IHostIdProvider {
        private final String fHostId;

        public TraceHostIdProvider(String hostId) {
            this.fHostId = hostId;
        }

        @Override
        public @NonNull String apply(Long time) {
            return this.fHostId;
        }
    }

    public static final class TraceHostIdResolver
    implements IHostIdResolver {
        private final String fHostId;

        public TraceHostIdResolver(@Nullable ITmfTrace trace) {
            this.fHostId = trace == null ? "" : trace.getHostId();
        }

        @Override
        public @NonNull IHostIdProvider apply(ICallStackElement element) {
            return new TraceHostIdProvider(this.fHostId);
        }
    }
}

