/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack;

import java.util.regex.Pattern;
import org.eclipse.tracecompass.internal.analysis.profiling.core.base.ResolvableSymbol;
import org.eclipse.tracecompass.internal.analysis.profiling.core.base.StringSymbol;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackSymbol;

public final class CallStackSymbolFactory {
    private static final Pattern IS_NUMBER = Pattern.compile("[0-9A-Fa-f]+");

    private CallStackSymbolFactory() {
    }

    public static ICallStackSymbol createSymbol(Object symbol, ICallStackElement element, long timestamp) {
        String strSymbol;
        if (symbol instanceof Long || symbol instanceof Integer) {
            long longAddress = (Long)symbol;
            return new ResolvableSymbol(longAddress, element.getSymbolKeyAt(timestamp), timestamp);
        }
        if (symbol instanceof String && IS_NUMBER.matcher(strSymbol = (String)symbol).matches()) {
            try {
                long longAddress = Long.parseUnsignedLong(strSymbol, 16);
                return new ResolvableSymbol(longAddress, element.getSymbolKeyAt(timestamp), timestamp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new StringSymbol(symbol);
    }
}

