/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.BarycentricCrossingReducer;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.algorithms.SimpleLayerProvider;
import org.eclipse.gef4.layout.interfaces.CrossingReducer;
import org.eclipse.gef4.layout.interfaces.LayerProvider;
import org.eclipse.gef4.layout.interfaces.LayoutContext;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

public class SugiyamaLayoutAlgorithm
implements LayoutAlgorithm {
    private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();
    private final Direction direction;
    private final Dimension dimension;
    private LayoutContext context;
    private int last;
    private LayerProvider layerProvider;
    private CrossingReducer crossingReducer;

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim, LayerProvider layering, CrossingReducer crossing) {
        this.direction = dir;
        this.dimension = dim;
        this.layerProvider = layering == null ? new SimpleLayerProvider() : layering;
        this.crossingReducer = crossing == null ? new BarycentricCrossingReducer() : crossing;
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider, CrossingReducer crossing) {
        this(dir, null, layerProvider, crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider) {
        this(dir, null, layerProvider, new BarycentricCrossingReducer());
    }

    public SugiyamaLayoutAlgorithm(Direction dir, CrossingReducer crossing) {
        this(dir, null, null, crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim) {
        this(dir, dim, null, null);
    }

    public SugiyamaLayoutAlgorithm(Direction dir) {
        this(dir, null, null, null);
    }

    public SugiyamaLayoutAlgorithm() {
        this(Direction.VERTICAL, null, null, null);
    }

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    public LayoutContext getLayoutContext() {
        return this.context;
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.layers.clear();
        this.map.clear();
        ArrayList<NodeLayout> nodes = new ArrayList<NodeLayout>();
        ArrayList<NodeLayout> nodes2 = new ArrayList<NodeLayout>();
        NodeLayout[] nodeLayoutArray = this.context.getNodes();
        int n = nodeLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            nodes.add(node);
            nodes2.add(node);
            ++n2;
        }
        this.layers = this.layerProvider.calculateLayers(nodes);
        this.crossingReducer.crossReduction(this.layers);
        for (List<NodeWrapper> layer : this.layers) {
            if (layer.size() > this.last) {
                this.last = layer.size();
            }
            for (NodeWrapper nw : layer) {
                this.map.put(nw.node, nw);
            }
        }
        this.calculatePositions();
    }

    private void calculatePositions() {
        Rectangle boundary = this.context.getBounds();
        if (this.dimension != null) {
            boundary = new Rectangle(0.0, 0.0, this.dimension.getWidth(), this.dimension.getHeight());
        }
        double dx = boundary.getWidth() / (double)this.layers.size();
        double dy = boundary.getHeight() / (double)(this.last + 1);
        if (this.direction == Direction.HORIZONTAL) {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node = nodeLayoutArray[n2];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.layer + 0.5) * dx, ((double)nw.index + 0.5) * dy);
                ++n2;
            }
        } else {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n3 = 0;
            while (n3 < n) {
                NodeLayout node = nodeLayoutArray[n3];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.index + 0.5) * dx, ((double)nw.layer + 0.5) * dy);
                ++n3;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

