/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.graphimpl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class DotGenerator {
    private static final String[] colors = new String[]{"yellow", "blue", "red", "green", "gray", "cyan"};

    private DotGenerator() {
    }

    public static <V> String generateDot(Graph<V> graph, boolean colorSCCs, Function<V, String> nameFunction, Function<V, String> colorFunction, Function<V, Function<V, String>> edgeFunction) {
        HashMap<Object, String> colorMap = new HashMap<Object, String>();
        if (colorSCCs) {
            SCCResult<V> result = SCC.computeSCC(graph);
            Iterator<V> sccs = result.getSccs();
            int i = 0;
            Iterator<Object> iterator = sccs.iterator();
            while (iterator.hasNext()) {
                Set scc = (Set)iterator.next();
                if (scc.size() <= 1) continue;
                for (Object node : scc) {
                    String color = (String)colorMap.get(node);
                    if (color == null) {
                        colorMap.put(node, colors[i % colors.length]);
                        continue;
                    }
                    colorMap.put(node, String.valueOf((String)colorMap.get(node)) + ":" + colors[i % colors.length]);
                }
                ++i;
            }
            for (Object node : graph.getAllNodes()) {
                if (colorMap.containsKey(node)) continue;
                colorMap.put(node, "white");
            }
        } else {
            for (Object node : graph.getAllNodes()) {
                colorMap.put(node, "white");
            }
        }
        if (colorFunction != null) {
            for (Object node : graph.getAllNodes()) {
                colorMap.put(node, colorFunction.apply(node));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("digraph g {\n");
        for (V node : graph.getAllNodes()) {
            String nodePresentation = nameFunction == null ? node.toString() : nameFunction.apply(node);
            builder.append("\"" + nodePresentation + "\"");
            builder.append("[style=filled,fillcolor=" + (String)colorMap.get(node) + "]");
            builder.append(";\n");
        }
        for (V source : graph.getAllNodes()) {
            IMemoryView<V> targets = graph.getTargetNodes(source);
            if (targets.isEmpty()) continue;
            String sourcePresentation = nameFunction == null ? source.toString() : nameFunction.apply(source);
            for (Object target : targets.distinctValues()) {
                Function<V, String> v1;
                String edgeLabel = null;
                if (edgeFunction != null && (v1 = edgeFunction.apply(source)) != null) {
                    edgeLabel = v1.apply(target);
                }
                String targetPresentation = nameFunction == null ? target.toString() : nameFunction.apply(target);
                builder.append("\"" + sourcePresentation + "\" -> \"" + targetPresentation + "\"");
                if (edgeLabel != null) {
                    builder.append("[label=\"" + edgeLabel + "\"]");
                }
                builder.append(";\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static <V> String generateDot(Graph<V> graph) {
        return DotGenerator.generateDot(graph, false, null, null, null);
    }

    public static <V> Function<V, String> getNameShortener(final int maxLength) {
        return new Function<V, String>(){

            @Override
            public String apply(V obj) {
                String value = obj.toString();
                return value.substring(0, Math.min(value.length(), maxLength));
            }
        };
    }
}

