/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;

public class ActivationCodesConflictSet
implements ChangeableConflictSet {
    protected ActivationCodesMultiBiMap activationCodes;
    protected IStateCoder stateCoder;
    protected Set<Activation<?>> newActivations = new HashSet();
    protected Set<Activation<?>> removedActivations = new HashSet();
    private boolean isIncremental = false;
    private ConflictSet nextActivationsConflictSet;

    public void setIncremental(boolean isIncremental) {
        this.isIncremental = isIncremental;
    }

    public ActivationCodesConflictSet(ConflictSet nextActivationsConflictSet, IStateCoder stateCoder) {
        Objects.requireNonNull(nextActivationsConflictSet);
        this.nextActivationsConflictSet = nextActivationsConflictSet;
        this.stateCoder = stateCoder;
        this.activationCodes = new ActivationCodesMultiBiMap();
    }

    private Object createActivationCode(Activation<?> activation) {
        return this.stateCoder.createActivationCode((IPatternMatch)activation.getAtom());
    }

    public boolean removeActivation(Activation<?> activation) {
        if (this.isIncremental) {
            this.removedActivations.add(activation);
            this.newActivations.remove(activation);
        }
        return false;
    }

    public boolean addActivation(Activation<?> activation) {
        if (this.isIncremental) {
            this.newActivations.add(activation);
            this.removedActivations.remove(activation);
        }
        return false;
    }

    public Object getActivationId(Activation<?> activation) {
        return this.activationCodes.activationsToCodes.get(activation);
    }

    public Activation<?> getActivation(Object activationId) {
        Set<Activation<?>> activationsSet = this.activationCodes.codesToActivations.get(activationId);
        if (activationsSet == null || activationsSet.isEmpty()) {
            return null;
        }
        return activationsSet.iterator().next();
    }

    public void updateActivationCodes() {
        if (this.isIncremental) {
            for (Activation<?> activation : this.removedActivations) {
                this.activationCodes.removeActivaion(activation);
            }
            for (Activation<?> activation : this.newActivations) {
                if (activation.getState().isInactive()) continue;
                Object activationCode = this.createActivationCode(activation);
                this.activationCodes.addActivation(activation, activationCode);
            }
            this.removedActivations.clear();
            this.newActivations.clear();
        } else {
            this.activationCodes.clear();
            for (Activation activation : this.nextActivationsConflictSet.getNextActivations()) {
                Object activationCode = this.createActivationCode(activation);
                this.activationCodes.addActivation(activation, activationCode);
            }
        }
    }

    protected void reinitWithActivations(ConflictSet nextActivationsConflictSet) {
        this.nextActivationsConflictSet = nextActivationsConflictSet;
        this.activationCodes.clear();
        for (Activation activation : nextActivationsConflictSet.getNextActivations()) {
            Object activationCode = this.createActivationCode(activation);
            this.activationCodes.addActivation(activation, activationCode);
        }
    }

    public Activation<?> getNextActivation() {
        throw new UnsupportedOperationException();
    }

    public Set<Activation<?>> getNextActivations() {
        throw new UnsupportedOperationException();
    }

    public Set<Activation<?>> getConflictingActivations() {
        throw new UnsupportedOperationException();
    }

    public ConflictResolver getConflictResolver() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object activationCode : this.activationCodes.activationsToCodes.values()) {
            sb.append(activationCode);
            sb.append(" | ");
        }
        return sb.toString();
    }

    public Collection<Object> getCurrentActivationCodes() {
        return this.activationCodes.activationsToCodes.values();
    }

    private static class ActivationCodesMultiBiMap {
        public Map<Activation<?>, Object> activationsToCodes = new HashMap();
        public Map<Object, Set<Activation<?>>> codesToActivations = new HashMap();

        private ActivationCodesMultiBiMap() {
        }

        public void addActivation(Activation<?> activation, Object activationCode) {
            this.activationsToCodes.put(activation, activationCode);
            this.codesToActivations.computeIfAbsent(activationCode, k -> new HashSet()).add(activation);
        }

        public void removeActivaion(Activation<?> activation) {
            Object activationCode = this.activationsToCodes.remove(activation);
            Set<Activation<?>> activations = this.codesToActivations.get(activationCode);
            if (activations != null) {
                activations.remove(activation);
            }
        }

        public void clear() {
            this.activationsToCodes.clear();
            this.codesToActivations.clear();
        }
    }
}

