/**
 * Copyright (c) 2010-2015, Peter Lunk, Grill Balazs, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.testing.core;

import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.testing.snapshot.MatchSetRecord;
import org.eclipse.viatra.query.testing.snapshot.QuerySnapshot;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Fetches Snapshot match elements for a given QuerySpecification based on the specified QuerySnaphot instances.</p>
 * 
 * <b>Note</b> If no query scope is set up explicitly, the resource set of the snapshot model will be used as a test model scope.
 * 
 * @since 1.5.2
 */
@SuppressWarnings("all")
public class InitializedSnapshotMatchSetModelProvider implements IMatchSetModelProvider {
  private final Iterable<QuerySnapshot> qsnap;

  public InitializedSnapshotMatchSetModelProvider(final QuerySnapshot... qsnap) {
    this.qsnap = ((Iterable<QuerySnapshot>)Conversions.doWrapArray(qsnap));
  }

  @Override
  public <Match extends IPatternMatch> MatchSetRecord getMatchSetRecord(final EMFScope scope, final IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification, final Match filter) {
    final String FQN = querySpecification.getFullyQualifiedName();
    return this.<IPatternMatch>getMatchSetRecordsFromSnapshot(this.qsnap, FQN);
  }

  @Override
  public boolean updatedByModify() {
    return false;
  }

  @Override
  public <Match extends IPatternMatch> MatchSetRecord getMatchSetRecord(final ResourceSet resourceSet, final IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification, final Match filter) {
    final String FQN = querySpecification.getFullyQualifiedName();
    return this.<IPatternMatch>getMatchSetRecordsFromSnapshot(this.qsnap, FQN);
  }

  @Override
  public void dispose() {
  }

  private <Match extends IPatternMatch> MatchSetRecord getMatchSetRecordsFromSnapshot(final Iterable<QuerySnapshot> snapshot, final String FQN) {
    MatchSetRecord _xblockexpression = null;
    {
      boolean _isEmpty = IterableExtensions.isEmpty(snapshot);
      if (_isEmpty) {
        throw new IllegalArgumentException("The provided scope does not contain a Snapshot model");
      }
      QuerySnapshot _head = IterableExtensions.<QuerySnapshot>head(snapshot);
      EList<MatchSetRecord> _matchSetRecords = null;
      if (_head!=null) {
        _matchSetRecords=_head.getMatchSetRecords();
      }
      final Function1<MatchSetRecord, Boolean> _function = (MatchSetRecord it) -> {
        String _patternQualifiedName = it.getPatternQualifiedName();
        return Boolean.valueOf(Objects.equals(FQN, _patternQualifiedName));
      };
      final MatchSetRecord record = IterableExtensions.<MatchSetRecord>findFirst(_matchSetRecords, _function);
      if ((record == null)) {
        throw new IllegalArgumentException((("Could not find snapshot for " + FQN) + " in the provided scope"));
      }
      _xblockexpression = record;
    }
    return _xblockexpression;
  }
}
