/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class QueryResultViewUtil {
  /**
   * Constructor hidden for utility class
   */
  protected QueryResultViewUtil() {
  }

  public static Set<QueryRegistryTreeEntry> getRegistryEntriesFromSelection(final IStructuredSelection selection) {
    final HashSet<QueryRegistryTreeEntry> selectedQueries = CollectionLiterals.<QueryRegistryTreeEntry>newHashSet();
    final Procedure1<Object> _function = (Object it) -> {
      boolean _matched = false;
      if (it instanceof QueryRegistryTreeEntry) {
        _matched=true;
        selectedQueries.add(((QueryRegistryTreeEntry)it));
      }
      if (!_matched) {
        if (it instanceof QueryRegistryTreePackage) {
          _matched=true;
          selectedQueries.addAll(((QueryRegistryTreePackage)it).getEntries().values());
        }
      }
      if (!_matched) {
        if (it instanceof QueryRegistryTreeSource) {
          _matched=true;
          final Function1<QueryRegistryTreePackage, Collection<QueryRegistryTreeEntry>> _function_1 = (QueryRegistryTreePackage it_1) -> {
            return it_1.getEntries().values();
          };
          Iterables.<QueryRegistryTreeEntry>addAll(selectedQueries, Iterables.<QueryRegistryTreeEntry>concat(IterableExtensions.<QueryRegistryTreePackage, Collection<QueryRegistryTreeEntry>>map(((QueryRegistryTreeSource)it).getPackages().values(), _function_1)));
        }
      }
    };
    IteratorExtensions.<Object>forEach(selection.iterator(), _function);
    return selectedQueries;
  }

  public static Iterable<IQuerySpecificationRegistryEntry> unwrapEntries(final Set<QueryRegistryTreeEntry> entries) {
    final Function1<QueryRegistryTreeEntry, IQuerySpecificationRegistryEntry> _function = (QueryRegistryTreeEntry it) -> {
      return it.getEntry();
    };
    return IterableExtensions.<QueryRegistryTreeEntry, IQuerySpecificationRegistryEntry>map(entries, _function);
  }

  /**
   * @since 1.4
   */
  public static AdapterFactory getGenericAdapterFactory() {
    final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    ReflectiveItemProviderAdapterFactory _reflectiveItemProviderAdapterFactory = new ReflectiveItemProviderAdapterFactory();
    adapterFactory.addAdapterFactory(_reflectiveItemProviderAdapterFactory);
    return adapterFactory;
  }
}
